/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ModelDeploymentInstanceShapeConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ocpus")
    private final Float ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Float memoryInGBs;
    @JsonProperty(value="cpuBaseline")
    private final CpuBaseline cpuBaseline;

    @Deprecated
    @ConstructorProperties(value={"ocpus", "memoryInGBs", "cpuBaseline"})
    public ModelDeploymentInstanceShapeConfigDetails(Float ocpus, Float memoryInGBs, CpuBaseline cpuBaseline) {
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
        this.cpuBaseline = cpuBaseline;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Float getOcpus() {
        return this.ocpus;
    }

    public Float getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public CpuBaseline getCpuBaseline() {
        return this.cpuBaseline;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ModelDeploymentInstanceShapeConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", cpuBaseline=").append(String.valueOf((Object)this.cpuBaseline));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModelDeploymentInstanceShapeConfigDetails)) {
            return false;
        }
        ModelDeploymentInstanceShapeConfigDetails other = (ModelDeploymentInstanceShapeConfigDetails)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.cpuBaseline, (Object)other.cpuBaseline) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.cpuBaseline == null ? 43 : this.cpuBaseline.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CpuBaseline implements BmcEnum
    {
        Baseline18("BASELINE_1_8"),
        Baseline12("BASELINE_1_2"),
        Baseline11("BASELINE_1_1"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CpuBaseline> map;

        private CpuBaseline(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CpuBaseline create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CpuBaseline', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CpuBaseline.class);
            map = new HashMap<String, CpuBaseline>();
            for (CpuBaseline v : CpuBaseline.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Float ocpus;
        @JsonProperty(value="memoryInGBs")
        private Float memoryInGBs;
        @JsonProperty(value="cpuBaseline")
        private CpuBaseline cpuBaseline;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Float ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Float memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder cpuBaseline(CpuBaseline cpuBaseline) {
            this.cpuBaseline = cpuBaseline;
            this.__explicitlySet__.add("cpuBaseline");
            return this;
        }

        public ModelDeploymentInstanceShapeConfigDetails build() {
            ModelDeploymentInstanceShapeConfigDetails model = new ModelDeploymentInstanceShapeConfigDetails(this.ocpus, this.memoryInGBs, this.cpuBaseline);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ModelDeploymentInstanceShapeConfigDetails model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("cpuBaseline")) {
                this.cpuBaseline(model.getCpuBaseline());
            }
            return this;
        }
    }
}

