/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.PipelineContainerConfigurationDetails;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="containerType")
@JsonFilter(value="explicitlySetFilter")
public final class PipelineOcirContainerConfigurationDetails
extends PipelineContainerConfigurationDetails {
    @JsonProperty(value="image")
    private final String image;
    @JsonProperty(value="cmd")
    private final List<String> cmd;
    @JsonProperty(value="entrypoint")
    private final List<String> entrypoint;
    @JsonProperty(value="imageDigest")
    private final String imageDigest;
    @JsonProperty(value="imageSignatureId")
    private final String imageSignatureId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PipelineOcirContainerConfigurationDetails(String image, List<String> cmd, List<String> entrypoint, String imageDigest, String imageSignatureId) {
        this.image = image;
        this.cmd = cmd;
        this.entrypoint = entrypoint;
        this.imageDigest = imageDigest;
        this.imageSignatureId = imageSignatureId;
    }

    public String getImage() {
        return this.image;
    }

    public List<String> getCmd() {
        return this.cmd;
    }

    public List<String> getEntrypoint() {
        return this.entrypoint;
    }

    public String getImageDigest() {
        return this.imageDigest;
    }

    public String getImageSignatureId() {
        return this.imageSignatureId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PipelineOcirContainerConfigurationDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", image=").append(String.valueOf(this.image));
        sb.append(", cmd=").append(String.valueOf(this.cmd));
        sb.append(", entrypoint=").append(String.valueOf(this.entrypoint));
        sb.append(", imageDigest=").append(String.valueOf(this.imageDigest));
        sb.append(", imageSignatureId=").append(String.valueOf(this.imageSignatureId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PipelineOcirContainerConfigurationDetails)) {
            return false;
        }
        PipelineOcirContainerConfigurationDetails other = (PipelineOcirContainerConfigurationDetails)((Object)o);
        return Objects.equals(this.image, other.image) && Objects.equals(this.cmd, other.cmd) && Objects.equals(this.entrypoint, other.entrypoint) && Objects.equals(this.imageDigest, other.imageDigest) && Objects.equals(this.imageSignatureId, other.imageSignatureId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.cmd == null ? 43 : this.cmd.hashCode());
        result = result * 59 + (this.entrypoint == null ? 43 : this.entrypoint.hashCode());
        result = result * 59 + (this.imageDigest == null ? 43 : this.imageDigest.hashCode());
        result = result * 59 + (this.imageSignatureId == null ? 43 : this.imageSignatureId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="image")
        private String image;
        @JsonProperty(value="cmd")
        private List<String> cmd;
        @JsonProperty(value="entrypoint")
        private List<String> entrypoint;
        @JsonProperty(value="imageDigest")
        private String imageDigest;
        @JsonProperty(value="imageSignatureId")
        private String imageSignatureId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder image(String image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder cmd(List<String> cmd) {
            this.cmd = cmd;
            this.__explicitlySet__.add("cmd");
            return this;
        }

        public Builder entrypoint(List<String> entrypoint) {
            this.entrypoint = entrypoint;
            this.__explicitlySet__.add("entrypoint");
            return this;
        }

        public Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            this.__explicitlySet__.add("imageDigest");
            return this;
        }

        public Builder imageSignatureId(String imageSignatureId) {
            this.imageSignatureId = imageSignatureId;
            this.__explicitlySet__.add("imageSignatureId");
            return this;
        }

        public PipelineOcirContainerConfigurationDetails build() {
            PipelineOcirContainerConfigurationDetails model = new PipelineOcirContainerConfigurationDetails(this.image, this.cmd, this.entrypoint, this.imageDigest, this.imageSignatureId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PipelineOcirContainerConfigurationDetails model) {
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("cmd")) {
                this.cmd(model.getCmd());
            }
            if (model.wasPropertyExplicitlySet("entrypoint")) {
                this.entrypoint(model.getEntrypoint());
            }
            if (model.wasPropertyExplicitlySet("imageDigest")) {
                this.imageDigest(model.getImageDigest());
            }
            if (model.wasPropertyExplicitlySet("imageSignatureId")) {
                this.imageSignatureId(model.getImageSignatureId());
            }
            return this;
        }
    }
}

