/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.MetricExpressionRule;
import com.oracle.bmc.datascience.model.PredefinedExpressionThresholdScalingConfiguration;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="metricExpressionRuleType")
@JsonFilter(value="explicitlySetFilter")
public final class PredefinedMetricExpressionRule
extends MetricExpressionRule {
    @JsonProperty(value="metricType")
    private final MetricType metricType;
    @JsonProperty(value="scaleInConfiguration")
    private final PredefinedExpressionThresholdScalingConfiguration scaleInConfiguration;
    @JsonProperty(value="scaleOutConfiguration")
    private final PredefinedExpressionThresholdScalingConfiguration scaleOutConfiguration;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PredefinedMetricExpressionRule(MetricType metricType, PredefinedExpressionThresholdScalingConfiguration scaleInConfiguration, PredefinedExpressionThresholdScalingConfiguration scaleOutConfiguration) {
        this.metricType = metricType;
        this.scaleInConfiguration = scaleInConfiguration;
        this.scaleOutConfiguration = scaleOutConfiguration;
    }

    public MetricType getMetricType() {
        return this.metricType;
    }

    public PredefinedExpressionThresholdScalingConfiguration getScaleInConfiguration() {
        return this.scaleInConfiguration;
    }

    public PredefinedExpressionThresholdScalingConfiguration getScaleOutConfiguration() {
        return this.scaleOutConfiguration;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PredefinedMetricExpressionRule(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", metricType=").append(String.valueOf((Object)this.metricType));
        sb.append(", scaleInConfiguration=").append(String.valueOf((Object)this.scaleInConfiguration));
        sb.append(", scaleOutConfiguration=").append(String.valueOf((Object)this.scaleOutConfiguration));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PredefinedMetricExpressionRule)) {
            return false;
        }
        PredefinedMetricExpressionRule other = (PredefinedMetricExpressionRule)((Object)o);
        return Objects.equals((Object)this.metricType, (Object)other.metricType) && Objects.equals((Object)this.scaleInConfiguration, (Object)other.scaleInConfiguration) && Objects.equals((Object)this.scaleOutConfiguration, (Object)other.scaleOutConfiguration) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.metricType == null ? 43 : this.metricType.hashCode());
        result = result * 59 + (this.scaleInConfiguration == null ? 43 : this.scaleInConfiguration.hashCode());
        result = result * 59 + (this.scaleOutConfiguration == null ? 43 : this.scaleOutConfiguration.hashCode());
        return result;
    }

    public static enum MetricType implements BmcEnum
    {
        CpuUtilization("CPU_UTILIZATION"),
        MemoryUtilization("MEMORY_UTILIZATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MetricType> map;

        private MetricType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MetricType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MetricType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MetricType.class);
            map = new HashMap<String, MetricType>();
            for (MetricType v : MetricType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricType")
        private MetricType metricType;
        @JsonProperty(value="scaleInConfiguration")
        private PredefinedExpressionThresholdScalingConfiguration scaleInConfiguration;
        @JsonProperty(value="scaleOutConfiguration")
        private PredefinedExpressionThresholdScalingConfiguration scaleOutConfiguration;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricType(MetricType metricType) {
            this.metricType = metricType;
            this.__explicitlySet__.add("metricType");
            return this;
        }

        public Builder scaleInConfiguration(PredefinedExpressionThresholdScalingConfiguration scaleInConfiguration) {
            this.scaleInConfiguration = scaleInConfiguration;
            this.__explicitlySet__.add("scaleInConfiguration");
            return this;
        }

        public Builder scaleOutConfiguration(PredefinedExpressionThresholdScalingConfiguration scaleOutConfiguration) {
            this.scaleOutConfiguration = scaleOutConfiguration;
            this.__explicitlySet__.add("scaleOutConfiguration");
            return this;
        }

        public PredefinedMetricExpressionRule build() {
            PredefinedMetricExpressionRule model = new PredefinedMetricExpressionRule(this.metricType, this.scaleInConfiguration, this.scaleOutConfiguration);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PredefinedMetricExpressionRule model) {
            if (model.wasPropertyExplicitlySet("metricType")) {
                this.metricType(model.getMetricType());
            }
            if (model.wasPropertyExplicitlySet("scaleInConfiguration")) {
                this.scaleInConfiguration(model.getScaleInConfiguration());
            }
            if (model.wasPropertyExplicitlySet("scaleOutConfiguration")) {
                this.scaleOutConfiguration(model.getScaleOutConfiguration());
            }
            return this;
        }
    }
}

