/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datascience.model.AutoScalingPolicyDetails;
import com.oracle.bmc.datascience.model.MetricExpressionRule;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="autoScalingPolicyType")
@JsonFilter(value="explicitlySetFilter")
public final class ThresholdBasedAutoScalingPolicyDetails
extends AutoScalingPolicyDetails {
    @JsonProperty(value="rules")
    private final List<MetricExpressionRule> rules;
    @JsonProperty(value="maximumInstanceCount")
    private final Integer maximumInstanceCount;
    @JsonProperty(value="minimumInstanceCount")
    private final Integer minimumInstanceCount;
    @JsonProperty(value="initialInstanceCount")
    private final Integer initialInstanceCount;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ThresholdBasedAutoScalingPolicyDetails(List<MetricExpressionRule> rules, Integer maximumInstanceCount, Integer minimumInstanceCount, Integer initialInstanceCount) {
        this.rules = rules;
        this.maximumInstanceCount = maximumInstanceCount;
        this.minimumInstanceCount = minimumInstanceCount;
        this.initialInstanceCount = initialInstanceCount;
    }

    public List<MetricExpressionRule> getRules() {
        return this.rules;
    }

    public Integer getMaximumInstanceCount() {
        return this.maximumInstanceCount;
    }

    public Integer getMinimumInstanceCount() {
        return this.minimumInstanceCount;
    }

    public Integer getInitialInstanceCount() {
        return this.initialInstanceCount;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ThresholdBasedAutoScalingPolicyDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", rules=").append(String.valueOf(this.rules));
        sb.append(", maximumInstanceCount=").append(String.valueOf(this.maximumInstanceCount));
        sb.append(", minimumInstanceCount=").append(String.valueOf(this.minimumInstanceCount));
        sb.append(", initialInstanceCount=").append(String.valueOf(this.initialInstanceCount));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThresholdBasedAutoScalingPolicyDetails)) {
            return false;
        }
        ThresholdBasedAutoScalingPolicyDetails other = (ThresholdBasedAutoScalingPolicyDetails)((Object)o);
        return Objects.equals(this.rules, other.rules) && Objects.equals(this.maximumInstanceCount, other.maximumInstanceCount) && Objects.equals(this.minimumInstanceCount, other.minimumInstanceCount) && Objects.equals(this.initialInstanceCount, other.initialInstanceCount) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.rules == null ? 43 : this.rules.hashCode());
        result = result * 59 + (this.maximumInstanceCount == null ? 43 : this.maximumInstanceCount.hashCode());
        result = result * 59 + (this.minimumInstanceCount == null ? 43 : this.minimumInstanceCount.hashCode());
        result = result * 59 + (this.initialInstanceCount == null ? 43 : this.initialInstanceCount.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="rules")
        private List<MetricExpressionRule> rules;
        @JsonProperty(value="maximumInstanceCount")
        private Integer maximumInstanceCount;
        @JsonProperty(value="minimumInstanceCount")
        private Integer minimumInstanceCount;
        @JsonProperty(value="initialInstanceCount")
        private Integer initialInstanceCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder rules(List<MetricExpressionRule> rules) {
            this.rules = rules;
            this.__explicitlySet__.add("rules");
            return this;
        }

        public Builder maximumInstanceCount(Integer maximumInstanceCount) {
            this.maximumInstanceCount = maximumInstanceCount;
            this.__explicitlySet__.add("maximumInstanceCount");
            return this;
        }

        public Builder minimumInstanceCount(Integer minimumInstanceCount) {
            this.minimumInstanceCount = minimumInstanceCount;
            this.__explicitlySet__.add("minimumInstanceCount");
            return this;
        }

        public Builder initialInstanceCount(Integer initialInstanceCount) {
            this.initialInstanceCount = initialInstanceCount;
            this.__explicitlySet__.add("initialInstanceCount");
            return this;
        }

        public ThresholdBasedAutoScalingPolicyDetails build() {
            ThresholdBasedAutoScalingPolicyDetails model = new ThresholdBasedAutoScalingPolicyDetails(this.rules, this.maximumInstanceCount, this.minimumInstanceCount, this.initialInstanceCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ThresholdBasedAutoScalingPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("rules")) {
                this.rules(model.getRules());
            }
            if (model.wasPropertyExplicitlySet("maximumInstanceCount")) {
                this.maximumInstanceCount(model.getMaximumInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("minimumInstanceCount")) {
                this.minimumInstanceCount(model.getMinimumInstanceCount());
            }
            if (model.wasPropertyExplicitlySet("initialInstanceCount")) {
                this.initialInstanceCount(model.getInitialInstanceCount());
            }
            return this;
        }
    }
}

