/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CancelPipelineRunRequest
extends BmcRequest<Void> {
    private String pipelineRunId;
    private String opcRequestId;
    private String opcRetryToken;
    private String ifMatch;
    private Boolean terminateGracefully;

    public String getPipelineRunId() {
        return this.pipelineRunId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getTerminateGracefully() {
        return this.terminateGracefully;
    }

    public Builder toBuilder() {
        return new Builder().pipelineRunId(this.pipelineRunId).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken).ifMatch(this.ifMatch).terminateGracefully(this.terminateGracefully);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pipelineRunId=").append(String.valueOf(this.pipelineRunId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",terminateGracefully=").append(String.valueOf(this.terminateGracefully));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CancelPipelineRunRequest)) {
            return false;
        }
        CancelPipelineRunRequest other = (CancelPipelineRunRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pipelineRunId, other.pipelineRunId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.terminateGracefully, other.terminateGracefully);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineRunId == null ? 43 : this.pipelineRunId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.terminateGracefully == null ? 43 : this.terminateGracefully.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CancelPipelineRunRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pipelineRunId = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;
        private String ifMatch = null;
        private Boolean terminateGracefully = null;

        public Builder pipelineRunId(String pipelineRunId) {
            this.pipelineRunId = pipelineRunId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder terminateGracefully(Boolean terminateGracefully) {
            this.terminateGracefully = terminateGracefully;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CancelPipelineRunRequest o) {
            this.pipelineRunId(o.getPipelineRunId());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.ifMatch(o.getIfMatch());
            this.terminateGracefully(o.getTerminateGracefully());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CancelPipelineRunRequest build() {
            CancelPipelineRunRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public CancelPipelineRunRequest buildWithoutInvocationCallback() {
            CancelPipelineRunRequest request = new CancelPipelineRunRequest();
            request.pipelineRunId = this.pipelineRunId;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            request.ifMatch = this.ifMatch;
            request.terminateGracefully = this.terminateGracefully;
            return request;
        }
    }
}

