/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datascience.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteModelVersionSetRequest
extends BmcRequest<Void> {
    private String modelVersionSetId;
    private Boolean isDeleteRelatedModels;
    private String ifMatch;
    private String opcRequestId;

    public String getModelVersionSetId() {
        return this.modelVersionSetId;
    }

    public Boolean getIsDeleteRelatedModels() {
        return this.isDeleteRelatedModels;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().modelVersionSetId(this.modelVersionSetId).isDeleteRelatedModels(this.isDeleteRelatedModels).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",modelVersionSetId=").append(String.valueOf(this.modelVersionSetId));
        sb.append(",isDeleteRelatedModels=").append(String.valueOf(this.isDeleteRelatedModels));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteModelVersionSetRequest)) {
            return false;
        }
        DeleteModelVersionSetRequest other = (DeleteModelVersionSetRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.modelVersionSetId, other.modelVersionSetId) && Objects.equals(this.isDeleteRelatedModels, other.isDeleteRelatedModels) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.modelVersionSetId == null ? 43 : this.modelVersionSetId.hashCode());
        result = result * 59 + (this.isDeleteRelatedModels == null ? 43 : this.isDeleteRelatedModels.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteModelVersionSetRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String modelVersionSetId = null;
        private Boolean isDeleteRelatedModels = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder modelVersionSetId(String modelVersionSetId) {
            this.modelVersionSetId = modelVersionSetId;
            return this;
        }

        public Builder isDeleteRelatedModels(Boolean isDeleteRelatedModels) {
            this.isDeleteRelatedModels = isDeleteRelatedModels;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteModelVersionSetRequest o) {
            this.modelVersionSetId(o.getModelVersionSetId());
            this.isDeleteRelatedModels(o.getIsDeleteRelatedModels());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteModelVersionSetRequest build() {
            DeleteModelVersionSetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteModelVersionSetRequest buildWithoutInvocationCallback() {
            DeleteModelVersionSetRequest request = new DeleteModelVersionSetRequest();
            request.modelVersionSetId = this.modelVersionSetId;
            request.isDeleteRelatedModels = this.isDeleteRelatedModels;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

