/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.demandsignal;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.demandsignal.OccDemandSignal;
import com.oracle.bmc.demandsignal.OccDemandSignalPaginators;
import com.oracle.bmc.demandsignal.OccDemandSignalWaiters;
import com.oracle.bmc.demandsignal.model.OccDemandSignalCollection;
import com.oracle.bmc.demandsignal.requests.ChangeOccDemandSignalCompartmentRequest;
import com.oracle.bmc.demandsignal.requests.CreateOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.DeleteOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.GetOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.ListOccDemandSignalsRequest;
import com.oracle.bmc.demandsignal.requests.PatchOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.UpdateOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.responses.ChangeOccDemandSignalCompartmentResponse;
import com.oracle.bmc.demandsignal.responses.CreateOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.DeleteOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.GetOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.ListOccDemandSignalsResponse;
import com.oracle.bmc.demandsignal.responses.PatchOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.UpdateOccDemandSignalResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccDemandSignalClient
extends BaseSyncClient
implements OccDemandSignal {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCCDEMANDSIGNAL").serviceEndpointPrefix("").serviceEndpointTemplate("https://control-center-ds.{region}.oci.{secondLevelDomain}").endpointServiceName("control-center-ds").build();
    private static final Logger LOG = LoggerFactory.getLogger(OccDemandSignalClient.class);
    private final OccDemandSignalWaiters waiters;
    private final OccDemandSignalPaginators paginators;

    OccDemandSignalClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("OccDemandSignal-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new OccDemandSignalWaiters(executorService, this);
        this.paginators = new OccDemandSignalPaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ChangeOccDemandSignalCompartmentResponse changeOccDemandSignalCompartment(ChangeOccDemandSignalCompartmentRequest request) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOccDemandSignalCompartmentDetails(), "changeOccDemandSignalCompartmentDetails is required");
        return (ChangeOccDemandSignalCompartmentResponse)this.clientCall(request, ChangeOccDemandSignalCompartmentResponse::builder).logger(LOG, "changeOccDemandSignalCompartment").serviceDetails("OccDemandSignal", "ChangeOccDemandSignalCompartment", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/ChangeOccDemandSignalCompartment").method(Method.POST).requestBuilder(ChangeOccDemandSignalCompartmentRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOccDemandSignalCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOccDemandSignalCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOccDemandSignalResponse createOccDemandSignal(CreateOccDemandSignalRequest request) {
        Objects.requireNonNull(request.getCreateOccDemandSignalDetails(), "createOccDemandSignalDetails is required");
        return (CreateOccDemandSignalResponse)this.clientCall(request, CreateOccDemandSignalResponse::builder).logger(LOG, "createOccDemandSignal").serviceDetails("OccDemandSignal", "CreateOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/CreateOccDemandSignal").method(Method.POST).requestBuilder(CreateOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.demandsignal.model.OccDemandSignal.class, CreateOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", CreateOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", CreateOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccDemandSignalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteOccDemandSignalResponse deleteOccDemandSignal(DeleteOccDemandSignalRequest request) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        return (DeleteOccDemandSignalResponse)this.clientCall(request, DeleteOccDemandSignalResponse::builder).logger(LOG, "deleteOccDemandSignal").serviceDetails("OccDemandSignal", "DeleteOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/DeleteOccDemandSignal").method(Method.DELETE).requestBuilder(DeleteOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteOccDemandSignalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOccDemandSignalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetOccDemandSignalResponse getOccDemandSignal(GetOccDemandSignalRequest request) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        return (GetOccDemandSignalResponse)this.clientCall(request, GetOccDemandSignalResponse::builder).logger(LOG, "getOccDemandSignal").serviceDetails("OccDemandSignal", "GetOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/GetOccDemandSignal").method(Method.GET).requestBuilder(GetOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(com.oracle.bmc.demandsignal.model.OccDemandSignal.class, GetOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderString("etag", GetOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOccDemandSignalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListOccDemandSignalsResponse listOccDemandSignals(ListOccDemandSignalsRequest request) {
        return (ListOccDemandSignalsResponse)this.clientCall(request, ListOccDemandSignalsResponse::builder).logger(LOG, "listOccDemandSignals").serviceDetails("OccDemandSignal", "ListOccDemandSignals", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignalCollection/ListOccDemandSignals").method(Method.GET).requestBuilder(ListOccDemandSignalsRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(OccDemandSignalCollection.class, ListOccDemandSignalsResponse.Builder::occDemandSignalCollection).handleResponseHeaderString("opc-request-id", ListOccDemandSignalsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccDemandSignalsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public PatchOccDemandSignalResponse patchOccDemandSignal(PatchOccDemandSignalRequest request) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchOccDemandSignalDetails(), "patchOccDemandSignalDetails is required");
        return (PatchOccDemandSignalResponse)this.clientCall(request, PatchOccDemandSignalResponse::builder).logger(LOG, "patchOccDemandSignal").serviceDetails("OccDemandSignal", "PatchOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/PatchOccDemandSignal").method(Method.PATCH).requestBuilder(PatchOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.demandsignal.model.OccDemandSignal.class, PatchOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", PatchOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", PatchOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PatchOccDemandSignalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateOccDemandSignalResponse updateOccDemandSignal(UpdateOccDemandSignalRequest request) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOccDemandSignalDetails(), "updateOccDemandSignalDetails is required");
        return (UpdateOccDemandSignalResponse)this.clientCall(request, UpdateOccDemandSignalResponse::builder).logger(LOG, "updateOccDemandSignal").serviceDetails("OccDemandSignal", "UpdateOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/UpdateOccDemandSignal").method(Method.PUT).requestBuilder(UpdateOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(com.oracle.bmc.demandsignal.model.OccDemandSignal.class, UpdateOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", UpdateOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", UpdateOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccDemandSignalResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public OccDemandSignalWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public OccDemandSignalPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public OccDemandSignalClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OccDemandSignalClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OccDemandSignalClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public OccDemandSignalClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OccDemandSignalClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OccDemandSignalClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "demandsignal";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"demandsignal");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public OccDemandSignalClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OccDemandSignalClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

