/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.demandsignal;

import com.oracle.bmc.demandsignal.OccDemandSignal;
import com.oracle.bmc.demandsignal.model.OccDemandSignal;
import com.oracle.bmc.demandsignal.requests.GetOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.responses.GetOccDemandSignalResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class OccDemandSignalWaiters {
    private final ExecutorService executorService;
    private final OccDemandSignal client;

    public OccDemandSignalWaiters(ExecutorService executorService, OccDemandSignal client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetOccDemandSignalRequest, GetOccDemandSignalResponse> forOccDemandSignal(GetOccDemandSignalRequest request, OccDemandSignal.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forOccDemandSignal(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetOccDemandSignalRequest, GetOccDemandSignalResponse> forOccDemandSignal(GetOccDemandSignalRequest request, OccDemandSignal.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forOccDemandSignal(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetOccDemandSignalRequest, GetOccDemandSignalResponse> forOccDemandSignal(GetOccDemandSignalRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, OccDemandSignal.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forOccDemandSignal(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetOccDemandSignalRequest, GetOccDemandSignalResponse> forOccDemandSignal(BmcGenericWaiter waiter, GetOccDemandSignalRequest request, OccDemandSignal.LifecycleState ... targetStates) {
        final HashSet<OccDemandSignal.LifecycleState> targetStatesSet = new HashSet<OccDemandSignal.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetOccDemandSignalRequest, GetOccDemandSignalResponse>(){

            @Override
            public GetOccDemandSignalResponse apply(GetOccDemandSignalRequest request) {
                return OccDemandSignalWaiters.this.client.getOccDemandSignal(request);
            }
        }, (Predicate)new Predicate<GetOccDemandSignalResponse>(){

            @Override
            public boolean test(GetOccDemandSignalResponse response) {
                return targetStatesSet.contains((Object)response.getOccDemandSignal().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)OccDemandSignal.LifecycleState.Deleted)), (Object)request);
    }
}

