/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.demandsignal.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.demandsignal.model.OccDemandSignalValue;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class OccDemandSignalData
extends ExplicitlySetBmcModel {
    @JsonProperty(value="resourceType")
    private final String resourceType;
    @JsonProperty(value="units")
    private final String units;
    @JsonProperty(value="values")
    private final List<OccDemandSignalValue> values;

    @Deprecated
    @ConstructorProperties(value={"resourceType", "units", "values"})
    public OccDemandSignalData(String resourceType, String units, List<OccDemandSignalValue> values) {
        this.resourceType = resourceType;
        this.units = units;
        this.values = values;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public String getUnits() {
        return this.units;
    }

    public List<OccDemandSignalValue> getValues() {
        return this.values;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("OccDemandSignalData(");
        sb.append("super=").append(super.toString());
        sb.append("resourceType=").append(String.valueOf(this.resourceType));
        sb.append(", units=").append(String.valueOf(this.units));
        sb.append(", values=").append(String.valueOf(this.values));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OccDemandSignalData)) {
            return false;
        }
        OccDemandSignalData other = (OccDemandSignalData)((Object)o);
        return Objects.equals(this.resourceType, other.resourceType) && Objects.equals(this.units, other.units) && Objects.equals(this.values, other.values) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.resourceType == null ? 43 : this.resourceType.hashCode());
        result = result * 59 + (this.units == null ? 43 : this.units.hashCode());
        result = result * 59 + (this.values == null ? 43 : this.values.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="resourceType")
        private String resourceType;
        @JsonProperty(value="units")
        private String units;
        @JsonProperty(value="values")
        private List<OccDemandSignalValue> values;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.__explicitlySet__.add("resourceType");
            return this;
        }

        public Builder units(String units) {
            this.units = units;
            this.__explicitlySet__.add("units");
            return this;
        }

        public Builder values(List<OccDemandSignalValue> values) {
            this.values = values;
            this.__explicitlySet__.add("values");
            return this;
        }

        public OccDemandSignalData build() {
            OccDemandSignalData model = new OccDemandSignalData(this.resourceType, this.units, this.values);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(OccDemandSignalData model) {
            if (model.wasPropertyExplicitlySet("resourceType")) {
                this.resourceType(model.getResourceType());
            }
            if (model.wasPropertyExplicitlySet("units")) {
                this.units(model.getUnits());
            }
            if (model.wasPropertyExplicitlySet("values")) {
                this.values(model.getValues());
            }
            return this;
        }
    }
}

