/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.demandsignal;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.demandsignal.OccDemandSignalAsync;
import com.oracle.bmc.demandsignal.model.OccDemandSignal;
import com.oracle.bmc.demandsignal.model.OccDemandSignalCollection;
import com.oracle.bmc.demandsignal.requests.ChangeOccDemandSignalCompartmentRequest;
import com.oracle.bmc.demandsignal.requests.CreateOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.DeleteOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.GetOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.ListOccDemandSignalsRequest;
import com.oracle.bmc.demandsignal.requests.PatchOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.requests.UpdateOccDemandSignalRequest;
import com.oracle.bmc.demandsignal.responses.ChangeOccDemandSignalCompartmentResponse;
import com.oracle.bmc.demandsignal.responses.CreateOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.DeleteOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.GetOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.ListOccDemandSignalsResponse;
import com.oracle.bmc.demandsignal.responses.PatchOccDemandSignalResponse;
import com.oracle.bmc.demandsignal.responses.UpdateOccDemandSignalResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OccDemandSignalAsyncClient
extends BaseAsyncClient
implements OccDemandSignalAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("OCCDEMANDSIGNAL").serviceEndpointPrefix("").serviceEndpointTemplate("https://control-center-ds.{region}.oci.{secondLevelDomain}").endpointServiceName("control-center-ds").build();
    private static final Logger LOG = LoggerFactory.getLogger(OccDemandSignalAsyncClient.class);

    OccDemandSignalAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<ChangeOccDemandSignalCompartmentResponse> changeOccDemandSignalCompartment(ChangeOccDemandSignalCompartmentRequest request, AsyncHandler<ChangeOccDemandSignalCompartmentRequest, ChangeOccDemandSignalCompartmentResponse> handler) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeOccDemandSignalCompartmentDetails(), "changeOccDemandSignalCompartmentDetails is required");
        return this.clientCall(request, ChangeOccDemandSignalCompartmentResponse::builder).logger(LOG, "changeOccDemandSignalCompartment").serviceDetails("OccDemandSignal", "ChangeOccDemandSignalCompartment", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/ChangeOccDemandSignalCompartment").method(Method.POST).requestBuilder(ChangeOccDemandSignalCompartmentRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-work-request-id", ChangeOccDemandSignalCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeOccDemandSignalCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateOccDemandSignalResponse> createOccDemandSignal(CreateOccDemandSignalRequest request, AsyncHandler<CreateOccDemandSignalRequest, CreateOccDemandSignalResponse> handler) {
        Objects.requireNonNull(request.getCreateOccDemandSignalDetails(), "createOccDemandSignalDetails is required");
        return this.clientCall(request, CreateOccDemandSignalResponse::builder).logger(LOG, "createOccDemandSignal").serviceDetails("OccDemandSignal", "CreateOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/CreateOccDemandSignal").method(Method.POST).requestBuilder(CreateOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OccDemandSignal.class, CreateOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", CreateOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", CreateOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOccDemandSignalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteOccDemandSignalResponse> deleteOccDemandSignal(DeleteOccDemandSignalRequest request, AsyncHandler<DeleteOccDemandSignalRequest, DeleteOccDemandSignalResponse> handler) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteOccDemandSignalResponse::builder).logger(LOG, "deleteOccDemandSignal").serviceDetails("OccDemandSignal", "DeleteOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/DeleteOccDemandSignal").method(Method.DELETE).requestBuilder(DeleteOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-work-request-id", DeleteOccDemandSignalResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteOccDemandSignalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetOccDemandSignalResponse> getOccDemandSignal(GetOccDemandSignalRequest request, AsyncHandler<GetOccDemandSignalRequest, GetOccDemandSignalResponse> handler) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetOccDemandSignalResponse::builder).logger(LOG, "getOccDemandSignal").serviceDetails("OccDemandSignal", "GetOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/GetOccDemandSignal").method(Method.GET).requestBuilder(GetOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OccDemandSignal.class, GetOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderString("etag", GetOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetOccDemandSignalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListOccDemandSignalsResponse> listOccDemandSignals(ListOccDemandSignalsRequest request, AsyncHandler<ListOccDemandSignalsRequest, ListOccDemandSignalsResponse> handler) {
        return this.clientCall(request, ListOccDemandSignalsResponse::builder).logger(LOG, "listOccDemandSignals").serviceDetails("OccDemandSignal", "ListOccDemandSignals", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignalCollection/ListOccDemandSignals").method(Method.GET).requestBuilder(ListOccDemandSignalsRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(OccDemandSignalCollection.class, ListOccDemandSignalsResponse.Builder::occDemandSignalCollection).handleResponseHeaderString("opc-request-id", ListOccDemandSignalsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListOccDemandSignalsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<PatchOccDemandSignalResponse> patchOccDemandSignal(PatchOccDemandSignalRequest request, AsyncHandler<PatchOccDemandSignalRequest, PatchOccDemandSignalResponse> handler) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchOccDemandSignalDetails(), "patchOccDemandSignalDetails is required");
        return this.clientCall(request, PatchOccDemandSignalResponse::builder).logger(LOG, "patchOccDemandSignal").serviceDetails("OccDemandSignal", "PatchOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/PatchOccDemandSignal").method(Method.PATCH).requestBuilder(PatchOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OccDemandSignal.class, PatchOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", PatchOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", PatchOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", PatchOccDemandSignalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateOccDemandSignalResponse> updateOccDemandSignal(UpdateOccDemandSignalRequest request, AsyncHandler<UpdateOccDemandSignalRequest, UpdateOccDemandSignalResponse> handler) {
        Validate.notBlank((String)request.getOccDemandSignalId(), (String)"occDemandSignalId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateOccDemandSignalDetails(), "updateOccDemandSignalDetails is required");
        return this.clientCall(request, UpdateOccDemandSignalResponse::builder).logger(LOG, "updateOccDemandSignal").serviceDetails("OccDemandSignal", "UpdateOccDemandSignal", "https://docs.oracle.com/iaas/api/#/en/occds/20240430/OccDemandSignal/UpdateOccDemandSignal").method(Method.PUT).requestBuilder(UpdateOccDemandSignalRequest::builder).basePath("/20240430").appendPathParam("occDemandSignals").appendPathParam(request.getOccDemandSignalId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(OccDemandSignal.class, UpdateOccDemandSignalResponse.Builder::occDemandSignal).handleResponseHeaderInteger("retry-after", UpdateOccDemandSignalResponse.Builder::retryAfter).handleResponseHeaderString("etag", UpdateOccDemandSignalResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateOccDemandSignalResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)OccDemandSignalAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(OccDemandSignalAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)OccDemandSignalAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)OccDemandSignalAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)OccDemandSignalAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)OccDemandSignalAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public OccDemandSignalAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)OccDemandSignalAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, OccDemandSignalAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "demandsignal";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"demandsignal");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public OccDemandSignalAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new OccDemandSignalAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

