/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.desktops.DesktopServiceAsync;
import com.oracle.bmc.desktops.model.Desktop;
import com.oracle.bmc.desktops.model.DesktopCollection;
import com.oracle.bmc.desktops.model.DesktopPool;
import com.oracle.bmc.desktops.model.DesktopPoolCollection;
import com.oracle.bmc.desktops.model.DesktopPoolDesktopCollection;
import com.oracle.bmc.desktops.model.DesktopPoolVolumeCollection;
import com.oracle.bmc.desktops.model.WorkRequest;
import com.oracle.bmc.desktops.model.WorkRequestErrorCollection;
import com.oracle.bmc.desktops.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.desktops.model.WorkRequestSummaryCollection;
import com.oracle.bmc.desktops.requests.CancelWorkRequestRequest;
import com.oracle.bmc.desktops.requests.ChangeDesktopPoolCompartmentRequest;
import com.oracle.bmc.desktops.requests.CreateDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.DeleteDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.DeleteDesktopRequest;
import com.oracle.bmc.desktops.requests.GetDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.GetDesktopRequest;
import com.oracle.bmc.desktops.requests.GetWorkRequestRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolVolumesRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.desktops.requests.StartDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.StartDesktopRequest;
import com.oracle.bmc.desktops.requests.StopDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.StopDesktopRequest;
import com.oracle.bmc.desktops.requests.UpdateDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.UpdateDesktopRequest;
import com.oracle.bmc.desktops.responses.CancelWorkRequestResponse;
import com.oracle.bmc.desktops.responses.ChangeDesktopPoolCompartmentResponse;
import com.oracle.bmc.desktops.responses.CreateDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.DeleteDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.DeleteDesktopResponse;
import com.oracle.bmc.desktops.responses.GetDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.GetDesktopResponse;
import com.oracle.bmc.desktops.responses.GetWorkRequestResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolVolumesResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.desktops.responses.StartDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.StartDesktopResponse;
import com.oracle.bmc.desktops.responses.StopDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.StopDesktopResponse;
import com.oracle.bmc.desktops.responses.UpdateDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.UpdateDesktopResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopServiceAsyncClient
extends BaseAsyncClient
implements DesktopServiceAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DESKTOPSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://api.desktops.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DesktopServiceAsyncClient.class);

    DesktopServiceAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CancelWorkRequestResponse> cancelWorkRequest(CancelWorkRequestRequest request, AsyncHandler<CancelWorkRequestRequest, CancelWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("DesktopService", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDesktopPoolCompartmentResponse> changeDesktopPoolCompartment(ChangeDesktopPoolCompartmentRequest request, AsyncHandler<ChangeDesktopPoolCompartmentRequest, ChangeDesktopPoolCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDesktopPoolCompartmentDetails(), "changeDesktopPoolCompartmentDetails is required");
        return this.clientCall(request, ChangeDesktopPoolCompartmentResponse::builder).logger(LOG, "changeDesktopPoolCompartment").serviceDetails("DesktopService", "ChangeDesktopPoolCompartment", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ChangeDesktopPoolCompartment").method(Method.POST).requestBuilder(ChangeDesktopPoolCompartmentRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeDesktopPoolCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDesktopPoolCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDesktopPoolResponse> createDesktopPool(CreateDesktopPoolRequest request, AsyncHandler<CreateDesktopPoolRequest, CreateDesktopPoolResponse> handler) {
        Objects.requireNonNull(request.getCreateDesktopPoolDetails(), "createDesktopPoolDetails is required");
        return this.clientCall(request, CreateDesktopPoolResponse::builder).logger(LOG, "createDesktopPool").serviceDetails("DesktopService", "CreateDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/CreateDesktopPool").method(Method.POST).requestBuilder(CreateDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(DesktopPool.class, CreateDesktopPoolResponse.Builder::desktopPool).handleResponseHeaderString("opc-request-id", CreateDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDesktopPoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreateDesktopPoolResponse.Builder::location).handleResponseHeaderString("Content-Location", CreateDesktopPoolResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateDesktopPoolResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<DeleteDesktopResponse> deleteDesktop(DeleteDesktopRequest request, AsyncHandler<DeleteDesktopRequest, DeleteDesktopResponse> handler) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDesktopResponse::builder).logger(LOG, "deleteDesktop").serviceDetails("DesktopService", "DeleteDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/DeleteDesktop").method(Method.DELETE).requestBuilder(DeleteDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDesktopResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDesktopPoolResponse> deleteDesktopPool(DeleteDesktopPoolRequest request, AsyncHandler<DeleteDesktopPoolRequest, DeleteDesktopPoolResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDesktopPoolResponse::builder).logger(LOG, "deleteDesktopPool").serviceDetails("DesktopService", "DeleteDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/DeleteDesktopPool").method(Method.DELETE).requestBuilder(DeleteDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendQueryParam("areVolumesPreserved", (Object)request.getAreVolumesPreserved()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDesktopPoolResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDesktopResponse> getDesktop(GetDesktopRequest request, AsyncHandler<GetDesktopRequest, GetDesktopResponse> handler) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDesktopResponse::builder).logger(LOG, "getDesktop").serviceDetails("DesktopService", "GetDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/GetDesktop").method(Method.GET).requestBuilder(GetDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Desktop.class, GetDesktopResponse.Builder::desktop).handleResponseHeaderString("opc-request-id", GetDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDesktopResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetDesktopPoolResponse> getDesktopPool(GetDesktopPoolRequest request, AsyncHandler<GetDesktopPoolRequest, GetDesktopPoolResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDesktopPoolResponse::builder).logger(LOG, "getDesktopPool").serviceDetails("DesktopService", "GetDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/GetDesktopPool").method(Method.GET).requestBuilder(GetDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DesktopPool.class, GetDesktopPoolResponse.Builder::desktopPool).handleResponseHeaderString("opc-request-id", GetDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDesktopPoolResponse.Builder::etag).callAsync(handler);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DesktopService", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDesktopPoolDesktopsResponse> listDesktopPoolDesktops(ListDesktopPoolDesktopsRequest request, AsyncHandler<ListDesktopPoolDesktopsRequest, ListDesktopPoolDesktopsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDesktopPoolDesktopsResponse::builder).logger(LOG, "listDesktopPoolDesktops").serviceDetails("DesktopService", "ListDesktopPoolDesktops", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPoolDesktops").method(Method.GET).requestBuilder(ListDesktopPoolDesktopsRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("desktops").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DesktopPoolDesktopCollection.class, ListDesktopPoolDesktopsResponse.Builder::desktopPoolDesktopCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolDesktopsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolDesktopsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDesktopPoolVolumesResponse> listDesktopPoolVolumes(ListDesktopPoolVolumesRequest request, AsyncHandler<ListDesktopPoolVolumesRequest, ListDesktopPoolVolumesResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDesktopPoolVolumesResponse::builder).logger(LOG, "listDesktopPoolVolumes").serviceDetails("DesktopService", "ListDesktopPoolVolumes", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPoolVolumes").method(Method.GET).requestBuilder(ListDesktopPoolVolumesRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("volumes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DesktopPoolVolumeCollection.class, ListDesktopPoolVolumesResponse.Builder::desktopPoolVolumeCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolVolumesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolVolumesResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDesktopPoolsResponse> listDesktopPools(ListDesktopPoolsRequest request, AsyncHandler<ListDesktopPoolsRequest, ListDesktopPoolsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDesktopPoolsResponse::builder).logger(LOG, "listDesktopPools").serviceDetails("DesktopService", "ListDesktopPools", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPools").method(Method.GET).requestBuilder(ListDesktopPoolsRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DesktopPoolCollection.class, ListDesktopPoolsResponse.Builder::desktopPoolCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListDesktopsResponse> listDesktops(ListDesktopsRequest request, AsyncHandler<ListDesktopsRequest, ListDesktopsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDesktopsResponse::builder).logger(LOG, "listDesktops").serviceDetails("DesktopService", "ListDesktops", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/ListDesktops").method(Method.GET).requestBuilder(ListDesktopsRequest::builder).basePath("/20220618").appendPathParam("desktops").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("desktopPoolId", (Object)request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DesktopCollection.class, ListDesktopsResponse.Builder::desktopCollection).handleResponseHeaderString("opc-request-id", ListDesktopsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DesktopService", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DesktopService", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DesktopService", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<StartDesktopResponse> startDesktop(StartDesktopRequest request, AsyncHandler<StartDesktopRequest, StartDesktopResponse> handler) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartDesktopResponse::builder).logger(LOG, "startDesktop").serviceDetails("DesktopService", "StartDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/StartDesktop").method(Method.POST).requestBuilder(StartDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDesktopResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StartDesktopPoolResponse> startDesktopPool(StartDesktopPoolRequest request, AsyncHandler<StartDesktopPoolRequest, StartDesktopPoolResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StartDesktopPoolResponse::builder).logger(LOG, "startDesktopPool").serviceDetails("DesktopService", "StartDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/StartDesktopPool").method(Method.POST).requestBuilder(StartDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StartDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDesktopPoolResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopDesktopResponse> stopDesktop(StopDesktopRequest request, AsyncHandler<StopDesktopRequest, StopDesktopResponse> handler) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopDesktopResponse::builder).logger(LOG, "stopDesktop").serviceDetails("DesktopService", "StopDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/StopDesktop").method(Method.POST).requestBuilder(StopDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).appendPathParam("actions").appendPathParam("stop").appendQueryParam("isSoftStop", (Object)request.getIsSoftStop()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDesktopResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<StopDesktopPoolResponse> stopDesktopPool(StopDesktopPoolRequest request, AsyncHandler<StopDesktopPoolRequest, StopDesktopPoolResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, StopDesktopPoolResponse::builder).logger(LOG, "stopDesktopPool").serviceDetails("DesktopService", "StopDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/StopDesktopPool").method(Method.POST).requestBuilder(StopDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", StopDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDesktopPoolResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDesktopResponse> updateDesktop(UpdateDesktopRequest request, AsyncHandler<UpdateDesktopRequest, UpdateDesktopResponse> handler) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDesktopDetails(), "updateDesktopDetails is required");
        return this.clientCall(request, UpdateDesktopResponse::builder).logger(LOG, "updateDesktop").serviceDetails("DesktopService", "UpdateDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/UpdateDesktop").method(Method.PUT).requestBuilder(UpdateDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDesktopResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDesktopPoolResponse> updateDesktopPool(UpdateDesktopPoolRequest request, AsyncHandler<UpdateDesktopPoolRequest, UpdateDesktopPoolResponse> handler) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDesktopPoolDetails(), "updateDesktopPoolDetails is required");
        return this.clientCall(request, UpdateDesktopPoolResponse::builder).logger(LOG, "updateDesktopPool").serviceDetails("DesktopService", "UpdateDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/UpdateDesktopPool").method(Method.PUT).requestBuilder(UpdateDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleResponseHeaderString("opc-request-id", UpdateDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDesktopPoolResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Deprecated
    public DesktopServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DesktopServiceAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DesktopServiceAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DesktopServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DesktopServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DesktopServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DesktopServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DesktopServiceAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DesktopServiceAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DesktopServiceAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "desktops";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"desktops");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DesktopServiceAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DesktopServiceAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

