/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.desktops.DesktopService;
import com.oracle.bmc.desktops.DesktopServicePaginators;
import com.oracle.bmc.desktops.DesktopServiceWaiters;
import com.oracle.bmc.desktops.model.Desktop;
import com.oracle.bmc.desktops.model.DesktopCollection;
import com.oracle.bmc.desktops.model.DesktopPool;
import com.oracle.bmc.desktops.model.DesktopPoolCollection;
import com.oracle.bmc.desktops.model.DesktopPoolDesktopCollection;
import com.oracle.bmc.desktops.model.DesktopPoolVolumeCollection;
import com.oracle.bmc.desktops.model.WorkRequest;
import com.oracle.bmc.desktops.model.WorkRequestErrorCollection;
import com.oracle.bmc.desktops.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.desktops.model.WorkRequestSummaryCollection;
import com.oracle.bmc.desktops.requests.CancelWorkRequestRequest;
import com.oracle.bmc.desktops.requests.ChangeDesktopPoolCompartmentRequest;
import com.oracle.bmc.desktops.requests.CreateDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.DeleteDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.DeleteDesktopRequest;
import com.oracle.bmc.desktops.requests.GetDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.GetDesktopRequest;
import com.oracle.bmc.desktops.requests.GetWorkRequestRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolVolumesRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.desktops.requests.StartDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.StartDesktopRequest;
import com.oracle.bmc.desktops.requests.StopDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.StopDesktopRequest;
import com.oracle.bmc.desktops.requests.UpdateDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.UpdateDesktopRequest;
import com.oracle.bmc.desktops.responses.CancelWorkRequestResponse;
import com.oracle.bmc.desktops.responses.ChangeDesktopPoolCompartmentResponse;
import com.oracle.bmc.desktops.responses.CreateDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.DeleteDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.DeleteDesktopResponse;
import com.oracle.bmc.desktops.responses.GetDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.GetDesktopResponse;
import com.oracle.bmc.desktops.responses.GetWorkRequestResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolVolumesResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.desktops.responses.StartDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.StartDesktopResponse;
import com.oracle.bmc.desktops.responses.StopDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.StopDesktopResponse;
import com.oracle.bmc.desktops.responses.UpdateDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.UpdateDesktopResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DesktopServiceClient
extends BaseSyncClient
implements DesktopService {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DESKTOPSERVICE").serviceEndpointPrefix("").serviceEndpointTemplate("https://api.desktops.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DesktopServiceClient.class);
    private final DesktopServiceWaiters waiters;
    private final DesktopServicePaginators paginators;

    DesktopServiceClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("DesktopService-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DesktopServiceWaiters(executorService, this);
        this.paginators = new DesktopServicePaginators(this);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public CancelWorkRequestResponse cancelWorkRequest(CancelWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (CancelWorkRequestResponse)this.clientCall(request, CancelWorkRequestResponse::builder).logger(LOG, "cancelWorkRequest").serviceDetails("DesktopService", "CancelWorkRequest", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/CancelWorkRequest").method(Method.DELETE).requestBuilder(CancelWorkRequestRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", CancelWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeDesktopPoolCompartmentResponse changeDesktopPoolCompartment(ChangeDesktopPoolCompartmentRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDesktopPoolCompartmentDetails(), "changeDesktopPoolCompartmentDetails is required");
        return (ChangeDesktopPoolCompartmentResponse)this.clientCall(request, ChangeDesktopPoolCompartmentResponse::builder).logger(LOG, "changeDesktopPoolCompartment").serviceDetails("DesktopService", "ChangeDesktopPoolCompartment", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ChangeDesktopPoolCompartment").method(Method.POST).requestBuilder(ChangeDesktopPoolCompartmentRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", ChangeDesktopPoolCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDesktopPoolCompartmentResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public CreateDesktopPoolResponse createDesktopPool(CreateDesktopPoolRequest request) {
        Objects.requireNonNull(request.getCreateDesktopPoolDetails(), "createDesktopPoolDetails is required");
        return (CreateDesktopPoolResponse)this.clientCall(request, CreateDesktopPoolResponse::builder).logger(LOG, "createDesktopPool").serviceDetails("DesktopService", "CreateDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/CreateDesktopPool").method(Method.POST).requestBuilder(CreateDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DesktopPool.class, CreateDesktopPoolResponse.Builder::desktopPool).handleResponseHeaderString("opc-request-id", CreateDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDesktopPoolResponse.Builder::opcWorkRequestId).handleResponseHeaderString("Location", CreateDesktopPoolResponse.Builder::location).handleResponseHeaderString("Content-Location", CreateDesktopPoolResponse.Builder::contentLocation).handleResponseHeaderString("etag", CreateDesktopPoolResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteDesktopResponse deleteDesktop(DeleteDesktopRequest request) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return (DeleteDesktopResponse)this.clientCall(request, DeleteDesktopResponse::builder).logger(LOG, "deleteDesktop").serviceDetails("DesktopService", "DeleteDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/DeleteDesktop").method(Method.DELETE).requestBuilder(DeleteDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDesktopResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DeleteDesktopPoolResponse deleteDesktopPool(DeleteDesktopPoolRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return (DeleteDesktopPoolResponse)this.clientCall(request, DeleteDesktopPoolResponse::builder).logger(LOG, "deleteDesktopPool").serviceDetails("DesktopService", "DeleteDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/DeleteDesktopPool").method(Method.DELETE).requestBuilder(DeleteDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendQueryParam("areVolumesPreserved", (Object)request.getAreVolumesPreserved()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDesktopPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public GetDesktopResponse getDesktop(GetDesktopRequest request) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return (GetDesktopResponse)this.clientCall(request, GetDesktopResponse::builder).logger(LOG, "getDesktop").serviceDetails("DesktopService", "GetDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/GetDesktop").method(Method.GET).requestBuilder(GetDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Desktop.class, GetDesktopResponse.Builder::desktop).handleResponseHeaderString("opc-request-id", GetDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDesktopResponse.Builder::etag).callSync();
    }

    @Override
    public GetDesktopPoolResponse getDesktopPool(GetDesktopPoolRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return (GetDesktopPoolResponse)this.clientCall(request, GetDesktopPoolResponse::builder).logger(LOG, "getDesktopPool").serviceDetails("DesktopService", "GetDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/GetDesktopPool").method(Method.GET).requestBuilder(GetDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DesktopPool.class, GetDesktopPoolResponse.Builder::desktopPool).handleResponseHeaderString("opc-request-id", GetDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetDesktopPoolResponse.Builder::etag).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("DesktopService", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("etag", GetWorkRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListDesktopPoolDesktopsResponse listDesktopPoolDesktops(ListDesktopPoolDesktopsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return (ListDesktopPoolDesktopsResponse)this.clientCall(request, ListDesktopPoolDesktopsResponse::builder).logger(LOG, "listDesktopPoolDesktops").serviceDetails("DesktopService", "ListDesktopPoolDesktops", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPoolDesktops").method(Method.GET).requestBuilder(ListDesktopPoolDesktopsRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("desktops").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DesktopPoolDesktopCollection.class, ListDesktopPoolDesktopsResponse.Builder::desktopPoolDesktopCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolDesktopsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolDesktopsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDesktopPoolVolumesResponse listDesktopPoolVolumes(ListDesktopPoolVolumesRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDesktopPoolVolumesResponse)this.clientCall(request, ListDesktopPoolVolumesResponse::builder).logger(LOG, "listDesktopPoolVolumes").serviceDetails("DesktopService", "ListDesktopPoolVolumes", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPoolVolumes").method(Method.GET).requestBuilder(ListDesktopPoolVolumesRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("volumes").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DesktopPoolVolumeCollection.class, ListDesktopPoolVolumesResponse.Builder::desktopPoolVolumeCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolVolumesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolVolumesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDesktopPoolsResponse listDesktopPools(ListDesktopPoolsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDesktopPoolsResponse)this.clientCall(request, ListDesktopPoolsResponse::builder).logger(LOG, "listDesktopPools").serviceDetails("DesktopService", "ListDesktopPools", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/ListDesktopPools").method(Method.GET).requestBuilder(ListDesktopPoolsRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DesktopPoolCollection.class, ListDesktopPoolsResponse.Builder::desktopPoolCollection).handleResponseHeaderString("opc-request-id", ListDesktopPoolsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopPoolsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDesktopsResponse listDesktops(ListDesktopsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListDesktopsResponse)this.clientCall(request, ListDesktopsResponse::builder).logger(LOG, "listDesktops").serviceDetails("DesktopService", "ListDesktops", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/ListDesktops").method(Method.GET).requestBuilder(ListDesktopsRequest::builder).basePath("/20220618").appendPathParam("desktops").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("lifecycleState", (Object)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("desktopPoolId", (Object)request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DesktopCollection.class, ListDesktopsResponse.Builder::desktopCollection).handleResponseHeaderString("opc-request-id", ListDesktopsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDesktopsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("DesktopService", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("DesktopService", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("DesktopService", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20220618").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestSummaryCollection.class, ListWorkRequestsResponse.Builder::workRequestSummaryCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public StartDesktopResponse startDesktop(StartDesktopRequest request) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return (StartDesktopResponse)this.clientCall(request, StartDesktopResponse::builder).logger(LOG, "startDesktop").serviceDetails("DesktopService", "StartDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/StartDesktop").method(Method.POST).requestBuilder(StartDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDesktopResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StartDesktopPoolResponse startDesktopPool(StartDesktopPoolRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return (StartDesktopPoolResponse)this.clientCall(request, StartDesktopPoolResponse::builder).logger(LOG, "startDesktopPool").serviceDetails("DesktopService", "StartDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/StartDesktopPool").method(Method.POST).requestBuilder(StartDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("start").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StartDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StartDesktopPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopDesktopResponse stopDesktop(StopDesktopRequest request) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        return (StopDesktopResponse)this.clientCall(request, StopDesktopResponse::builder).logger(LOG, "stopDesktop").serviceDetails("DesktopService", "StopDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/StopDesktop").method(Method.POST).requestBuilder(StopDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).appendPathParam("actions").appendPathParam("stop").appendQueryParam("isSoftStop", (Object)request.getIsSoftStop()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDesktopResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public StopDesktopPoolResponse stopDesktopPool(StopDesktopPoolRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        return (StopDesktopPoolResponse)this.clientCall(request, StopDesktopPoolResponse::builder).logger(LOG, "stopDesktopPool").serviceDetails("DesktopService", "StopDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/StopDesktopPool").method(Method.POST).requestBuilder(StopDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).appendPathParam("actions").appendPathParam("stop").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", StopDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", StopDesktopPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateDesktopResponse updateDesktop(UpdateDesktopRequest request) {
        Validate.notBlank((String)request.getDesktopId(), (String)"desktopId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDesktopDetails(), "updateDesktopDetails is required");
        return (UpdateDesktopResponse)this.clientCall(request, UpdateDesktopResponse::builder).logger(LOG, "updateDesktop").serviceDetails("DesktopService", "UpdateDesktop", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/Desktop/UpdateDesktop").method(Method.PUT).requestBuilder(UpdateDesktopRequest::builder).basePath("/20220618").appendPathParam("desktops").appendPathParam(request.getDesktopId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateDesktopResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDesktopResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public UpdateDesktopPoolResponse updateDesktopPool(UpdateDesktopPoolRequest request) {
        Validate.notBlank((String)request.getDesktopPoolId(), (String)"desktopPoolId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDesktopPoolDetails(), "updateDesktopPoolDetails is required");
        return (UpdateDesktopPoolResponse)this.clientCall(request, UpdateDesktopPoolResponse::builder).logger(LOG, "updateDesktopPool").serviceDetails("DesktopService", "UpdateDesktopPool", "https://docs.oracle.com/iaas/api/#/en/secure-desktops/20220618/DesktopPool/UpdateDesktopPool").method(Method.PUT).requestBuilder(UpdateDesktopPoolRequest::builder).basePath("/20220618").appendPathParam("desktopPools").appendPathParam(request.getDesktopPoolId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", UpdateDesktopPoolResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateDesktopPoolResponse.Builder::opcWorkRequestId).callSync();
    }

    @Override
    public DesktopServiceWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DesktopServicePaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DesktopServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DesktopServiceClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DesktopServiceClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DesktopServiceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DesktopServiceClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DesktopServiceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "desktops";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"desktops");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DesktopServiceClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DesktopServiceClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService);
        }
    }
}

