/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops;

import com.oracle.bmc.desktops.DesktopService;
import com.oracle.bmc.desktops.model.DesktopPoolDesktopSummary;
import com.oracle.bmc.desktops.model.DesktopPoolSummary;
import com.oracle.bmc.desktops.model.DesktopPoolVolumeSummary;
import com.oracle.bmc.desktops.model.DesktopSummary;
import com.oracle.bmc.desktops.model.WorkRequestError;
import com.oracle.bmc.desktops.model.WorkRequestLogEntry;
import com.oracle.bmc.desktops.model.WorkRequestSummary;
import com.oracle.bmc.desktops.requests.ListDesktopPoolDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolVolumesRequest;
import com.oracle.bmc.desktops.requests.ListDesktopPoolsRequest;
import com.oracle.bmc.desktops.requests.ListDesktopsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.desktops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.desktops.responses.ListDesktopPoolDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolVolumesResponse;
import com.oracle.bmc.desktops.responses.ListDesktopPoolsResponse;
import com.oracle.bmc.desktops.responses.ListDesktopsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.desktops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DesktopServicePaginators {
    private final DesktopService client;

    public DesktopServicePaginators(DesktopService client) {
        this.client = client;
    }

    public Iterable<ListDesktopPoolDesktopsResponse> listDesktopPoolDesktopsResponseIterator(final ListDesktopPoolDesktopsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDesktopPoolDesktopsRequest.Builder>(){

            @Override
            public ListDesktopPoolDesktopsRequest.Builder get() {
                return ListDesktopPoolDesktopsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolDesktopsResponse, String>(){

            @Override
            public String apply(ListDesktopPoolDesktopsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolDesktopsRequest.Builder>, ListDesktopPoolDesktopsRequest>(){

            @Override
            public ListDesktopPoolDesktopsRequest apply(RequestBuilderAndToken<ListDesktopPoolDesktopsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolDesktopsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolDesktopsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolDesktopsRequest, ListDesktopPoolDesktopsResponse>(){

            @Override
            public ListDesktopPoolDesktopsResponse apply(ListDesktopPoolDesktopsRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPoolDesktops(request);
            }
        });
    }

    public Iterable<DesktopPoolDesktopSummary> listDesktopPoolDesktopsRecordIterator(final ListDesktopPoolDesktopsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDesktopPoolDesktopsRequest.Builder>(){

            @Override
            public ListDesktopPoolDesktopsRequest.Builder get() {
                return ListDesktopPoolDesktopsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolDesktopsResponse, String>(){

            @Override
            public String apply(ListDesktopPoolDesktopsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolDesktopsRequest.Builder>, ListDesktopPoolDesktopsRequest>(){

            @Override
            public ListDesktopPoolDesktopsRequest apply(RequestBuilderAndToken<ListDesktopPoolDesktopsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolDesktopsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolDesktopsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolDesktopsRequest, ListDesktopPoolDesktopsResponse>(){

            @Override
            public ListDesktopPoolDesktopsResponse apply(ListDesktopPoolDesktopsRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPoolDesktops(request);
            }
        }, (Function)new Function<ListDesktopPoolDesktopsResponse, List<DesktopPoolDesktopSummary>>(){

            @Override
            public List<DesktopPoolDesktopSummary> apply(ListDesktopPoolDesktopsResponse response) {
                return response.getDesktopPoolDesktopCollection().getItems();
            }
        });
    }

    public Iterable<ListDesktopPoolVolumesResponse> listDesktopPoolVolumesResponseIterator(final ListDesktopPoolVolumesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDesktopPoolVolumesRequest.Builder>(){

            @Override
            public ListDesktopPoolVolumesRequest.Builder get() {
                return ListDesktopPoolVolumesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolVolumesResponse, String>(){

            @Override
            public String apply(ListDesktopPoolVolumesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolVolumesRequest.Builder>, ListDesktopPoolVolumesRequest>(){

            @Override
            public ListDesktopPoolVolumesRequest apply(RequestBuilderAndToken<ListDesktopPoolVolumesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolVolumesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolVolumesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolVolumesRequest, ListDesktopPoolVolumesResponse>(){

            @Override
            public ListDesktopPoolVolumesResponse apply(ListDesktopPoolVolumesRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPoolVolumes(request);
            }
        });
    }

    public Iterable<DesktopPoolVolumeSummary> listDesktopPoolVolumesRecordIterator(final ListDesktopPoolVolumesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDesktopPoolVolumesRequest.Builder>(){

            @Override
            public ListDesktopPoolVolumesRequest.Builder get() {
                return ListDesktopPoolVolumesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolVolumesResponse, String>(){

            @Override
            public String apply(ListDesktopPoolVolumesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolVolumesRequest.Builder>, ListDesktopPoolVolumesRequest>(){

            @Override
            public ListDesktopPoolVolumesRequest apply(RequestBuilderAndToken<ListDesktopPoolVolumesRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolVolumesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolVolumesRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolVolumesRequest, ListDesktopPoolVolumesResponse>(){

            @Override
            public ListDesktopPoolVolumesResponse apply(ListDesktopPoolVolumesRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPoolVolumes(request);
            }
        }, (Function)new Function<ListDesktopPoolVolumesResponse, List<DesktopPoolVolumeSummary>>(){

            @Override
            public List<DesktopPoolVolumeSummary> apply(ListDesktopPoolVolumesResponse response) {
                return response.getDesktopPoolVolumeCollection().getItems();
            }
        });
    }

    public Iterable<ListDesktopPoolsResponse> listDesktopPoolsResponseIterator(final ListDesktopPoolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDesktopPoolsRequest.Builder>(){

            @Override
            public ListDesktopPoolsRequest.Builder get() {
                return ListDesktopPoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolsResponse, String>(){

            @Override
            public String apply(ListDesktopPoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolsRequest.Builder>, ListDesktopPoolsRequest>(){

            @Override
            public ListDesktopPoolsRequest apply(RequestBuilderAndToken<ListDesktopPoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolsRequest, ListDesktopPoolsResponse>(){

            @Override
            public ListDesktopPoolsResponse apply(ListDesktopPoolsRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPools(request);
            }
        });
    }

    public Iterable<DesktopPoolSummary> listDesktopPoolsRecordIterator(final ListDesktopPoolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDesktopPoolsRequest.Builder>(){

            @Override
            public ListDesktopPoolsRequest.Builder get() {
                return ListDesktopPoolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopPoolsResponse, String>(){

            @Override
            public String apply(ListDesktopPoolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopPoolsRequest.Builder>, ListDesktopPoolsRequest>(){

            @Override
            public ListDesktopPoolsRequest apply(RequestBuilderAndToken<ListDesktopPoolsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopPoolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopPoolsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopPoolsRequest, ListDesktopPoolsResponse>(){

            @Override
            public ListDesktopPoolsResponse apply(ListDesktopPoolsRequest request) {
                return DesktopServicePaginators.this.client.listDesktopPools(request);
            }
        }, (Function)new Function<ListDesktopPoolsResponse, List<DesktopPoolSummary>>(){

            @Override
            public List<DesktopPoolSummary> apply(ListDesktopPoolsResponse response) {
                return response.getDesktopPoolCollection().getItems();
            }
        });
    }

    public Iterable<ListDesktopsResponse> listDesktopsResponseIterator(final ListDesktopsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDesktopsRequest.Builder>(){

            @Override
            public ListDesktopsRequest.Builder get() {
                return ListDesktopsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopsResponse, String>(){

            @Override
            public String apply(ListDesktopsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopsRequest.Builder>, ListDesktopsRequest>(){

            @Override
            public ListDesktopsRequest apply(RequestBuilderAndToken<ListDesktopsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopsRequest, ListDesktopsResponse>(){

            @Override
            public ListDesktopsResponse apply(ListDesktopsRequest request) {
                return DesktopServicePaginators.this.client.listDesktops(request);
            }
        });
    }

    public Iterable<DesktopSummary> listDesktopsRecordIterator(final ListDesktopsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDesktopsRequest.Builder>(){

            @Override
            public ListDesktopsRequest.Builder get() {
                return ListDesktopsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDesktopsResponse, String>(){

            @Override
            public String apply(ListDesktopsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDesktopsRequest.Builder>, ListDesktopsRequest>(){

            @Override
            public ListDesktopsRequest apply(RequestBuilderAndToken<ListDesktopsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListDesktopsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDesktopsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListDesktopsRequest, ListDesktopsResponse>(){

            @Override
            public ListDesktopsResponse apply(ListDesktopsRequest request) {
                return DesktopServicePaginators.this.client.listDesktops(request);
            }
        }, (Function)new Function<ListDesktopsResponse, List<DesktopSummary>>(){

            @Override
            public List<DesktopSummary> apply(ListDesktopsResponse response) {
                return response.getDesktopCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            @Override
            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            @Override
            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            @Override
            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            @Override
            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            @Override
            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            @Override
            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            @Override
            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            @Override
            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            @Override
            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            @Override
            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogEntryCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            @Override
            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            @Override
            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            @Override
            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            @Override
            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DesktopServicePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            @Override
            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestSummaryCollection().getItems();
            }
        });
    }
}

