/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops;

import com.oracle.bmc.desktops.DesktopService;
import com.oracle.bmc.desktops.model.LifecycleState;
import com.oracle.bmc.desktops.requests.GetDesktopPoolRequest;
import com.oracle.bmc.desktops.requests.GetDesktopRequest;
import com.oracle.bmc.desktops.requests.GetWorkRequestRequest;
import com.oracle.bmc.desktops.responses.GetDesktopPoolResponse;
import com.oracle.bmc.desktops.responses.GetDesktopResponse;
import com.oracle.bmc.desktops.responses.GetWorkRequestResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class DesktopServiceWaiters {
    private final ExecutorService executorService;
    private final DesktopService client;

    public DesktopServiceWaiters(ExecutorService executorService, DesktopService client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetDesktopRequest, GetDesktopResponse> forDesktop(GetDesktopRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDesktop(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDesktopRequest, GetDesktopResponse> forDesktop(GetDesktopRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDesktop(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDesktopRequest, GetDesktopResponse> forDesktop(GetDesktopRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDesktop(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDesktopRequest, GetDesktopResponse> forDesktop(BmcGenericWaiter waiter, GetDesktopRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDesktopRequest, GetDesktopResponse>(){

            @Override
            public GetDesktopResponse apply(GetDesktopRequest request) {
                return DesktopServiceWaiters.this.client.getDesktop(request);
            }
        }, (Predicate)new Predicate<GetDesktopResponse>(){

            @Override
            public boolean test(GetDesktopResponse response) {
                return targetStatesSet.contains((Object)response.getDesktop().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDesktopPoolRequest, GetDesktopPoolResponse> forDesktopPool(GetDesktopPoolRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDesktopPool(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDesktopPoolRequest, GetDesktopPoolResponse> forDesktopPool(GetDesktopPoolRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDesktopPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDesktopPoolRequest, GetDesktopPoolResponse> forDesktopPool(GetDesktopPoolRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDesktopPool(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDesktopPoolRequest, GetDesktopPoolResponse> forDesktopPool(BmcGenericWaiter waiter, GetDesktopPoolRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetDesktopPoolRequest, GetDesktopPoolResponse>(){

            @Override
            public GetDesktopPoolResponse apply(GetDesktopPoolRequest request) {
                return DesktopServiceWaiters.this.client.getDesktopPool(request);
            }
        }, (Predicate)new Predicate<GetDesktopPoolResponse>(){

            @Override
            public boolean test(GetDesktopPoolResponse response) {
                return targetStatesSet.contains((Object)response.getDesktopPool().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            @Override
            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return DesktopServiceWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            @Override
            public boolean test(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }
}

