/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateDesktopPoolShapeConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="ocpus")
    private final Long ocpus;
    @JsonProperty(value="memoryInGBs")
    private final Long memoryInGBs;
    @JsonProperty(value="baselineOcpuUtilization")
    private final BaselineOcpuUtilization baselineOcpuUtilization;

    @Deprecated
    @ConstructorProperties(value={"ocpus", "memoryInGBs", "baselineOcpuUtilization"})
    public CreateDesktopPoolShapeConfigDetails(Long ocpus, Long memoryInGBs, BaselineOcpuUtilization baselineOcpuUtilization) {
        this.ocpus = ocpus;
        this.memoryInGBs = memoryInGBs;
        this.baselineOcpuUtilization = baselineOcpuUtilization;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Long getOcpus() {
        return this.ocpus;
    }

    public Long getMemoryInGBs() {
        return this.memoryInGBs;
    }

    public BaselineOcpuUtilization getBaselineOcpuUtilization() {
        return this.baselineOcpuUtilization;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateDesktopPoolShapeConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("ocpus=").append(String.valueOf(this.ocpus));
        sb.append(", memoryInGBs=").append(String.valueOf(this.memoryInGBs));
        sb.append(", baselineOcpuUtilization=").append(String.valueOf((Object)this.baselineOcpuUtilization));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDesktopPoolShapeConfigDetails)) {
            return false;
        }
        CreateDesktopPoolShapeConfigDetails other = (CreateDesktopPoolShapeConfigDetails)((Object)o);
        return Objects.equals(this.ocpus, other.ocpus) && Objects.equals(this.memoryInGBs, other.memoryInGBs) && Objects.equals((Object)this.baselineOcpuUtilization, (Object)other.baselineOcpuUtilization) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.ocpus == null ? 43 : this.ocpus.hashCode());
        result = result * 59 + (this.memoryInGBs == null ? 43 : this.memoryInGBs.hashCode());
        result = result * 59 + (this.baselineOcpuUtilization == null ? 43 : this.baselineOcpuUtilization.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum BaselineOcpuUtilization implements BmcEnum
    {
        Baseline18("BASELINE_1_8"),
        Baseline12("BASELINE_1_2"),
        Baseline11("BASELINE_1_1");

        private final String value;
        private static Map<String, BaselineOcpuUtilization> map;

        private BaselineOcpuUtilization(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static BaselineOcpuUtilization create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid BaselineOcpuUtilization: " + key);
        }

        static {
            map = new HashMap<String, BaselineOcpuUtilization>();
            for (BaselineOcpuUtilization v : BaselineOcpuUtilization.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ocpus")
        private Long ocpus;
        @JsonProperty(value="memoryInGBs")
        private Long memoryInGBs;
        @JsonProperty(value="baselineOcpuUtilization")
        private BaselineOcpuUtilization baselineOcpuUtilization;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ocpus(Long ocpus) {
            this.ocpus = ocpus;
            this.__explicitlySet__.add("ocpus");
            return this;
        }

        public Builder memoryInGBs(Long memoryInGBs) {
            this.memoryInGBs = memoryInGBs;
            this.__explicitlySet__.add("memoryInGBs");
            return this;
        }

        public Builder baselineOcpuUtilization(BaselineOcpuUtilization baselineOcpuUtilization) {
            this.baselineOcpuUtilization = baselineOcpuUtilization;
            this.__explicitlySet__.add("baselineOcpuUtilization");
            return this;
        }

        public CreateDesktopPoolShapeConfigDetails build() {
            CreateDesktopPoolShapeConfigDetails model = new CreateDesktopPoolShapeConfigDetails(this.ocpus, this.memoryInGBs, this.baselineOcpuUtilization);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateDesktopPoolShapeConfigDetails model) {
            if (model.wasPropertyExplicitlySet("ocpus")) {
                this.ocpus(model.getOcpus());
            }
            if (model.wasPropertyExplicitlySet("memoryInGBs")) {
                this.memoryInGBs(model.getMemoryInGBs());
            }
            if (model.wasPropertyExplicitlySet("baselineOcpuUtilization")) {
                this.baselineOcpuUtilization(model.getBaselineOcpuUtilization());
            }
            return this;
        }
    }
}

