/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DesktopDevicePolicy
extends ExplicitlySetBmcModel {
    @JsonProperty(value="clipboardMode")
    private final ClipboardMode clipboardMode;
    @JsonProperty(value="audioMode")
    private final AudioMode audioMode;
    @JsonProperty(value="cdmMode")
    private final CdmMode cdmMode;
    @JsonProperty(value="isPrintingEnabled")
    private final Boolean isPrintingEnabled;
    @JsonProperty(value="isPointerEnabled")
    private final Boolean isPointerEnabled;
    @JsonProperty(value="isKeyboardEnabled")
    private final Boolean isKeyboardEnabled;
    @JsonProperty(value="isDisplayEnabled")
    private final Boolean isDisplayEnabled;

    @Deprecated
    @ConstructorProperties(value={"clipboardMode", "audioMode", "cdmMode", "isPrintingEnabled", "isPointerEnabled", "isKeyboardEnabled", "isDisplayEnabled"})
    public DesktopDevicePolicy(ClipboardMode clipboardMode, AudioMode audioMode, CdmMode cdmMode, Boolean isPrintingEnabled, Boolean isPointerEnabled, Boolean isKeyboardEnabled, Boolean isDisplayEnabled) {
        this.clipboardMode = clipboardMode;
        this.audioMode = audioMode;
        this.cdmMode = cdmMode;
        this.isPrintingEnabled = isPrintingEnabled;
        this.isPointerEnabled = isPointerEnabled;
        this.isKeyboardEnabled = isKeyboardEnabled;
        this.isDisplayEnabled = isDisplayEnabled;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public ClipboardMode getClipboardMode() {
        return this.clipboardMode;
    }

    public AudioMode getAudioMode() {
        return this.audioMode;
    }

    public CdmMode getCdmMode() {
        return this.cdmMode;
    }

    public Boolean getIsPrintingEnabled() {
        return this.isPrintingEnabled;
    }

    public Boolean getIsPointerEnabled() {
        return this.isPointerEnabled;
    }

    public Boolean getIsKeyboardEnabled() {
        return this.isKeyboardEnabled;
    }

    public Boolean getIsDisplayEnabled() {
        return this.isDisplayEnabled;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DesktopDevicePolicy(");
        sb.append("super=").append(super.toString());
        sb.append("clipboardMode=").append(String.valueOf((Object)this.clipboardMode));
        sb.append(", audioMode=").append(String.valueOf((Object)this.audioMode));
        sb.append(", cdmMode=").append(String.valueOf((Object)this.cdmMode));
        sb.append(", isPrintingEnabled=").append(String.valueOf(this.isPrintingEnabled));
        sb.append(", isPointerEnabled=").append(String.valueOf(this.isPointerEnabled));
        sb.append(", isKeyboardEnabled=").append(String.valueOf(this.isKeyboardEnabled));
        sb.append(", isDisplayEnabled=").append(String.valueOf(this.isDisplayEnabled));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesktopDevicePolicy)) {
            return false;
        }
        DesktopDevicePolicy other = (DesktopDevicePolicy)((Object)o);
        return Objects.equals((Object)this.clipboardMode, (Object)other.clipboardMode) && Objects.equals((Object)this.audioMode, (Object)other.audioMode) && Objects.equals((Object)this.cdmMode, (Object)other.cdmMode) && Objects.equals(this.isPrintingEnabled, other.isPrintingEnabled) && Objects.equals(this.isPointerEnabled, other.isPointerEnabled) && Objects.equals(this.isKeyboardEnabled, other.isKeyboardEnabled) && Objects.equals(this.isDisplayEnabled, other.isDisplayEnabled) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.clipboardMode == null ? 43 : this.clipboardMode.hashCode());
        result = result * 59 + (this.audioMode == null ? 43 : this.audioMode.hashCode());
        result = result * 59 + (this.cdmMode == null ? 43 : this.cdmMode.hashCode());
        result = result * 59 + (this.isPrintingEnabled == null ? 43 : this.isPrintingEnabled.hashCode());
        result = result * 59 + (this.isPointerEnabled == null ? 43 : this.isPointerEnabled.hashCode());
        result = result * 59 + (this.isKeyboardEnabled == null ? 43 : this.isKeyboardEnabled.hashCode());
        result = result * 59 + (this.isDisplayEnabled == null ? 43 : this.isDisplayEnabled.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CdmMode implements BmcEnum
    {
        None("NONE"),
        Readonly("READONLY"),
        Full("FULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CdmMode> map;

        private CdmMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CdmMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CdmMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CdmMode.class);
            map = new HashMap<String, CdmMode>();
            for (CdmMode v : CdmMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AudioMode implements BmcEnum
    {
        None("NONE"),
        Todesktop("TODESKTOP"),
        Fromdesktop("FROMDESKTOP"),
        Full("FULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AudioMode> map;

        private AudioMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AudioMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AudioMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AudioMode.class);
            map = new HashMap<String, AudioMode>();
            for (AudioMode v : AudioMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ClipboardMode implements BmcEnum
    {
        None("NONE"),
        Todesktop("TODESKTOP"),
        Fromdesktop("FROMDESKTOP"),
        Full("FULL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ClipboardMode> map;

        private ClipboardMode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ClipboardMode create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ClipboardMode', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ClipboardMode.class);
            map = new HashMap<String, ClipboardMode>();
            for (ClipboardMode v : ClipboardMode.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="clipboardMode")
        private ClipboardMode clipboardMode;
        @JsonProperty(value="audioMode")
        private AudioMode audioMode;
        @JsonProperty(value="cdmMode")
        private CdmMode cdmMode;
        @JsonProperty(value="isPrintingEnabled")
        private Boolean isPrintingEnabled;
        @JsonProperty(value="isPointerEnabled")
        private Boolean isPointerEnabled;
        @JsonProperty(value="isKeyboardEnabled")
        private Boolean isKeyboardEnabled;
        @JsonProperty(value="isDisplayEnabled")
        private Boolean isDisplayEnabled;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder clipboardMode(ClipboardMode clipboardMode) {
            this.clipboardMode = clipboardMode;
            this.__explicitlySet__.add("clipboardMode");
            return this;
        }

        public Builder audioMode(AudioMode audioMode) {
            this.audioMode = audioMode;
            this.__explicitlySet__.add("audioMode");
            return this;
        }

        public Builder cdmMode(CdmMode cdmMode) {
            this.cdmMode = cdmMode;
            this.__explicitlySet__.add("cdmMode");
            return this;
        }

        public Builder isPrintingEnabled(Boolean isPrintingEnabled) {
            this.isPrintingEnabled = isPrintingEnabled;
            this.__explicitlySet__.add("isPrintingEnabled");
            return this;
        }

        public Builder isPointerEnabled(Boolean isPointerEnabled) {
            this.isPointerEnabled = isPointerEnabled;
            this.__explicitlySet__.add("isPointerEnabled");
            return this;
        }

        public Builder isKeyboardEnabled(Boolean isKeyboardEnabled) {
            this.isKeyboardEnabled = isKeyboardEnabled;
            this.__explicitlySet__.add("isKeyboardEnabled");
            return this;
        }

        public Builder isDisplayEnabled(Boolean isDisplayEnabled) {
            this.isDisplayEnabled = isDisplayEnabled;
            this.__explicitlySet__.add("isDisplayEnabled");
            return this;
        }

        public DesktopDevicePolicy build() {
            DesktopDevicePolicy model = new DesktopDevicePolicy(this.clipboardMode, this.audioMode, this.cdmMode, this.isPrintingEnabled, this.isPointerEnabled, this.isKeyboardEnabled, this.isDisplayEnabled);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DesktopDevicePolicy model) {
            if (model.wasPropertyExplicitlySet("clipboardMode")) {
                this.clipboardMode(model.getClipboardMode());
            }
            if (model.wasPropertyExplicitlySet("audioMode")) {
                this.audioMode(model.getAudioMode());
            }
            if (model.wasPropertyExplicitlySet("cdmMode")) {
                this.cdmMode(model.getCdmMode());
            }
            if (model.wasPropertyExplicitlySet("isPrintingEnabled")) {
                this.isPrintingEnabled(model.getIsPrintingEnabled());
            }
            if (model.wasPropertyExplicitlySet("isPointerEnabled")) {
                this.isPointerEnabled(model.getIsPointerEnabled());
            }
            if (model.wasPropertyExplicitlySet("isKeyboardEnabled")) {
                this.isKeyboardEnabled(model.getIsKeyboardEnabled());
            }
            if (model.wasPropertyExplicitlySet("isDisplayEnabled")) {
                this.isDisplayEnabled(model.getIsDisplayEnabled());
            }
            return this;
        }
    }
}

