/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DesktopImage
extends ExplicitlySetBmcModel {
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="imageName")
    private final String imageName;
    @JsonProperty(value="operatingSystem")
    private final String operatingSystem;

    @Deprecated
    @ConstructorProperties(value={"imageId", "imageName", "operatingSystem"})
    public DesktopImage(String imageId, String imageName, String operatingSystem) {
        this.imageId = imageId;
        this.imageName = imageName;
        this.operatingSystem = operatingSystem;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getImageId() {
        return this.imageId;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DesktopImage(");
        sb.append("super=").append(super.toString());
        sb.append("imageId=").append(String.valueOf(this.imageId));
        sb.append(", imageName=").append(String.valueOf(this.imageName));
        sb.append(", operatingSystem=").append(String.valueOf(this.operatingSystem));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesktopImage)) {
            return false;
        }
        DesktopImage other = (DesktopImage)((Object)o);
        return Objects.equals(this.imageId, other.imageId) && Objects.equals(this.imageName, other.imageName) && Objects.equals(this.operatingSystem, other.operatingSystem) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.imageName == null ? 43 : this.imageName.hashCode());
        result = result * 59 + (this.operatingSystem == null ? 43 : this.operatingSystem.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="imageName")
        private String imageName;
        @JsonProperty(value="operatingSystem")
        private String operatingSystem;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder imageName(String imageName) {
            this.imageName = imageName;
            this.__explicitlySet__.add("imageName");
            return this;
        }

        public Builder operatingSystem(String operatingSystem) {
            this.operatingSystem = operatingSystem;
            this.__explicitlySet__.add("operatingSystem");
            return this;
        }

        public DesktopImage build() {
            DesktopImage model = new DesktopImage(this.imageId, this.imageName, this.operatingSystem);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DesktopImage model) {
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("imageName")) {
                this.imageName(model.getImageName());
            }
            if (model.wasPropertyExplicitlySet("operatingSystem")) {
                this.operatingSystem(model.getOperatingSystem());
            }
            return this;
        }
    }
}

