/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.desktops.model.DesktopAvailabilityPolicy;
import com.oracle.bmc.desktops.model.DesktopDevicePolicy;
import com.oracle.bmc.desktops.model.DesktopImage;
import com.oracle.bmc.desktops.model.DesktopNetworkConfiguration;
import com.oracle.bmc.desktops.model.DesktopPoolPrivateAccessDetails;
import com.oracle.bmc.desktops.model.DesktopPoolShapeConfig;
import com.oracle.bmc.desktops.model.DesktopSessionLifecycleActions;
import com.oracle.bmc.desktops.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DesktopPool
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="maximumSize")
    private final Integer maximumSize;
    @JsonProperty(value="standbySize")
    private final Integer standbySize;
    @JsonProperty(value="shapeName")
    private final String shapeName;
    @JsonProperty(value="shapeConfig")
    private final DesktopPoolShapeConfig shapeConfig;
    @JsonProperty(value="useDedicatedVmHost")
    private final UseDedicatedVmHost useDedicatedVmHost;
    @JsonProperty(value="isStorageEnabled")
    private final Boolean isStorageEnabled;
    @JsonProperty(value="storageSizeInGBs")
    private final Integer storageSizeInGBs;
    @JsonProperty(value="storageBackupPolicyId")
    private final String storageBackupPolicyId;
    @JsonProperty(value="devicePolicy")
    private final DesktopDevicePolicy devicePolicy;
    @JsonProperty(value="availabilityPolicy")
    private final DesktopAvailabilityPolicy availabilityPolicy;
    @JsonProperty(value="image")
    private final DesktopImage image;
    @JsonProperty(value="networkConfiguration")
    private final DesktopNetworkConfiguration networkConfiguration;
    @JsonProperty(value="sessionLifecycleActions")
    private final DesktopSessionLifecycleActions sessionLifecycleActions;
    @JsonProperty(value="timeStartScheduled")
    private final Date timeStartScheduled;
    @JsonProperty(value="timeStopScheduled")
    private final Date timeStopScheduled;
    @JsonProperty(value="contactDetails")
    private final String contactDetails;
    @JsonProperty(value="arePrivilegedUsers")
    private final Boolean arePrivilegedUsers;
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="nsgIds")
    private final List<String> nsgIds;
    @JsonProperty(value="privateAccessDetails")
    private final DesktopPoolPrivateAccessDetails privateAccessDetails;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "displayName", "description", "lifecycleState", "timeCreated", "maximumSize", "standbySize", "shapeName", "shapeConfig", "useDedicatedVmHost", "isStorageEnabled", "storageSizeInGBs", "storageBackupPolicyId", "devicePolicy", "availabilityPolicy", "image", "networkConfiguration", "sessionLifecycleActions", "timeStartScheduled", "timeStopScheduled", "contactDetails", "arePrivilegedUsers", "availabilityDomain", "freeformTags", "definedTags", "nsgIds", "privateAccessDetails"})
    public DesktopPool(String id, String compartmentId, String displayName, String description, LifecycleState lifecycleState, Date timeCreated, Integer maximumSize, Integer standbySize, String shapeName, DesktopPoolShapeConfig shapeConfig, UseDedicatedVmHost useDedicatedVmHost, Boolean isStorageEnabled, Integer storageSizeInGBs, String storageBackupPolicyId, DesktopDevicePolicy devicePolicy, DesktopAvailabilityPolicy availabilityPolicy, DesktopImage image, DesktopNetworkConfiguration networkConfiguration, DesktopSessionLifecycleActions sessionLifecycleActions, Date timeStartScheduled, Date timeStopScheduled, String contactDetails, Boolean arePrivilegedUsers, String availabilityDomain, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, List<String> nsgIds, DesktopPoolPrivateAccessDetails privateAccessDetails) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.displayName = displayName;
        this.description = description;
        this.lifecycleState = lifecycleState;
        this.timeCreated = timeCreated;
        this.maximumSize = maximumSize;
        this.standbySize = standbySize;
        this.shapeName = shapeName;
        this.shapeConfig = shapeConfig;
        this.useDedicatedVmHost = useDedicatedVmHost;
        this.isStorageEnabled = isStorageEnabled;
        this.storageSizeInGBs = storageSizeInGBs;
        this.storageBackupPolicyId = storageBackupPolicyId;
        this.devicePolicy = devicePolicy;
        this.availabilityPolicy = availabilityPolicy;
        this.image = image;
        this.networkConfiguration = networkConfiguration;
        this.sessionLifecycleActions = sessionLifecycleActions;
        this.timeStartScheduled = timeStartScheduled;
        this.timeStopScheduled = timeStopScheduled;
        this.contactDetails = contactDetails;
        this.arePrivilegedUsers = arePrivilegedUsers;
        this.availabilityDomain = availabilityDomain;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.nsgIds = nsgIds;
        this.privateAccessDetails = privateAccessDetails;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public Integer getStandbySize() {
        return this.standbySize;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public DesktopPoolShapeConfig getShapeConfig() {
        return this.shapeConfig;
    }

    public UseDedicatedVmHost getUseDedicatedVmHost() {
        return this.useDedicatedVmHost;
    }

    public Boolean getIsStorageEnabled() {
        return this.isStorageEnabled;
    }

    public Integer getStorageSizeInGBs() {
        return this.storageSizeInGBs;
    }

    public String getStorageBackupPolicyId() {
        return this.storageBackupPolicyId;
    }

    public DesktopDevicePolicy getDevicePolicy() {
        return this.devicePolicy;
    }

    public DesktopAvailabilityPolicy getAvailabilityPolicy() {
        return this.availabilityPolicy;
    }

    public DesktopImage getImage() {
        return this.image;
    }

    public DesktopNetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public DesktopSessionLifecycleActions getSessionLifecycleActions() {
        return this.sessionLifecycleActions;
    }

    public Date getTimeStartScheduled() {
        return this.timeStartScheduled;
    }

    public Date getTimeStopScheduled() {
        return this.timeStopScheduled;
    }

    public String getContactDetails() {
        return this.contactDetails;
    }

    public Boolean getArePrivilegedUsers() {
        return this.arePrivilegedUsers;
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public List<String> getNsgIds() {
        return this.nsgIds;
    }

    public DesktopPoolPrivateAccessDetails getPrivateAccessDetails() {
        return this.privateAccessDetails;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DesktopPool(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", maximumSize=").append(String.valueOf(this.maximumSize));
        sb.append(", standbySize=").append(String.valueOf(this.standbySize));
        sb.append(", shapeName=").append(String.valueOf(this.shapeName));
        sb.append(", shapeConfig=").append(String.valueOf((Object)this.shapeConfig));
        sb.append(", useDedicatedVmHost=").append(String.valueOf((Object)this.useDedicatedVmHost));
        sb.append(", isStorageEnabled=").append(String.valueOf(this.isStorageEnabled));
        sb.append(", storageSizeInGBs=").append(String.valueOf(this.storageSizeInGBs));
        sb.append(", storageBackupPolicyId=").append(String.valueOf(this.storageBackupPolicyId));
        sb.append(", devicePolicy=").append(String.valueOf((Object)this.devicePolicy));
        sb.append(", availabilityPolicy=").append(String.valueOf((Object)this.availabilityPolicy));
        sb.append(", image=").append(String.valueOf((Object)this.image));
        sb.append(", networkConfiguration=").append(String.valueOf((Object)this.networkConfiguration));
        sb.append(", sessionLifecycleActions=").append(String.valueOf((Object)this.sessionLifecycleActions));
        sb.append(", timeStartScheduled=").append(String.valueOf(this.timeStartScheduled));
        sb.append(", timeStopScheduled=").append(String.valueOf(this.timeStopScheduled));
        sb.append(", contactDetails=").append(String.valueOf(this.contactDetails));
        sb.append(", arePrivilegedUsers=").append(String.valueOf(this.arePrivilegedUsers));
        sb.append(", availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", nsgIds=").append(String.valueOf(this.nsgIds));
        sb.append(", privateAccessDetails=").append(String.valueOf((Object)this.privateAccessDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesktopPool)) {
            return false;
        }
        DesktopPool other = (DesktopPool)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.maximumSize, other.maximumSize) && Objects.equals(this.standbySize, other.standbySize) && Objects.equals(this.shapeName, other.shapeName) && Objects.equals((Object)this.shapeConfig, (Object)other.shapeConfig) && Objects.equals((Object)this.useDedicatedVmHost, (Object)other.useDedicatedVmHost) && Objects.equals(this.isStorageEnabled, other.isStorageEnabled) && Objects.equals(this.storageSizeInGBs, other.storageSizeInGBs) && Objects.equals(this.storageBackupPolicyId, other.storageBackupPolicyId) && Objects.equals((Object)this.devicePolicy, (Object)other.devicePolicy) && Objects.equals((Object)this.availabilityPolicy, (Object)other.availabilityPolicy) && Objects.equals((Object)this.image, (Object)other.image) && Objects.equals((Object)this.networkConfiguration, (Object)other.networkConfiguration) && Objects.equals((Object)this.sessionLifecycleActions, (Object)other.sessionLifecycleActions) && Objects.equals(this.timeStartScheduled, other.timeStartScheduled) && Objects.equals(this.timeStopScheduled, other.timeStopScheduled) && Objects.equals(this.contactDetails, other.contactDetails) && Objects.equals(this.arePrivilegedUsers, other.arePrivilegedUsers) && Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.nsgIds, other.nsgIds) && Objects.equals((Object)this.privateAccessDetails, (Object)other.privateAccessDetails) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.maximumSize == null ? 43 : this.maximumSize.hashCode());
        result = result * 59 + (this.standbySize == null ? 43 : this.standbySize.hashCode());
        result = result * 59 + (this.shapeName == null ? 43 : this.shapeName.hashCode());
        result = result * 59 + (this.shapeConfig == null ? 43 : this.shapeConfig.hashCode());
        result = result * 59 + (this.useDedicatedVmHost == null ? 43 : this.useDedicatedVmHost.hashCode());
        result = result * 59 + (this.isStorageEnabled == null ? 43 : this.isStorageEnabled.hashCode());
        result = result * 59 + (this.storageSizeInGBs == null ? 43 : this.storageSizeInGBs.hashCode());
        result = result * 59 + (this.storageBackupPolicyId == null ? 43 : this.storageBackupPolicyId.hashCode());
        result = result * 59 + (this.devicePolicy == null ? 43 : this.devicePolicy.hashCode());
        result = result * 59 + (this.availabilityPolicy == null ? 43 : this.availabilityPolicy.hashCode());
        result = result * 59 + (this.image == null ? 43 : this.image.hashCode());
        result = result * 59 + (this.networkConfiguration == null ? 43 : this.networkConfiguration.hashCode());
        result = result * 59 + (this.sessionLifecycleActions == null ? 43 : this.sessionLifecycleActions.hashCode());
        result = result * 59 + (this.timeStartScheduled == null ? 43 : this.timeStartScheduled.hashCode());
        result = result * 59 + (this.timeStopScheduled == null ? 43 : this.timeStopScheduled.hashCode());
        result = result * 59 + (this.contactDetails == null ? 43 : this.contactDetails.hashCode());
        result = result * 59 + (this.arePrivilegedUsers == null ? 43 : this.arePrivilegedUsers.hashCode());
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.nsgIds == null ? 43 : this.nsgIds.hashCode());
        result = result * 59 + (this.privateAccessDetails == null ? 43 : this.privateAccessDetails.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum UseDedicatedVmHost implements BmcEnum
    {
        True("TRUE"),
        False("FALSE"),
        Auto("AUTO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, UseDedicatedVmHost> map;

        private UseDedicatedVmHost(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static UseDedicatedVmHost create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'UseDedicatedVmHost', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(UseDedicatedVmHost.class);
            map = new HashMap<String, UseDedicatedVmHost>();
            for (UseDedicatedVmHost v : UseDedicatedVmHost.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="maximumSize")
        private Integer maximumSize;
        @JsonProperty(value="standbySize")
        private Integer standbySize;
        @JsonProperty(value="shapeName")
        private String shapeName;
        @JsonProperty(value="shapeConfig")
        private DesktopPoolShapeConfig shapeConfig;
        @JsonProperty(value="useDedicatedVmHost")
        private UseDedicatedVmHost useDedicatedVmHost;
        @JsonProperty(value="isStorageEnabled")
        private Boolean isStorageEnabled;
        @JsonProperty(value="storageSizeInGBs")
        private Integer storageSizeInGBs;
        @JsonProperty(value="storageBackupPolicyId")
        private String storageBackupPolicyId;
        @JsonProperty(value="devicePolicy")
        private DesktopDevicePolicy devicePolicy;
        @JsonProperty(value="availabilityPolicy")
        private DesktopAvailabilityPolicy availabilityPolicy;
        @JsonProperty(value="image")
        private DesktopImage image;
        @JsonProperty(value="networkConfiguration")
        private DesktopNetworkConfiguration networkConfiguration;
        @JsonProperty(value="sessionLifecycleActions")
        private DesktopSessionLifecycleActions sessionLifecycleActions;
        @JsonProperty(value="timeStartScheduled")
        private Date timeStartScheduled;
        @JsonProperty(value="timeStopScheduled")
        private Date timeStopScheduled;
        @JsonProperty(value="contactDetails")
        private String contactDetails;
        @JsonProperty(value="arePrivilegedUsers")
        private Boolean arePrivilegedUsers;
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="nsgIds")
        private List<String> nsgIds;
        @JsonProperty(value="privateAccessDetails")
        private DesktopPoolPrivateAccessDetails privateAccessDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder maximumSize(Integer maximumSize) {
            this.maximumSize = maximumSize;
            this.__explicitlySet__.add("maximumSize");
            return this;
        }

        public Builder standbySize(Integer standbySize) {
            this.standbySize = standbySize;
            this.__explicitlySet__.add("standbySize");
            return this;
        }

        public Builder shapeName(String shapeName) {
            this.shapeName = shapeName;
            this.__explicitlySet__.add("shapeName");
            return this;
        }

        public Builder shapeConfig(DesktopPoolShapeConfig shapeConfig) {
            this.shapeConfig = shapeConfig;
            this.__explicitlySet__.add("shapeConfig");
            return this;
        }

        public Builder useDedicatedVmHost(UseDedicatedVmHost useDedicatedVmHost) {
            this.useDedicatedVmHost = useDedicatedVmHost;
            this.__explicitlySet__.add("useDedicatedVmHost");
            return this;
        }

        public Builder isStorageEnabled(Boolean isStorageEnabled) {
            this.isStorageEnabled = isStorageEnabled;
            this.__explicitlySet__.add("isStorageEnabled");
            return this;
        }

        public Builder storageSizeInGBs(Integer storageSizeInGBs) {
            this.storageSizeInGBs = storageSizeInGBs;
            this.__explicitlySet__.add("storageSizeInGBs");
            return this;
        }

        public Builder storageBackupPolicyId(String storageBackupPolicyId) {
            this.storageBackupPolicyId = storageBackupPolicyId;
            this.__explicitlySet__.add("storageBackupPolicyId");
            return this;
        }

        public Builder devicePolicy(DesktopDevicePolicy devicePolicy) {
            this.devicePolicy = devicePolicy;
            this.__explicitlySet__.add("devicePolicy");
            return this;
        }

        public Builder availabilityPolicy(DesktopAvailabilityPolicy availabilityPolicy) {
            this.availabilityPolicy = availabilityPolicy;
            this.__explicitlySet__.add("availabilityPolicy");
            return this;
        }

        public Builder image(DesktopImage image) {
            this.image = image;
            this.__explicitlySet__.add("image");
            return this;
        }

        public Builder networkConfiguration(DesktopNetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            this.__explicitlySet__.add("networkConfiguration");
            return this;
        }

        public Builder sessionLifecycleActions(DesktopSessionLifecycleActions sessionLifecycleActions) {
            this.sessionLifecycleActions = sessionLifecycleActions;
            this.__explicitlySet__.add("sessionLifecycleActions");
            return this;
        }

        public Builder timeStartScheduled(Date timeStartScheduled) {
            this.timeStartScheduled = timeStartScheduled;
            this.__explicitlySet__.add("timeStartScheduled");
            return this;
        }

        public Builder timeStopScheduled(Date timeStopScheduled) {
            this.timeStopScheduled = timeStopScheduled;
            this.__explicitlySet__.add("timeStopScheduled");
            return this;
        }

        public Builder contactDetails(String contactDetails) {
            this.contactDetails = contactDetails;
            this.__explicitlySet__.add("contactDetails");
            return this;
        }

        public Builder arePrivilegedUsers(Boolean arePrivilegedUsers) {
            this.arePrivilegedUsers = arePrivilegedUsers;
            this.__explicitlySet__.add("arePrivilegedUsers");
            return this;
        }

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder nsgIds(List<String> nsgIds) {
            this.nsgIds = nsgIds;
            this.__explicitlySet__.add("nsgIds");
            return this;
        }

        public Builder privateAccessDetails(DesktopPoolPrivateAccessDetails privateAccessDetails) {
            this.privateAccessDetails = privateAccessDetails;
            this.__explicitlySet__.add("privateAccessDetails");
            return this;
        }

        public DesktopPool build() {
            DesktopPool model = new DesktopPool(this.id, this.compartmentId, this.displayName, this.description, this.lifecycleState, this.timeCreated, this.maximumSize, this.standbySize, this.shapeName, this.shapeConfig, this.useDedicatedVmHost, this.isStorageEnabled, this.storageSizeInGBs, this.storageBackupPolicyId, this.devicePolicy, this.availabilityPolicy, this.image, this.networkConfiguration, this.sessionLifecycleActions, this.timeStartScheduled, this.timeStopScheduled, this.contactDetails, this.arePrivilegedUsers, this.availabilityDomain, this.freeformTags, this.definedTags, this.nsgIds, this.privateAccessDetails);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DesktopPool model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("maximumSize")) {
                this.maximumSize(model.getMaximumSize());
            }
            if (model.wasPropertyExplicitlySet("standbySize")) {
                this.standbySize(model.getStandbySize());
            }
            if (model.wasPropertyExplicitlySet("shapeName")) {
                this.shapeName(model.getShapeName());
            }
            if (model.wasPropertyExplicitlySet("shapeConfig")) {
                this.shapeConfig(model.getShapeConfig());
            }
            if (model.wasPropertyExplicitlySet("useDedicatedVmHost")) {
                this.useDedicatedVmHost(model.getUseDedicatedVmHost());
            }
            if (model.wasPropertyExplicitlySet("isStorageEnabled")) {
                this.isStorageEnabled(model.getIsStorageEnabled());
            }
            if (model.wasPropertyExplicitlySet("storageSizeInGBs")) {
                this.storageSizeInGBs(model.getStorageSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("storageBackupPolicyId")) {
                this.storageBackupPolicyId(model.getStorageBackupPolicyId());
            }
            if (model.wasPropertyExplicitlySet("devicePolicy")) {
                this.devicePolicy(model.getDevicePolicy());
            }
            if (model.wasPropertyExplicitlySet("availabilityPolicy")) {
                this.availabilityPolicy(model.getAvailabilityPolicy());
            }
            if (model.wasPropertyExplicitlySet("image")) {
                this.image(model.getImage());
            }
            if (model.wasPropertyExplicitlySet("networkConfiguration")) {
                this.networkConfiguration(model.getNetworkConfiguration());
            }
            if (model.wasPropertyExplicitlySet("sessionLifecycleActions")) {
                this.sessionLifecycleActions(model.getSessionLifecycleActions());
            }
            if (model.wasPropertyExplicitlySet("timeStartScheduled")) {
                this.timeStartScheduled(model.getTimeStartScheduled());
            }
            if (model.wasPropertyExplicitlySet("timeStopScheduled")) {
                this.timeStopScheduled(model.getTimeStopScheduled());
            }
            if (model.wasPropertyExplicitlySet("contactDetails")) {
                this.contactDetails(model.getContactDetails());
            }
            if (model.wasPropertyExplicitlySet("arePrivilegedUsers")) {
                this.arePrivilegedUsers(model.getArePrivilegedUsers());
            }
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("nsgIds")) {
                this.nsgIds(model.getNsgIds());
            }
            if (model.wasPropertyExplicitlySet("privateAccessDetails")) {
                this.privateAccessDetails(model.getPrivateAccessDetails());
            }
            return this;
        }
    }
}

