/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.desktops.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DesktopPoolDesktopSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="instanceId")
    private final String instanceId;
    @JsonProperty(value="userName")
    private final String userName;
    @JsonProperty(value="desktopId")
    private final String desktopId;
    @JsonProperty(value="isAssigned")
    private final Boolean isAssigned;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"lifecycleState", "instanceId", "userName", "desktopId", "isAssigned", "timeCreated", "freeformTags", "definedTags"})
    public DesktopPoolDesktopSummary(LifecycleState lifecycleState, String instanceId, String userName, String desktopId, Boolean isAssigned, Date timeCreated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.lifecycleState = lifecycleState;
        this.instanceId = instanceId;
        this.userName = userName;
        this.desktopId = desktopId;
        this.isAssigned = isAssigned;
        this.timeCreated = timeCreated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getDesktopId() {
        return this.desktopId;
    }

    public Boolean getIsAssigned() {
        return this.isAssigned;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DesktopPoolDesktopSummary(");
        sb.append("super=").append(super.toString());
        sb.append("lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", instanceId=").append(String.valueOf(this.instanceId));
        sb.append(", userName=").append(String.valueOf(this.userName));
        sb.append(", desktopId=").append(String.valueOf(this.desktopId));
        sb.append(", isAssigned=").append(String.valueOf(this.isAssigned));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesktopPoolDesktopSummary)) {
            return false;
        }
        DesktopPoolDesktopSummary other = (DesktopPoolDesktopSummary)((Object)o);
        return Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.userName, other.userName) && Objects.equals(this.desktopId, other.desktopId) && Objects.equals(this.isAssigned, other.isAssigned) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.instanceId == null ? 43 : this.instanceId.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.desktopId == null ? 43 : this.desktopId.hashCode());
        result = result * 59 + (this.isAssigned == null ? 43 : this.isAssigned.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="instanceId")
        private String instanceId;
        @JsonProperty(value="userName")
        private String userName;
        @JsonProperty(value="desktopId")
        private String desktopId;
        @JsonProperty(value="isAssigned")
        private Boolean isAssigned;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            this.__explicitlySet__.add("instanceId");
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            this.__explicitlySet__.add("userName");
            return this;
        }

        public Builder desktopId(String desktopId) {
            this.desktopId = desktopId;
            this.__explicitlySet__.add("desktopId");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.__explicitlySet__.add("isAssigned");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public DesktopPoolDesktopSummary build() {
            DesktopPoolDesktopSummary model = new DesktopPoolDesktopSummary(this.lifecycleState, this.instanceId, this.userName, this.desktopId, this.isAssigned, this.timeCreated, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DesktopPoolDesktopSummary model) {
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("instanceId")) {
                this.instanceId(model.getInstanceId());
            }
            if (model.wasPropertyExplicitlySet("userName")) {
                this.userName(model.getUserName());
            }
            if (model.wasPropertyExplicitlySet("desktopId")) {
                this.desktopId(model.getDesktopId());
            }
            if (model.wasPropertyExplicitlySet("isAssigned")) {
                this.isAssigned(model.getIsAssigned());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

