/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.desktops.model.LifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DesktopPoolSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="maximumSize")
    private final Integer maximumSize;
    @JsonProperty(value="activeDesktops")
    private final Integer activeDesktops;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="contactDetails")
    private final String contactDetails;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "lifecycleState", "maximumSize", "activeDesktops", "freeformTags", "definedTags", "contactDetails", "compartmentId", "timeCreated"})
    public DesktopPoolSummary(String id, String displayName, LifecycleState lifecycleState, Integer maximumSize, Integer activeDesktops, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, String contactDetails, String compartmentId, Date timeCreated) {
        this.id = id;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.maximumSize = maximumSize;
        this.activeDesktops = activeDesktops;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.contactDetails = contactDetails;
        this.compartmentId = compartmentId;
        this.timeCreated = timeCreated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getMaximumSize() {
        return this.maximumSize;
    }

    public Integer getActiveDesktops() {
        return this.activeDesktops;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String getContactDetails() {
        return this.contactDetails;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DesktopPoolSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", maximumSize=").append(String.valueOf(this.maximumSize));
        sb.append(", activeDesktops=").append(String.valueOf(this.activeDesktops));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", contactDetails=").append(String.valueOf(this.contactDetails));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DesktopPoolSummary)) {
            return false;
        }
        DesktopPoolSummary other = (DesktopPoolSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.maximumSize, other.maximumSize) && Objects.equals(this.activeDesktops, other.activeDesktops) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.contactDetails, other.contactDetails) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.timeCreated, other.timeCreated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.maximumSize == null ? 43 : this.maximumSize.hashCode());
        result = result * 59 + (this.activeDesktops == null ? 43 : this.activeDesktops.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.contactDetails == null ? 43 : this.contactDetails.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="maximumSize")
        private Integer maximumSize;
        @JsonProperty(value="activeDesktops")
        private Integer activeDesktops;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="contactDetails")
        private String contactDetails;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder maximumSize(Integer maximumSize) {
            this.maximumSize = maximumSize;
            this.__explicitlySet__.add("maximumSize");
            return this;
        }

        public Builder activeDesktops(Integer activeDesktops) {
            this.activeDesktops = activeDesktops;
            this.__explicitlySet__.add("activeDesktops");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder contactDetails(String contactDetails) {
            this.contactDetails = contactDetails;
            this.__explicitlySet__.add("contactDetails");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public DesktopPoolSummary build() {
            DesktopPoolSummary model = new DesktopPoolSummary(this.id, this.displayName, this.lifecycleState, this.maximumSize, this.activeDesktops, this.freeformTags, this.definedTags, this.contactDetails, this.compartmentId, this.timeCreated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DesktopPoolSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("maximumSize")) {
                this.maximumSize(model.getMaximumSize());
            }
            if (model.wasPropertyExplicitlySet("activeDesktops")) {
                this.activeDesktops(model.getActiveDesktops());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("contactDetails")) {
                this.contactDetails(model.getContactDetails());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            return this;
        }
    }
}

