/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class DisconnectConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="action")
    private final Action action;
    @JsonProperty(value="gracePeriodInMinutes")
    private final Integer gracePeriodInMinutes;

    @Deprecated
    @ConstructorProperties(value={"action", "gracePeriodInMinutes"})
    public DisconnectConfig(Action action, Integer gracePeriodInMinutes) {
        this.action = action;
        this.gracePeriodInMinutes = gracePeriodInMinutes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Action getAction() {
        return this.action;
    }

    public Integer getGracePeriodInMinutes() {
        return this.gracePeriodInMinutes;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("DisconnectConfig(");
        sb.append("super=").append(super.toString());
        sb.append("action=").append(String.valueOf((Object)this.action));
        sb.append(", gracePeriodInMinutes=").append(String.valueOf(this.gracePeriodInMinutes));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DisconnectConfig)) {
            return false;
        }
        DisconnectConfig other = (DisconnectConfig)((Object)o);
        return Objects.equals((Object)this.action, (Object)other.action) && Objects.equals(this.gracePeriodInMinutes, other.gracePeriodInMinutes) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.action == null ? 43 : this.action.hashCode());
        result = result * 59 + (this.gracePeriodInMinutes == null ? 43 : this.gracePeriodInMinutes.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Action implements BmcEnum
    {
        None("NONE"),
        Stop("STOP"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Action> map;

        private Action(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Action create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Action', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Action.class);
            map = new HashMap<String, Action>();
            for (Action v : Action.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="action")
        private Action action;
        @JsonProperty(value="gracePeriodInMinutes")
        private Integer gracePeriodInMinutes;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder action(Action action) {
            this.action = action;
            this.__explicitlySet__.add("action");
            return this;
        }

        public Builder gracePeriodInMinutes(Integer gracePeriodInMinutes) {
            this.gracePeriodInMinutes = gracePeriodInMinutes;
            this.__explicitlySet__.add("gracePeriodInMinutes");
            return this;
        }

        public DisconnectConfig build() {
            DisconnectConfig model = new DisconnectConfig(this.action, this.gracePeriodInMinutes);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(DisconnectConfig model) {
            if (model.wasPropertyExplicitlySet("action")) {
                this.action(model.getAction());
            }
            if (model.wasPropertyExplicitlySet("gracePeriodInMinutes")) {
                this.gracePeriodInMinutes(model.getGracePeriodInMinutes());
            }
            return this;
        }
    }
}

