/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteDesktopPoolRequest
extends BmcRequest<Void> {
    private String desktopPoolId;
    private String opcRequestId;
    private String ifMatch;
    private Boolean areVolumesPreserved;

    public String getDesktopPoolId() {
        return this.desktopPoolId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Boolean getAreVolumesPreserved() {
        return this.areVolumesPreserved;
    }

    public Builder toBuilder() {
        return new Builder().desktopPoolId(this.desktopPoolId).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch).areVolumesPreserved(this.areVolumesPreserved);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",desktopPoolId=").append(String.valueOf(this.desktopPoolId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",areVolumesPreserved=").append(String.valueOf(this.areVolumesPreserved));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteDesktopPoolRequest)) {
            return false;
        }
        DeleteDesktopPoolRequest other = (DeleteDesktopPoolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.desktopPoolId, other.desktopPoolId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.areVolumesPreserved, other.areVolumesPreserved);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.desktopPoolId == null ? 43 : this.desktopPoolId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.areVolumesPreserved == null ? 43 : this.areVolumesPreserved.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteDesktopPoolRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String desktopPoolId = null;
        private String opcRequestId = null;
        private String ifMatch = null;
        private Boolean areVolumesPreserved = null;

        public Builder desktopPoolId(String desktopPoolId) {
            this.desktopPoolId = desktopPoolId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder areVolumesPreserved(Boolean areVolumesPreserved) {
            this.areVolumesPreserved = areVolumesPreserved;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteDesktopPoolRequest o) {
            this.desktopPoolId(o.getDesktopPoolId());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.areVolumesPreserved(o.getAreVolumesPreserved());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteDesktopPoolRequest build() {
            DeleteDesktopPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteDesktopPoolRequest buildWithoutInvocationCallback() {
            DeleteDesktopPoolRequest request = new DeleteDesktopPoolRequest();
            request.desktopPoolId = this.desktopPoolId;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            request.areVolumesPreserved = this.areVolumesPreserved;
            return request;
        }
    }
}

