/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDesktopPoolRequest
extends BmcRequest<Void> {
    private String desktopPoolId;
    private String opcRequestId;

    public String getDesktopPoolId() {
        return this.desktopPoolId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().desktopPoolId(this.desktopPoolId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",desktopPoolId=").append(String.valueOf(this.desktopPoolId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDesktopPoolRequest)) {
            return false;
        }
        GetDesktopPoolRequest other = (GetDesktopPoolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.desktopPoolId, other.desktopPoolId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.desktopPoolId == null ? 43 : this.desktopPoolId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDesktopPoolRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String desktopPoolId = null;
        private String opcRequestId = null;

        public Builder desktopPoolId(String desktopPoolId) {
            this.desktopPoolId = desktopPoolId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDesktopPoolRequest o) {
            this.desktopPoolId(o.getDesktopPoolId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDesktopPoolRequest build() {
            GetDesktopPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDesktopPoolRequest buildWithoutInvocationCallback() {
            GetDesktopPoolRequest request = new GetDesktopPoolRequest();
            request.desktopPoolId = this.desktopPoolId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

