/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.desktops.model.UpdateDesktopPoolDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDesktopPoolRequest
extends BmcRequest<UpdateDesktopPoolDetails> {
    private String desktopPoolId;
    private UpdateDesktopPoolDetails updateDesktopPoolDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getDesktopPoolId() {
        return this.desktopPoolId;
    }

    public UpdateDesktopPoolDetails getUpdateDesktopPoolDetails() {
        return this.updateDesktopPoolDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDesktopPoolDetails getBody$() {
        return this.updateDesktopPoolDetails;
    }

    public Builder toBuilder() {
        return new Builder().desktopPoolId(this.desktopPoolId).updateDesktopPoolDetails(this.updateDesktopPoolDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",desktopPoolId=").append(String.valueOf(this.desktopPoolId));
        sb.append(",updateDesktopPoolDetails=").append(String.valueOf((Object)this.updateDesktopPoolDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDesktopPoolRequest)) {
            return false;
        }
        UpdateDesktopPoolRequest other = (UpdateDesktopPoolRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.desktopPoolId, other.desktopPoolId) && Objects.equals((Object)this.updateDesktopPoolDetails, (Object)other.updateDesktopPoolDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.desktopPoolId == null ? 43 : this.desktopPoolId.hashCode());
        result = result * 59 + (this.updateDesktopPoolDetails == null ? 43 : this.updateDesktopPoolDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDesktopPoolRequest, UpdateDesktopPoolDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String desktopPoolId = null;
        private UpdateDesktopPoolDetails updateDesktopPoolDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder desktopPoolId(String desktopPoolId) {
            this.desktopPoolId = desktopPoolId;
            return this;
        }

        public Builder updateDesktopPoolDetails(UpdateDesktopPoolDetails updateDesktopPoolDetails) {
            this.updateDesktopPoolDetails = updateDesktopPoolDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDesktopPoolRequest o) {
            this.desktopPoolId(o.getDesktopPoolId());
            this.updateDesktopPoolDetails(o.getUpdateDesktopPoolDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDesktopPoolRequest build() {
            UpdateDesktopPoolRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDesktopPoolDetails body) {
            this.updateDesktopPoolDetails(body);
            return this;
        }

        public UpdateDesktopPoolRequest buildWithoutInvocationCallback() {
            UpdateDesktopPoolRequest request = new UpdateDesktopPoolRequest();
            request.desktopPoolId = this.desktopPoolId;
            request.updateDesktopPoolDetails = this.updateDesktopPoolDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

