/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.desktops.model.UpdateDesktopDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateDesktopRequest
extends BmcRequest<UpdateDesktopDetails> {
    private String desktopId;
    private UpdateDesktopDetails updateDesktopDetails;
    private String opcRequestId;
    private String ifMatch;

    public String getDesktopId() {
        return this.desktopId;
    }

    public UpdateDesktopDetails getUpdateDesktopDetails() {
        return this.updateDesktopDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    @InternalSdk
    public UpdateDesktopDetails getBody$() {
        return this.updateDesktopDetails;
    }

    public Builder toBuilder() {
        return new Builder().desktopId(this.desktopId).updateDesktopDetails(this.updateDesktopDetails).opcRequestId(this.opcRequestId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",desktopId=").append(String.valueOf(this.desktopId));
        sb.append(",updateDesktopDetails=").append(String.valueOf((Object)this.updateDesktopDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateDesktopRequest)) {
            return false;
        }
        UpdateDesktopRequest other = (UpdateDesktopRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.desktopId, other.desktopId) && Objects.equals((Object)this.updateDesktopDetails, (Object)other.updateDesktopDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.desktopId == null ? 43 : this.desktopId.hashCode());
        result = result * 59 + (this.updateDesktopDetails == null ? 43 : this.updateDesktopDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateDesktopRequest, UpdateDesktopDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String desktopId = null;
        private UpdateDesktopDetails updateDesktopDetails = null;
        private String opcRequestId = null;
        private String ifMatch = null;

        public Builder desktopId(String desktopId) {
            this.desktopId = desktopId;
            return this;
        }

        public Builder updateDesktopDetails(UpdateDesktopDetails updateDesktopDetails) {
            this.updateDesktopDetails = updateDesktopDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateDesktopRequest o) {
            this.desktopId(o.getDesktopId());
            this.updateDesktopDetails(o.getUpdateDesktopDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateDesktopRequest build() {
            UpdateDesktopRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateDesktopDetails body) {
            this.updateDesktopDetails(body);
            return this;
        }

        public UpdateDesktopRequest buildWithoutInvocationCallback() {
            UpdateDesktopRequest request = new UpdateDesktopRequest();
            request.desktopId = this.desktopId;
            request.updateDesktopDetails = this.updateDesktopDetails;
            request.opcRequestId = this.opcRequestId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

