/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.desktops.responses;

import com.oracle.bmc.desktops.model.DesktopPool;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class GetDesktopPoolResponse
extends BmcResponse {
    private String opcRequestId;
    private String etag;
    private DesktopPool desktopPool;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getEtag() {
        return this.etag;
    }

    public DesktopPool getDesktopPool() {
        return this.desktopPool;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "etag", "desktopPool"})
    private GetDesktopPoolResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String etag, DesktopPool desktopPool) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.etag = etag;
        this.desktopPool = desktopPool;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",desktopPool=").append(String.valueOf((Object)this.desktopPool));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDesktopPoolResponse)) {
            return false;
        }
        GetDesktopPoolResponse other = (GetDesktopPoolResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.etag, other.etag) && Objects.equals((Object)this.desktopPool, (Object)other.desktopPool);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.desktopPool == null ? 43 : this.desktopPool.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<GetDesktopPoolResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String etag;
        private DesktopPool desktopPool;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder desktopPool(DesktopPool desktopPool) {
            this.desktopPool = desktopPool;
            return this;
        }

        public Builder copy(GetDesktopPoolResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.etag(o.getEtag());
            this.desktopPool(o.getDesktopPool());
            return this;
        }

        public GetDesktopPoolResponse build() {
            return new GetDesktopPoolResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.etag, this.desktopPool);
        }
    }
}

