/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.devops.Devops;
import com.oracle.bmc.devops.DevopsPaginators;
import com.oracle.bmc.devops.DevopsWaiters;
import com.oracle.bmc.devops.model.BuildPipeline;
import com.oracle.bmc.devops.model.BuildPipelineCollection;
import com.oracle.bmc.devops.model.BuildPipelineStage;
import com.oracle.bmc.devops.model.BuildPipelineStageCollection;
import com.oracle.bmc.devops.model.BuildRun;
import com.oracle.bmc.devops.model.BuildRunSnapshotCollection;
import com.oracle.bmc.devops.model.BuildRunSummaryCollection;
import com.oracle.bmc.devops.model.CommitAnalyticsAuthorCollection;
import com.oracle.bmc.devops.model.Connection;
import com.oracle.bmc.devops.model.ConnectionCollection;
import com.oracle.bmc.devops.model.DeployArtifact;
import com.oracle.bmc.devops.model.DeployArtifactCollection;
import com.oracle.bmc.devops.model.DeployEnvironment;
import com.oracle.bmc.devops.model.DeployEnvironmentCollection;
import com.oracle.bmc.devops.model.DeployPipeline;
import com.oracle.bmc.devops.model.DeployPipelineCollection;
import com.oracle.bmc.devops.model.DeployStage;
import com.oracle.bmc.devops.model.DeployStageCollection;
import com.oracle.bmc.devops.model.Deployment;
import com.oracle.bmc.devops.model.DeploymentCollection;
import com.oracle.bmc.devops.model.DiffCollection;
import com.oracle.bmc.devops.model.DiffResponse;
import com.oracle.bmc.devops.model.FileDiffResponse;
import com.oracle.bmc.devops.model.ForkSyncStatusCollection;
import com.oracle.bmc.devops.model.Project;
import com.oracle.bmc.devops.model.ProjectCollection;
import com.oracle.bmc.devops.model.ProjectNotificationPreference;
import com.oracle.bmc.devops.model.ProjectRepositorySettings;
import com.oracle.bmc.devops.model.ProtectedBranch;
import com.oracle.bmc.devops.model.ProtectedBranchCollection;
import com.oracle.bmc.devops.model.PullRequest;
import com.oracle.bmc.devops.model.PullRequestActivityCollection;
import com.oracle.bmc.devops.model.PullRequestAttachment;
import com.oracle.bmc.devops.model.PullRequestAttachmentCollection;
import com.oracle.bmc.devops.model.PullRequestAuthorCollection;
import com.oracle.bmc.devops.model.PullRequestChangeSummaryMetrics;
import com.oracle.bmc.devops.model.PullRequestCollection;
import com.oracle.bmc.devops.model.PullRequestComment;
import com.oracle.bmc.devops.model.PullRequestCommentCollection;
import com.oracle.bmc.devops.model.PullRequestFileChangeCollection;
import com.oracle.bmc.devops.model.PullRequestNotificationPreference;
import com.oracle.bmc.devops.model.Repository;
import com.oracle.bmc.devops.model.RepositoryAuthorCollection;
import com.oracle.bmc.devops.model.RepositoryCollection;
import com.oracle.bmc.devops.model.RepositoryCommit;
import com.oracle.bmc.devops.model.RepositoryCommitCollection;
import com.oracle.bmc.devops.model.RepositoryFileLines;
import com.oracle.bmc.devops.model.RepositoryMetricAggregation;
import com.oracle.bmc.devops.model.RepositoryMirrorRecord;
import com.oracle.bmc.devops.model.RepositoryMirrorRecordCollection;
import com.oracle.bmc.devops.model.RepositoryNotificationPreference;
import com.oracle.bmc.devops.model.RepositoryObject;
import com.oracle.bmc.devops.model.RepositoryPathCollection;
import com.oracle.bmc.devops.model.RepositoryRef;
import com.oracle.bmc.devops.model.RepositoryRefCollection;
import com.oracle.bmc.devops.model.RepositorySettings;
import com.oracle.bmc.devops.model.Trigger;
import com.oracle.bmc.devops.model.TriggerCollection;
import com.oracle.bmc.devops.model.TriggerCreateResult;
import com.oracle.bmc.devops.model.WorkRequest;
import com.oracle.bmc.devops.model.WorkRequestCollection;
import com.oracle.bmc.devops.model.WorkRequestErrorCollection;
import com.oracle.bmc.devops.model.WorkRequestLogEntryCollection;
import com.oracle.bmc.devops.requests.ApproveDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelBuildRunRequest;
import com.oracle.bmc.devops.requests.CancelDeploymentRequest;
import com.oracle.bmc.devops.requests.CancelScheduledCascadingProjectDeletionRequest;
import com.oracle.bmc.devops.requests.ChangeProjectCompartmentRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.CreateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.CreateBuildRunRequest;
import com.oracle.bmc.devops.requests.CreateConnectionRequest;
import com.oracle.bmc.devops.requests.CreateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.CreateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.CreateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.CreateDeployStageRequest;
import com.oracle.bmc.devops.requests.CreateDeploymentRequest;
import com.oracle.bmc.devops.requests.CreateOrUpdateGitRefRequest;
import com.oracle.bmc.devops.requests.CreateOrUpdateProtectedBranchRequest;
import com.oracle.bmc.devops.requests.CreateProjectRequest;
import com.oracle.bmc.devops.requests.CreatePullRequestAttachmentRequest;
import com.oracle.bmc.devops.requests.CreatePullRequestCommentRequest;
import com.oracle.bmc.devops.requests.CreatePullRequestRequest;
import com.oracle.bmc.devops.requests.CreateRepositoryRequest;
import com.oracle.bmc.devops.requests.CreateTriggerRequest;
import com.oracle.bmc.devops.requests.DeclinePullRequestRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.DeleteConnectionRequest;
import com.oracle.bmc.devops.requests.DeleteDeployArtifactRequest;
import com.oracle.bmc.devops.requests.DeleteDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.DeleteDeployPipelineRequest;
import com.oracle.bmc.devops.requests.DeleteDeployStageRequest;
import com.oracle.bmc.devops.requests.DeleteGitRefRequest;
import com.oracle.bmc.devops.requests.DeleteProjectRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.DeleteProjectRequest;
import com.oracle.bmc.devops.requests.DeleteProtectedBranchRequest;
import com.oracle.bmc.devops.requests.DeletePullRequestAttachmentRequest;
import com.oracle.bmc.devops.requests.DeletePullRequestCommentRequest;
import com.oracle.bmc.devops.requests.DeletePullRequestRequest;
import com.oracle.bmc.devops.requests.DeleteRefRequest;
import com.oracle.bmc.devops.requests.DeleteRepositoryRequest;
import com.oracle.bmc.devops.requests.DeleteRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.DeleteTriggerRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineRequest;
import com.oracle.bmc.devops.requests.GetBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.GetBuildRunRequest;
import com.oracle.bmc.devops.requests.GetCommitDiffRequest;
import com.oracle.bmc.devops.requests.GetCommitRequest;
import com.oracle.bmc.devops.requests.GetConnectionRequest;
import com.oracle.bmc.devops.requests.GetDeployArtifactRequest;
import com.oracle.bmc.devops.requests.GetDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.GetDeployPipelineRequest;
import com.oracle.bmc.devops.requests.GetDeployStageRequest;
import com.oracle.bmc.devops.requests.GetDeploymentRequest;
import com.oracle.bmc.devops.requests.GetFileDiffRequest;
import com.oracle.bmc.devops.requests.GetMirrorRecordRequest;
import com.oracle.bmc.devops.requests.GetObjectContentRequest;
import com.oracle.bmc.devops.requests.GetObjectRequest;
import com.oracle.bmc.devops.requests.GetProjectNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.GetProjectRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.GetProjectRequest;
import com.oracle.bmc.devops.requests.GetPullRequestAttachmentContentRequest;
import com.oracle.bmc.devops.requests.GetPullRequestAttachmentRequest;
import com.oracle.bmc.devops.requests.GetPullRequestChangeSummaryMetricsRequest;
import com.oracle.bmc.devops.requests.GetPullRequestCommentRequest;
import com.oracle.bmc.devops.requests.GetPullRequestNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.GetPullRequestRequest;
import com.oracle.bmc.devops.requests.GetRefRequest;
import com.oracle.bmc.devops.requests.GetRepoFileDiffRequest;
import com.oracle.bmc.devops.requests.GetRepoFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryArchiveContentRequest;
import com.oracle.bmc.devops.requests.GetRepositoryFileLinesRequest;
import com.oracle.bmc.devops.requests.GetRepositoryNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.GetRepositoryRequest;
import com.oracle.bmc.devops.requests.GetRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.GetTriggerRequest;
import com.oracle.bmc.devops.requests.GetWorkRequestRequest;
import com.oracle.bmc.devops.requests.LikePullRequestCommentRequest;
import com.oracle.bmc.devops.requests.ListAuthorsRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelineStagesRequest;
import com.oracle.bmc.devops.requests.ListBuildPipelinesRequest;
import com.oracle.bmc.devops.requests.ListBuildRunSnapshotsRequest;
import com.oracle.bmc.devops.requests.ListBuildRunsRequest;
import com.oracle.bmc.devops.requests.ListCommitDiffsRequest;
import com.oracle.bmc.devops.requests.ListCommitsRequest;
import com.oracle.bmc.devops.requests.ListConnectionsRequest;
import com.oracle.bmc.devops.requests.ListDeployArtifactsRequest;
import com.oracle.bmc.devops.requests.ListDeployEnvironmentsRequest;
import com.oracle.bmc.devops.requests.ListDeployPipelinesRequest;
import com.oracle.bmc.devops.requests.ListDeployStagesRequest;
import com.oracle.bmc.devops.requests.ListDeploymentsRequest;
import com.oracle.bmc.devops.requests.ListForkSyncStatusesRequest;
import com.oracle.bmc.devops.requests.ListMirrorRecordsRequest;
import com.oracle.bmc.devops.requests.ListPathsRequest;
import com.oracle.bmc.devops.requests.ListProjectCommitAnalyticsAuthorsRequest;
import com.oracle.bmc.devops.requests.ListProjectsRequest;
import com.oracle.bmc.devops.requests.ListProtectedBranchesRequest;
import com.oracle.bmc.devops.requests.ListPullRequestActivitiesRequest;
import com.oracle.bmc.devops.requests.ListPullRequestAttachmentsRequest;
import com.oracle.bmc.devops.requests.ListPullRequestAuthorsRequest;
import com.oracle.bmc.devops.requests.ListPullRequestCommentsRequest;
import com.oracle.bmc.devops.requests.ListPullRequestCommitsRequest;
import com.oracle.bmc.devops.requests.ListPullRequestFileChangesRequest;
import com.oracle.bmc.devops.requests.ListPullRequestsRequest;
import com.oracle.bmc.devops.requests.ListRefsRequest;
import com.oracle.bmc.devops.requests.ListRepositoriesRequest;
import com.oracle.bmc.devops.requests.ListRepositoryCommitAnalyticsAuthorsRequest;
import com.oracle.bmc.devops.requests.ListTriggersRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.devops.requests.ListWorkRequestsRequest;
import com.oracle.bmc.devops.requests.MergePullRequestRequest;
import com.oracle.bmc.devops.requests.MirrorRepositoryRequest;
import com.oracle.bmc.devops.requests.PatchPullRequestRequest;
import com.oracle.bmc.devops.requests.PutRepositoryRefRequest;
import com.oracle.bmc.devops.requests.ReopenPullRequestRequest;
import com.oracle.bmc.devops.requests.ReviewPullRequestRequest;
import com.oracle.bmc.devops.requests.ScheduleCascadingProjectDeletionRequest;
import com.oracle.bmc.devops.requests.SummarizeProjectRepositoryAnalyticsRequest;
import com.oracle.bmc.devops.requests.SummarizeRepositoryAnalyticsRequest;
import com.oracle.bmc.devops.requests.SyncRepositoryRequest;
import com.oracle.bmc.devops.requests.UnlikePullRequestCommentRequest;
import com.oracle.bmc.devops.requests.UnsubscribePullRequestRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateBuildPipelineStageRequest;
import com.oracle.bmc.devops.requests.UpdateBuildRunRequest;
import com.oracle.bmc.devops.requests.UpdateConnectionRequest;
import com.oracle.bmc.devops.requests.UpdateDeployArtifactRequest;
import com.oracle.bmc.devops.requests.UpdateDeployEnvironmentRequest;
import com.oracle.bmc.devops.requests.UpdateDeployPipelineRequest;
import com.oracle.bmc.devops.requests.UpdateDeployStageRequest;
import com.oracle.bmc.devops.requests.UpdateDeploymentRequest;
import com.oracle.bmc.devops.requests.UpdateProjectNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.UpdateProjectRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.UpdateProjectRequest;
import com.oracle.bmc.devops.requests.UpdatePullRequestCommentRequest;
import com.oracle.bmc.devops.requests.UpdatePullRequestNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.UpdatePullRequestRequest;
import com.oracle.bmc.devops.requests.UpdateRepositoryNotificationPreferenceRequest;
import com.oracle.bmc.devops.requests.UpdateRepositoryRequest;
import com.oracle.bmc.devops.requests.UpdateRepositorySettingsRequest;
import com.oracle.bmc.devops.requests.UpdateTriggerRequest;
import com.oracle.bmc.devops.requests.ValidateConnectionRequest;
import com.oracle.bmc.devops.responses.ApproveDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelBuildRunResponse;
import com.oracle.bmc.devops.responses.CancelDeploymentResponse;
import com.oracle.bmc.devops.responses.CancelScheduledCascadingProjectDeletionResponse;
import com.oracle.bmc.devops.responses.ChangeProjectCompartmentResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.CreateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.CreateBuildRunResponse;
import com.oracle.bmc.devops.responses.CreateConnectionResponse;
import com.oracle.bmc.devops.responses.CreateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.CreateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.CreateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.CreateDeployStageResponse;
import com.oracle.bmc.devops.responses.CreateDeploymentResponse;
import com.oracle.bmc.devops.responses.CreateOrUpdateGitRefResponse;
import com.oracle.bmc.devops.responses.CreateOrUpdateProtectedBranchResponse;
import com.oracle.bmc.devops.responses.CreateProjectResponse;
import com.oracle.bmc.devops.responses.CreatePullRequestAttachmentResponse;
import com.oracle.bmc.devops.responses.CreatePullRequestCommentResponse;
import com.oracle.bmc.devops.responses.CreatePullRequestResponse;
import com.oracle.bmc.devops.responses.CreateRepositoryResponse;
import com.oracle.bmc.devops.responses.CreateTriggerResponse;
import com.oracle.bmc.devops.responses.DeclinePullRequestResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.DeleteConnectionResponse;
import com.oracle.bmc.devops.responses.DeleteDeployArtifactResponse;
import com.oracle.bmc.devops.responses.DeleteDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.DeleteDeployPipelineResponse;
import com.oracle.bmc.devops.responses.DeleteDeployStageResponse;
import com.oracle.bmc.devops.responses.DeleteGitRefResponse;
import com.oracle.bmc.devops.responses.DeleteProjectRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.DeleteProjectResponse;
import com.oracle.bmc.devops.responses.DeleteProtectedBranchResponse;
import com.oracle.bmc.devops.responses.DeletePullRequestAttachmentResponse;
import com.oracle.bmc.devops.responses.DeletePullRequestCommentResponse;
import com.oracle.bmc.devops.responses.DeletePullRequestResponse;
import com.oracle.bmc.devops.responses.DeleteRefResponse;
import com.oracle.bmc.devops.responses.DeleteRepositoryResponse;
import com.oracle.bmc.devops.responses.DeleteRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.DeleteTriggerResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineResponse;
import com.oracle.bmc.devops.responses.GetBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.GetBuildRunResponse;
import com.oracle.bmc.devops.responses.GetCommitDiffResponse;
import com.oracle.bmc.devops.responses.GetCommitResponse;
import com.oracle.bmc.devops.responses.GetConnectionResponse;
import com.oracle.bmc.devops.responses.GetDeployArtifactResponse;
import com.oracle.bmc.devops.responses.GetDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.GetDeployPipelineResponse;
import com.oracle.bmc.devops.responses.GetDeployStageResponse;
import com.oracle.bmc.devops.responses.GetDeploymentResponse;
import com.oracle.bmc.devops.responses.GetFileDiffResponse;
import com.oracle.bmc.devops.responses.GetMirrorRecordResponse;
import com.oracle.bmc.devops.responses.GetObjectContentResponse;
import com.oracle.bmc.devops.responses.GetObjectResponse;
import com.oracle.bmc.devops.responses.GetProjectNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.GetProjectRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.GetProjectResponse;
import com.oracle.bmc.devops.responses.GetPullRequestAttachmentContentResponse;
import com.oracle.bmc.devops.responses.GetPullRequestAttachmentResponse;
import com.oracle.bmc.devops.responses.GetPullRequestChangeSummaryMetricsResponse;
import com.oracle.bmc.devops.responses.GetPullRequestCommentResponse;
import com.oracle.bmc.devops.responses.GetPullRequestNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.GetPullRequestResponse;
import com.oracle.bmc.devops.responses.GetRefResponse;
import com.oracle.bmc.devops.responses.GetRepoFileDiffResponse;
import com.oracle.bmc.devops.responses.GetRepoFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryArchiveContentResponse;
import com.oracle.bmc.devops.responses.GetRepositoryFileLinesResponse;
import com.oracle.bmc.devops.responses.GetRepositoryNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.GetRepositoryResponse;
import com.oracle.bmc.devops.responses.GetRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.GetTriggerResponse;
import com.oracle.bmc.devops.responses.GetWorkRequestResponse;
import com.oracle.bmc.devops.responses.LikePullRequestCommentResponse;
import com.oracle.bmc.devops.responses.ListAuthorsResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelineStagesResponse;
import com.oracle.bmc.devops.responses.ListBuildPipelinesResponse;
import com.oracle.bmc.devops.responses.ListBuildRunSnapshotsResponse;
import com.oracle.bmc.devops.responses.ListBuildRunsResponse;
import com.oracle.bmc.devops.responses.ListCommitDiffsResponse;
import com.oracle.bmc.devops.responses.ListCommitsResponse;
import com.oracle.bmc.devops.responses.ListConnectionsResponse;
import com.oracle.bmc.devops.responses.ListDeployArtifactsResponse;
import com.oracle.bmc.devops.responses.ListDeployEnvironmentsResponse;
import com.oracle.bmc.devops.responses.ListDeployPipelinesResponse;
import com.oracle.bmc.devops.responses.ListDeployStagesResponse;
import com.oracle.bmc.devops.responses.ListDeploymentsResponse;
import com.oracle.bmc.devops.responses.ListForkSyncStatusesResponse;
import com.oracle.bmc.devops.responses.ListMirrorRecordsResponse;
import com.oracle.bmc.devops.responses.ListPathsResponse;
import com.oracle.bmc.devops.responses.ListProjectCommitAnalyticsAuthorsResponse;
import com.oracle.bmc.devops.responses.ListProjectsResponse;
import com.oracle.bmc.devops.responses.ListProtectedBranchesResponse;
import com.oracle.bmc.devops.responses.ListPullRequestActivitiesResponse;
import com.oracle.bmc.devops.responses.ListPullRequestAttachmentsResponse;
import com.oracle.bmc.devops.responses.ListPullRequestAuthorsResponse;
import com.oracle.bmc.devops.responses.ListPullRequestCommentsResponse;
import com.oracle.bmc.devops.responses.ListPullRequestCommitsResponse;
import com.oracle.bmc.devops.responses.ListPullRequestFileChangesResponse;
import com.oracle.bmc.devops.responses.ListPullRequestsResponse;
import com.oracle.bmc.devops.responses.ListRefsResponse;
import com.oracle.bmc.devops.responses.ListRepositoriesResponse;
import com.oracle.bmc.devops.responses.ListRepositoryCommitAnalyticsAuthorsResponse;
import com.oracle.bmc.devops.responses.ListTriggersResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.devops.responses.ListWorkRequestsResponse;
import com.oracle.bmc.devops.responses.MergePullRequestResponse;
import com.oracle.bmc.devops.responses.MirrorRepositoryResponse;
import com.oracle.bmc.devops.responses.PatchPullRequestResponse;
import com.oracle.bmc.devops.responses.PutRepositoryRefResponse;
import com.oracle.bmc.devops.responses.ReopenPullRequestResponse;
import com.oracle.bmc.devops.responses.ReviewPullRequestResponse;
import com.oracle.bmc.devops.responses.ScheduleCascadingProjectDeletionResponse;
import com.oracle.bmc.devops.responses.SummarizeProjectRepositoryAnalyticsResponse;
import com.oracle.bmc.devops.responses.SummarizeRepositoryAnalyticsResponse;
import com.oracle.bmc.devops.responses.SyncRepositoryResponse;
import com.oracle.bmc.devops.responses.UnlikePullRequestCommentResponse;
import com.oracle.bmc.devops.responses.UnsubscribePullRequestResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateBuildPipelineStageResponse;
import com.oracle.bmc.devops.responses.UpdateBuildRunResponse;
import com.oracle.bmc.devops.responses.UpdateConnectionResponse;
import com.oracle.bmc.devops.responses.UpdateDeployArtifactResponse;
import com.oracle.bmc.devops.responses.UpdateDeployEnvironmentResponse;
import com.oracle.bmc.devops.responses.UpdateDeployPipelineResponse;
import com.oracle.bmc.devops.responses.UpdateDeployStageResponse;
import com.oracle.bmc.devops.responses.UpdateDeploymentResponse;
import com.oracle.bmc.devops.responses.UpdateProjectNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.UpdateProjectRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.UpdateProjectResponse;
import com.oracle.bmc.devops.responses.UpdatePullRequestCommentResponse;
import com.oracle.bmc.devops.responses.UpdatePullRequestNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.UpdatePullRequestResponse;
import com.oracle.bmc.devops.responses.UpdateRepositoryNotificationPreferenceResponse;
import com.oracle.bmc.devops.responses.UpdateRepositoryResponse;
import com.oracle.bmc.devops.responses.UpdateRepositorySettingsResponse;
import com.oracle.bmc.devops.responses.UpdateTriggerResponse;
import com.oracle.bmc.devops.responses.ValidateConnectionResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseSyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.internal.ClientThreadFactory;
import com.oracle.bmc.util.CircuitBreakerUtils;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DevopsClient
extends BaseSyncClient
implements Devops {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DEVOPS").serviceEndpointPrefix("").serviceEndpointTemplate("https://devops.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DevopsClient.class);
    private final DevopsWaiters waiters;
    private final DevopsPaginators paginators;

    DevopsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService) {
        this(builder, authenticationDetailsProvider, executorService, true);
    }

    DevopsClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ExecutorService executorService, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider, CircuitBreakerUtils.DEFAULT_CIRCUIT_BREAKER_CONFIGURATION);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)ClientThreadFactory.builder().isDaemon(true).nameFormat("Devops-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DevopsWaiters(executorService, this);
        this.paginators = new DevopsPaginators(this);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DevopsClient", (String)"getObjectContent,getPullRequestAttachmentContent,getRepositoryArchiveContent,unsubscribePullRequest"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public ApproveDeploymentResponse approveDeployment(ApproveDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getApproveDeploymentDetails(), "approveDeploymentDetails is required");
        return (ApproveDeploymentResponse)this.clientCall(request, ApproveDeploymentResponse::builder).logger(LOG, "approveDeployment").serviceDetails("Devops", "ApproveDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/ApproveDeployment").method(Method.POST).requestBuilder(ApproveDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("approve").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, ApproveDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", ApproveDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ApproveDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelBuildRunResponse cancelBuildRun(CancelBuildRunRequest request) {
        Objects.requireNonNull(request.getCancelBuildRunDetails(), "cancelBuildRunDetails is required");
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        return (CancelBuildRunResponse)this.clientCall(request, CancelBuildRunResponse::builder).logger(LOG, "cancelBuildRun").serviceDetails("Devops", "CancelBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CancelBuildRun").method(Method.POST).requestBuilder(CancelBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(BuildRun.class, CancelBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", CancelBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelBuildRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelDeploymentResponse cancelDeployment(CancelDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCancelDeploymentDetails(), "cancelDeploymentDetails is required");
        return (CancelDeploymentResponse)this.clientCall(request, CancelDeploymentResponse::builder).logger(LOG, "cancelDeployment").serviceDetails("Devops", "CancelDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CancelDeployment").method(Method.POST).requestBuilder(CancelDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).appendPathParam("actions").appendPathParam("cancel").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, CancelDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", CancelDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CancelDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CancelScheduledCascadingProjectDeletionResponse cancelScheduledCascadingProjectDeletion(CancelScheduledCascadingProjectDeletionRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (CancelScheduledCascadingProjectDeletionResponse)this.clientCall(request, CancelScheduledCascadingProjectDeletionResponse::builder).logger(LOG, "cancelScheduledCascadingProjectDeletion").serviceDetails("Devops", "CancelScheduledCascadingProjectDeletion", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CancelScheduledCascadingProjectDeletion").method(Method.POST).requestBuilder(CancelScheduledCascadingProjectDeletionRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("cancelScheduledCascadingProjectDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", CancelScheduledCascadingProjectDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CancelScheduledCascadingProjectDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ChangeProjectCompartmentResponse changeProjectCompartment(ChangeProjectCompartmentRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeProjectCompartmentDetails(), "changeProjectCompartmentDetails is required");
        return (ChangeProjectCompartmentResponse)this.clientCall(request, ChangeProjectCompartmentResponse::builder).logger(LOG, "changeProjectCompartment").serviceDetails("Devops", "ChangeProjectCompartment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ChangeProjectCompartment").method(Method.POST).requestBuilder(ChangeProjectCompartmentRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", ChangeProjectCompartmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ChangeProjectCompartmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateBuildPipelineResponse createBuildPipeline(CreateBuildPipelineRequest request) {
        Objects.requireNonNull(request.getCreateBuildPipelineDetails(), "createBuildPipelineDetails is required");
        return (CreateBuildPipelineResponse)this.clientCall(request, CreateBuildPipelineResponse::builder).logger(LOG, "createBuildPipeline").serviceDetails("Devops", "CreateBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/CreateBuildPipeline").method(Method.POST).requestBuilder(CreateBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(BuildPipeline.class, CreateBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", CreateBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBuildPipelineResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildPipelineResponse.Builder::location).callSync();
    }

    @Override
    public CreateBuildPipelineStageResponse createBuildPipelineStage(CreateBuildPipelineStageRequest request) {
        Objects.requireNonNull(request.getCreateBuildPipelineStageDetails(), "createBuildPipelineStageDetails is required");
        return (CreateBuildPipelineStageResponse)this.clientCall(request, CreateBuildPipelineStageResponse::builder).logger(LOG, "createBuildPipelineStage").serviceDetails("Devops", "CreateBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/CreateBuildPipelineStage").method(Method.POST).requestBuilder(CreateBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(BuildPipelineStage.class, CreateBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", CreateBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateBuildPipelineStageResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildPipelineStageResponse.Builder::location).callSync();
    }

    @Override
    public CreateBuildRunResponse createBuildRun(CreateBuildRunRequest request) {
        Objects.requireNonNull(request.getCreateBuildRunDetails(), "createBuildRunDetails is required");
        return (CreateBuildRunResponse)this.clientCall(request, CreateBuildRunResponse::builder).logger(LOG, "createBuildRun").serviceDetails("Devops", "CreateBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/CreateBuildRun").method(Method.POST).requestBuilder(CreateBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).operationUsesDefaultRetries().hasBody().handleBody(BuildRun.class, CreateBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", CreateBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateBuildRunResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateBuildRunResponse.Builder::location).callSync();
    }

    @Override
    public CreateConnectionResponse createConnection(CreateConnectionRequest request) {
        Objects.requireNonNull(request.getCreateConnectionDetails(), "createConnectionDetails is required");
        return (CreateConnectionResponse)this.clientCall(request, CreateConnectionResponse::builder).logger(LOG, "createConnection").serviceDetails("Devops", "CreateConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/CreateConnection").method(Method.POST).requestBuilder(CreateConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, CreateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", CreateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateConnectionResponse.Builder::location).callSync();
    }

    @Override
    public CreateDeployArtifactResponse createDeployArtifact(CreateDeployArtifactRequest request) {
        Objects.requireNonNull(request.getCreateDeployArtifactDetails(), "createDeployArtifactDetails is required");
        return (CreateDeployArtifactResponse)this.clientCall(request, CreateDeployArtifactResponse::builder).logger(LOG, "createDeployArtifact").serviceDetails("Devops", "CreateDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/CreateDeployArtifact").method(Method.POST).requestBuilder(CreateDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployArtifact.class, CreateDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("location", CreateDeployArtifactResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployArtifactResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDeployEnvironmentResponse createDeployEnvironment(CreateDeployEnvironmentRequest request) {
        Objects.requireNonNull(request.getCreateDeployEnvironmentDetails(), "createDeployEnvironmentDetails is required");
        return (CreateDeployEnvironmentResponse)this.clientCall(request, CreateDeployEnvironmentResponse::builder).logger(LOG, "createDeployEnvironment").serviceDetails("Devops", "CreateDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/CreateDeployEnvironment").method(Method.POST).requestBuilder(CreateDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployEnvironment.class, CreateDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("location", CreateDeployEnvironmentResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDeployPipelineResponse createDeployPipeline(CreateDeployPipelineRequest request) {
        Objects.requireNonNull(request.getCreateDeployPipelineDetails(), "createDeployPipelineDetails is required");
        return (CreateDeployPipelineResponse)this.clientCall(request, CreateDeployPipelineResponse::builder).logger(LOG, "createDeployPipeline").serviceDetails("Devops", "CreateDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/CreateDeployPipeline").method(Method.POST).requestBuilder(CreateDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployPipeline.class, CreateDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("location", CreateDeployPipelineResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("etag", CreateDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDeployPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDeployStageResponse createDeployStage(CreateDeployStageRequest request) {
        Objects.requireNonNull(request.getCreateDeployStageDetails(), "createDeployStageDetails is required");
        return (CreateDeployStageResponse)this.clientCall(request, CreateDeployStageResponse::builder).logger(LOG, "createDeployStage").serviceDetails("Devops", "CreateDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/CreateDeployStage").method(Method.POST).requestBuilder(CreateDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployStage.class, CreateDeployStageResponse.Builder::deployStage).handleResponseHeaderString("location", CreateDeployStageResponse.Builder::location).handleResponseHeaderString("etag", CreateDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateDeployStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateDeploymentResponse createDeployment(CreateDeploymentRequest request) {
        Objects.requireNonNull(request.getCreateDeploymentDetails(), "createDeploymentDetails is required");
        return (CreateDeploymentResponse)this.clientCall(request, CreateDeploymentResponse::builder).logger(LOG, "createDeployment").serviceDetails("Devops", "CreateDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/CreateDeployment").method(Method.POST).requestBuilder(CreateDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, CreateDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", CreateDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOrUpdateGitRefResponse createOrUpdateGitRef(CreateOrUpdateGitRefRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOrUpdateGitRefDetails(), "createOrUpdateGitRefDetails is required");
        return (CreateOrUpdateGitRefResponse)this.clientCall(request, CreateOrUpdateGitRefResponse::builder).logger(LOG, "createOrUpdateGitRef").serviceDetails("Devops", "CreateOrUpdateGitRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/CreateOrUpdateGitRef").method(Method.POST).requestBuilder(CreateOrUpdateGitRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("createOrUpdateGitRef").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositoryRef.class, CreateOrUpdateGitRefResponse.Builder::repositoryRef).handleResponseHeaderString("location", CreateOrUpdateGitRefResponse.Builder::location).handleResponseHeaderString("etag", CreateOrUpdateGitRefResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateOrUpdateGitRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateOrUpdateGitRefResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateOrUpdateProtectedBranchResponse createOrUpdateProtectedBranch(CreateOrUpdateProtectedBranchRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreateOrUpdateProtectedBranchDetails(), "createOrUpdateProtectedBranchDetails is required");
        return (CreateOrUpdateProtectedBranchResponse)this.clientCall(request, CreateOrUpdateProtectedBranchResponse::builder).logger(LOG, "createOrUpdateProtectedBranch").serviceDetails("Devops", "CreateOrUpdateProtectedBranch", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProtectedBranch/CreateOrUpdateProtectedBranch").method(Method.POST).requestBuilder(CreateOrUpdateProtectedBranchRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("createOrUpdateProtectedBranch").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ProtectedBranch.class, CreateOrUpdateProtectedBranchResponse.Builder::protectedBranch).handleResponseHeaderString("location", CreateOrUpdateProtectedBranchResponse.Builder::location).handleResponseHeaderString("etag", CreateOrUpdateProtectedBranchResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateOrUpdateProtectedBranchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreateProjectResponse createProject(CreateProjectRequest request) {
        Objects.requireNonNull(request.getCreateProjectDetails(), "createProjectDetails is required");
        return (CreateProjectResponse)this.clientCall(request, CreateProjectResponse::builder).logger(LOG, "createProject").serviceDetails("Devops", "CreateProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/CreateProject").method(Method.POST).requestBuilder(CreateProjectRequest::builder).basePath("/20210630").appendPathParam("projects").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Project.class, CreateProjectResponse.Builder::project).handleResponseHeaderString("location", CreateProjectResponse.Builder::location).handleResponseHeaderString("etag", CreateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public CreatePullRequestResponse createPullRequest(CreatePullRequestRequest request) {
        Objects.requireNonNull(request.getCreatePullRequestDetails(), "createPullRequestDetails is required");
        return (CreatePullRequestResponse)this.clientCall(request, CreatePullRequestResponse::builder).logger(LOG, "createPullRequest").serviceDetails("Devops", "CreatePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/CreatePullRequest").method(Method.POST).requestBuilder(CreatePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequest.class, CreatePullRequestResponse.Builder::pullRequest).handleResponseHeaderString("location", CreatePullRequestResponse.Builder::location).handleResponseHeaderString("content-location", CreatePullRequestResponse.Builder::contentLocation).handleResponseHeaderString("opc-work-request-id", CreatePullRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreatePullRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePullRequestResponse.Builder::etag).callSync();
    }

    @Override
    public CreatePullRequestAttachmentResponse createPullRequestAttachment(CreatePullRequestAttachmentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getContentDisposition(), "contentDisposition is required");
        Objects.requireNonNull(request.getCreatePullRequestAttachmentBody(), "createPullRequestAttachmentBody is required");
        return (CreatePullRequestAttachmentResponse)this.clientCall(request, CreatePullRequestAttachmentResponse::builder).logger(LOG, "createPullRequestAttachment").serviceDetails("Devops", "CreatePullRequestAttachment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/CreatePullRequestAttachment").method(Method.POST).requestBuilder(CreatePullRequestAttachmentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("attachments").accept(new String[]{"application/json"}).appendHeader("content-disposition", request.getContentDisposition()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBinaryRequestBody().hasBody().handleBody(PullRequestAttachment.class, CreatePullRequestAttachmentResponse.Builder::pullRequestAttachment).handleResponseHeaderString("content-location", CreatePullRequestAttachmentResponse.Builder::contentLocation).handleResponseHeaderString("location", CreatePullRequestAttachmentResponse.Builder::location).handleResponseHeaderString("opc-request-id", CreatePullRequestAttachmentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePullRequestAttachmentResponse.Builder::etag).callSync();
    }

    @Override
    public CreatePullRequestCommentResponse createPullRequestComment(CreatePullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getCreatePullRequestCommentDetails(), "createPullRequestCommentDetails is required");
        return (CreatePullRequestCommentResponse)this.clientCall(request, CreatePullRequestCommentResponse::builder).logger(LOG, "createPullRequestComment").serviceDetails("Devops", "CreatePullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/CreatePullRequestComment").method(Method.POST).requestBuilder(CreatePullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequestComment.class, CreatePullRequestCommentResponse.Builder::pullRequestComment).handleResponseHeaderString("opc-request-id", CreatePullRequestCommentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreatePullRequestCommentResponse.Builder::etag).callSync();
    }

    @Override
    public CreateRepositoryResponse createRepository(CreateRepositoryRequest request) {
        Objects.requireNonNull(request.getCreateRepositoryDetails(), "createRepositoryDetails is required");
        return (CreateRepositoryResponse)this.clientCall(request, CreateRepositoryResponse::builder).logger(LOG, "createRepository").serviceDetails("Devops", "CreateRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/CreateRepository").method(Method.POST).requestBuilder(CreateRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Repository.class, CreateRepositoryResponse.Builder::repository).handleResponseHeaderString("location", CreateRepositoryResponse.Builder::location).handleResponseHeaderString("opc-work-request-id", CreateRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateRepositoryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", CreateRepositoryResponse.Builder::etag).callSync();
    }

    @Override
    public CreateTriggerResponse createTrigger(CreateTriggerRequest request) {
        Objects.requireNonNull(request.getCreateTriggerDetails(), "createTriggerDetails is required");
        return (CreateTriggerResponse)this.clientCall(request, CreateTriggerResponse::builder).logger(LOG, "createTrigger").serviceDetails("Devops", "CreateTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/CreateTrigger").method(Method.POST).requestBuilder(CreateTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(TriggerCreateResult.class, CreateTriggerResponse.Builder::triggerCreateResult).handleResponseHeaderString("etag", CreateTriggerResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", CreateTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", CreateTriggerResponse.Builder::opcRequestId).handleResponseHeaderString("location", CreateTriggerResponse.Builder::location).callSync();
    }

    @Override
    public DeclinePullRequestResponse declinePullRequest(DeclinePullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (DeclinePullRequestResponse)this.clientCall(request, DeclinePullRequestResponse::builder).logger(LOG, "declinePullRequest").serviceDetails("Devops", "DeclinePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/DeclinePullRequest").method(Method.POST).requestBuilder(DeclinePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("actions").appendPathParam("decline").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequest.class, DeclinePullRequestResponse.Builder::pullRequest).handleResponseHeaderString("location", DeclinePullRequestResponse.Builder::location).handleResponseHeaderString("opc-request-id", DeclinePullRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", DeclinePullRequestResponse.Builder::etag).callSync();
    }

    @Override
    public DeleteBuildPipelineResponse deleteBuildPipeline(DeleteBuildPipelineRequest request) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        return (DeleteBuildPipelineResponse)this.clientCall(request, DeleteBuildPipelineResponse::builder).logger(LOG, "deleteBuildPipeline").serviceDetails("Devops", "DeleteBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/DeleteBuildPipeline").method(Method.DELETE).requestBuilder(DeleteBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBuildPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteBuildPipelineStageResponse deleteBuildPipelineStage(DeleteBuildPipelineStageRequest request) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        return (DeleteBuildPipelineStageResponse)this.clientCall(request, DeleteBuildPipelineStageResponse::builder).logger(LOG, "deleteBuildPipelineStage").serviceDetails("Devops", "DeleteBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/DeleteBuildPipelineStage").method(Method.DELETE).requestBuilder(DeleteBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteBuildPipelineStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteConnectionResponse deleteConnection(DeleteConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (DeleteConnectionResponse)this.clientCall(request, DeleteConnectionResponse::builder).logger(LOG, "deleteConnection").serviceDetails("Devops", "DeleteConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/DeleteConnection").method(Method.DELETE).requestBuilder(DeleteConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDeployArtifactResponse deleteDeployArtifact(DeleteDeployArtifactRequest request) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        return (DeleteDeployArtifactResponse)this.clientCall(request, DeleteDeployArtifactResponse::builder).logger(LOG, "deleteDeployArtifact").serviceDetails("Devops", "DeleteDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/DeleteDeployArtifact").method(Method.DELETE).requestBuilder(DeleteDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployArtifactResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDeployEnvironmentResponse deleteDeployEnvironment(DeleteDeployEnvironmentRequest request) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        return (DeleteDeployEnvironmentResponse)this.clientCall(request, DeleteDeployEnvironmentResponse::builder).logger(LOG, "deleteDeployEnvironment").serviceDetails("Devops", "DeleteDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/DeleteDeployEnvironment").method(Method.DELETE).requestBuilder(DeleteDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDeployPipelineResponse deleteDeployPipeline(DeleteDeployPipelineRequest request) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        return (DeleteDeployPipelineResponse)this.clientCall(request, DeleteDeployPipelineResponse::builder).logger(LOG, "deleteDeployPipeline").serviceDetails("Devops", "DeleteDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/DeleteDeployPipeline").method(Method.DELETE).requestBuilder(DeleteDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteDeployStageResponse deleteDeployStage(DeleteDeployStageRequest request) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        return (DeleteDeployStageResponse)this.clientCall(request, DeleteDeployStageResponse::builder).logger(LOG, "deleteDeployStage").serviceDetails("Devops", "DeleteDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/DeleteDeployStage").method(Method.DELETE).requestBuilder(DeleteDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteDeployStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteGitRefResponse deleteGitRef(DeleteGitRefRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteGitRefDetails(), "deleteGitRefDetails is required");
        return (DeleteGitRefResponse)this.clientCall(request, DeleteGitRefResponse::builder).logger(LOG, "deleteGitRef").serviceDetails("Devops", "DeleteGitRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteGitRef").method(Method.POST).requestBuilder(DeleteGitRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("deleteGitRef").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", DeleteGitRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteGitRefResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProjectResponse deleteProject(DeleteProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectResponse)this.clientCall(request, DeleteProjectResponse::builder).logger(LOG, "deleteProject").serviceDetails("Devops", "DeleteProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/DeleteProject").method(Method.DELETE).requestBuilder(DeleteProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProjectRepositorySettingsResponse deleteProjectRepositorySettings(DeleteProjectRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (DeleteProjectRepositorySettingsResponse)this.clientCall(request, DeleteProjectRepositorySettingsResponse::builder).logger(LOG, "deleteProjectRepositorySettings").serviceDetails("Devops", "DeleteProjectRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectRepositorySettings/DeleteProjectRepositorySettings").method(Method.DELETE).requestBuilder(DeleteProjectRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteProjectRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteProtectedBranchResponse deleteProtectedBranch(DeleteProtectedBranchRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getDeleteProtectedBranchDetails(), "deleteProtectedBranchDetails is required");
        return (DeleteProtectedBranchResponse)this.clientCall(request, DeleteProtectedBranchResponse::builder).logger(LOG, "deleteProtectedBranch").serviceDetails("Devops", "DeleteProtectedBranch", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProtectedBranch/DeleteProtectedBranch").method(Method.POST).requestBuilder(DeleteProtectedBranchRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("deleteProtectedBranch").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-request-id", DeleteProtectedBranchResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePullRequestResponse deletePullRequest(DeletePullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (DeletePullRequestResponse)this.clientCall(request, DeletePullRequestResponse::builder).logger(LOG, "deletePullRequest").serviceDetails("Devops", "DeletePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/DeletePullRequest").method(Method.DELETE).requestBuilder(DeletePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeletePullRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePullRequestAttachmentResponse deletePullRequestAttachment(DeletePullRequestAttachmentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        return (DeletePullRequestAttachmentResponse)this.clientCall(request, DeletePullRequestAttachmentResponse::builder).logger(LOG, "deletePullRequestAttachment").serviceDetails("Devops", "DeletePullRequestAttachment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/DeletePullRequestAttachment").method(Method.DELETE).requestBuilder(DeletePullRequestAttachmentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeletePullRequestAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeletePullRequestCommentResponse deletePullRequestComment(DeletePullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommentId(), (String)"commentId must not be blank", (Object[])new Object[0]);
        return (DeletePullRequestCommentResponse)this.clientCall(request, DeletePullRequestCommentResponse::builder).logger(LOG, "deletePullRequestComment").serviceDetails("Devops", "DeletePullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/DeletePullRequestComment").method(Method.DELETE).requestBuilder(DeletePullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendPathParam(request.getCommentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeletePullRequestCommentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRefResponse deleteRef(DeleteRefRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        return (DeleteRefResponse)this.clientCall(request, DeleteRefResponse::builder).logger(LOG, "deleteRef").serviceDetails("Devops", "DeleteRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRef").method(Method.DELETE).requestBuilder(DeleteRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRefResponse.Builder::opcRequestId).handleResponseHeaderString("Sunset", DeleteRefResponse.Builder::sunset).callSync();
    }

    @Override
    public DeleteRepositoryResponse deleteRepository(DeleteRepositoryRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (DeleteRepositoryResponse)this.clientCall(request, DeleteRepositoryResponse::builder).logger(LOG, "deleteRepository").serviceDetails("Devops", "DeleteRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/DeleteRepository").method(Method.DELETE).requestBuilder(DeleteRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteRepositoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteRepositorySettingsResponse deleteRepositorySettings(DeleteRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (DeleteRepositorySettingsResponse)this.clientCall(request, DeleteRepositorySettingsResponse::builder).logger(LOG, "deleteRepositorySettings").serviceDetails("Devops", "DeleteRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositorySettings/DeleteRepositorySettings").method(Method.DELETE).requestBuilder(DeleteRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-request-id", DeleteRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest request) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        return (DeleteTriggerResponse)this.clientCall(request, DeleteTriggerResponse::builder).logger(LOG, "deleteTrigger").serviceDetails("Devops", "DeleteTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/DeleteTrigger").method(Method.DELETE).requestBuilder(DeleteTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", DeleteTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", DeleteTriggerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBuildPipelineResponse getBuildPipeline(GetBuildPipelineRequest request) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        return (GetBuildPipelineResponse)this.clientCall(request, GetBuildPipelineResponse::builder).logger(LOG, "getBuildPipeline").serviceDetails("Devops", "GetBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/GetBuildPipeline").method(Method.GET).requestBuilder(GetBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildPipeline.class, GetBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", GetBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBuildPipelineStageResponse getBuildPipelineStage(GetBuildPipelineStageRequest request) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        return (GetBuildPipelineStageResponse)this.clientCall(request, GetBuildPipelineStageResponse::builder).logger(LOG, "getBuildPipelineStage").serviceDetails("Devops", "GetBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/GetBuildPipelineStage").method(Method.GET).requestBuilder(GetBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildPipelineStage.class, GetBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", GetBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildPipelineStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetBuildRunResponse getBuildRun(GetBuildRunRequest request) {
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        return (GetBuildRunResponse)this.clientCall(request, GetBuildRunResponse::builder).logger(LOG, "getBuildRun").serviceDetails("Devops", "GetBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/GetBuildRun").method(Method.GET).requestBuilder(GetBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildRun.class, GetBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", GetBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBuildRunResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCommitResponse getCommit(GetCommitRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommitId(), (String)"commitId must not be blank", (Object[])new Object[0]);
        return (GetCommitResponse)this.clientCall(request, GetCommitResponse::builder).logger(LOG, "getCommit").serviceDetails("Devops", "GetCommit", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommit").method(Method.GET).requestBuilder(GetCommitRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("commits").appendPathParam(request.getCommitId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryCommit.class, GetCommitResponse.Builder::repositoryCommit).handleResponseHeaderString("etag", GetCommitResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCommitResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetCommitDiffResponse getCommitDiff(GetCommitDiffRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return (GetCommitDiffResponse)this.clientCall(request, GetCommitDiffResponse::builder).logger(LOG, "getCommitDiff").serviceDetails("Devops", "GetCommitDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetCommitDiff").method(Method.GET).requestBuilder(GetCommitDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diff").appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("targetRepositoryId", (Object)request.getTargetRepositoryId()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DiffResponse.class, GetCommitDiffResponse.Builder::diffResponse).handleResponseHeaderString("etag", GetCommitDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetCommitDiffResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetConnectionResponse getConnection(GetConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (GetConnectionResponse)this.clientCall(request, GetConnectionResponse::builder).logger(LOG, "getConnection").serviceDetails("Devops", "GetConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/GetConnection").method(Method.GET).requestBuilder(GetConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Connection.class, GetConnectionResponse.Builder::connection).handleResponseHeaderString("etag", GetConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConnectionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeployArtifactResponse getDeployArtifact(GetDeployArtifactRequest request) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        return (GetDeployArtifactResponse)this.clientCall(request, GetDeployArtifactResponse::builder).logger(LOG, "getDeployArtifact").serviceDetails("Devops", "GetDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/GetDeployArtifact").method(Method.GET).requestBuilder(GetDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployArtifact.class, GetDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("etag", GetDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployArtifactResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeployEnvironmentResponse getDeployEnvironment(GetDeployEnvironmentRequest request) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        return (GetDeployEnvironmentResponse)this.clientCall(request, GetDeployEnvironmentResponse::builder).logger(LOG, "getDeployEnvironment").serviceDetails("Devops", "GetDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/GetDeployEnvironment").method(Method.GET).requestBuilder(GetDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployEnvironment.class, GetDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("etag", GetDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeployPipelineResponse getDeployPipeline(GetDeployPipelineRequest request) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        return (GetDeployPipelineResponse)this.clientCall(request, GetDeployPipelineResponse::builder).logger(LOG, "getDeployPipeline").serviceDetails("Devops", "GetDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/GetDeployPipeline").method(Method.GET).requestBuilder(GetDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployPipeline.class, GetDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("etag", GetDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeployStageResponse getDeployStage(GetDeployStageRequest request) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        return (GetDeployStageResponse)this.clientCall(request, GetDeployStageResponse::builder).logger(LOG, "getDeployStage").serviceDetails("Devops", "GetDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/GetDeployStage").method(Method.GET).requestBuilder(GetDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployStage.class, GetDeployStageResponse.Builder::deployStage).handleResponseHeaderString("etag", GetDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeployStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetDeploymentResponse getDeployment(GetDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        return (GetDeploymentResponse)this.clientCall(request, GetDeploymentResponse::builder).logger(LOG, "getDeployment").serviceDetails("Devops", "GetDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/GetDeployment").method(Method.GET).requestBuilder(GetDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Deployment.class, GetDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", GetDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetFileDiffResponse getFileDiff(GetFileDiffRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return (GetFileDiffResponse)this.clientCall(request, GetFileDiffResponse::builder).logger(LOG, "getFileDiff").serviceDetails("Devops", "GetFileDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetFileDiff").method(Method.GET).requestBuilder(GetFileDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diffs").appendPathParam(request.getFilePath()).appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FileDiffResponse.class, GetFileDiffResponse.Builder::fileDiffResponse).handleResponseHeaderString("etag", GetFileDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetFileDiffResponse.Builder::opcRequestId).handleResponseHeaderString("Sunset", GetFileDiffResponse.Builder::sunset).callSync();
    }

    @Override
    public GetMirrorRecordResponse getMirrorRecord(GetMirrorRecordRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getMirrorRecordType().getValue(), (String)"mirrorRecordType must not be blank", (Object[])new Object[0]);
        return (GetMirrorRecordResponse)this.clientCall(request, GetMirrorRecordResponse::builder).logger(LOG, "getMirrorRecord").serviceDetails("Devops", "GetMirrorRecord", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetMirrorRecord").method(Method.GET).requestBuilder(GetMirrorRecordRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("mirrorRecords").appendPathParam(request.getMirrorRecordType().getValue()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryMirrorRecord.class, GetMirrorRecordResponse.Builder::repositoryMirrorRecord).handleResponseHeaderString("etag", GetMirrorRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMirrorRecordResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetObjectResponse getObject(GetObjectRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (GetObjectResponse)this.clientCall(request, GetObjectResponse::builder).logger(LOG, "getObject").serviceDetails("Devops", "GetObject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryObject/GetObject").method(Method.GET).requestBuilder(GetObjectRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("object").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("refName", (Object)request.getRefName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryObject.class, GetObjectResponse.Builder::repositoryObject).handleResponseHeaderString("opc-request-id", GetObjectResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetObjectResponse.Builder::etag).callSync();
    }

    @Override
    public GetObjectContentResponse getObjectContent(GetObjectContentRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getSha(), (String)"sha must not be blank", (Object[])new Object[0]);
        return (GetObjectContentResponse)this.clientCall(request, GetObjectContentResponse::builder).logger(LOG, "getObjectContent").serviceDetails("Devops", "GetObjectContent", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetObjectContent").method(Method.GET).requestBuilder(GetObjectContentRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("objects").appendPathParam(request.getSha()).appendPathParam("content").appendQueryParam("filePath", (Object)request.getFilePath()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetObjectContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetObjectContentResponse.Builder::opcRequestId).handleResponseHeaderString("Content-Type", GetObjectContentResponse.Builder::contentType).handleResponseHeaderString("Content-Disposition", GetObjectContentResponse.Builder::contentDisposition).callSync();
    }

    @Override
    public GetProjectResponse getProject(GetProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectResponse)this.clientCall(request, GetProjectResponse::builder).logger(LOG, "getProject").serviceDetails("Devops", "GetProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/GetProject").method(Method.GET).requestBuilder(GetProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Project.class, GetProjectResponse.Builder::project).handleResponseHeaderString("etag", GetProjectResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProjectNotificationPreferenceResponse getProjectNotificationPreference(GetProjectNotificationPreferenceRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (GetProjectNotificationPreferenceResponse)this.clientCall(request, GetProjectNotificationPreferenceResponse::builder).logger(LOG, "getProjectNotificationPreference").serviceDetails("Devops", "GetProjectNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectNotificationPreference/GetProjectNotificationPreference").method(Method.GET).requestBuilder(GetProjectNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProjectNotificationPreference.class, GetProjectNotificationPreferenceResponse.Builder::projectNotificationPreference).handleResponseHeaderString("etag", GetProjectNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetProjectRepositorySettingsResponse getProjectRepositorySettings(GetProjectRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (GetProjectRepositorySettingsResponse)this.clientCall(request, GetProjectRepositorySettingsResponse::builder).logger(LOG, "getProjectRepositorySettings").serviceDetails("Devops", "GetProjectRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectRepositorySettings/GetProjectRepositorySettings").method(Method.GET).requestBuilder(GetProjectRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProjectRepositorySettings.class, GetProjectRepositorySettingsResponse.Builder::projectRepositorySettings).handleResponseHeaderString("etag", GetProjectRepositorySettingsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetProjectRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestResponse getPullRequest(GetPullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestResponse)this.clientCall(request, GetPullRequestResponse::builder).logger(LOG, "getPullRequest").serviceDetails("Devops", "GetPullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/GetPullRequest").method(Method.GET).requestBuilder(GetPullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequest.class, GetPullRequestResponse.Builder::pullRequest).handleResponseHeaderString("etag", GetPullRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPullRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestAttachmentResponse getPullRequestAttachment(GetPullRequestAttachmentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestAttachmentResponse)this.clientCall(request, GetPullRequestAttachmentResponse::builder).logger(LOG, "getPullRequestAttachment").serviceDetails("Devops", "GetPullRequestAttachment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/GetPullRequestAttachment").method(Method.GET).requestBuilder(GetPullRequestAttachmentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestAttachment.class, GetPullRequestAttachmentResponse.Builder::pullRequestAttachment).handleResponseHeaderString("etag", GetPullRequestAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPullRequestAttachmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestAttachmentContentResponse getPullRequestAttachmentContent(GetPullRequestAttachmentContentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getAttachmentId(), (String)"attachmentId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestAttachmentContentResponse)this.clientCall(request, GetPullRequestAttachmentContentResponse::builder).logger(LOG, "getPullRequestAttachmentContent").serviceDetails("Devops", "GetPullRequestAttachmentContent", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/GetPullRequestAttachmentContent").method(Method.GET).requestBuilder(GetPullRequestAttachmentContentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("attachments").appendPathParam(request.getAttachmentId()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetPullRequestAttachmentContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetPullRequestAttachmentContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPullRequestAttachmentContentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestChangeSummaryMetricsResponse getPullRequestChangeSummaryMetrics(GetPullRequestChangeSummaryMetricsRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestChangeSummaryMetricsResponse)this.clientCall(request, GetPullRequestChangeSummaryMetricsResponse::builder).logger(LOG, "getPullRequestChangeSummaryMetrics").serviceDetails("Devops", "GetPullRequestChangeSummaryMetrics", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/GetPullRequestChangeSummaryMetrics").method(Method.GET).requestBuilder(GetPullRequestChangeSummaryMetricsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("changeSummaryMetrics").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestChangeSummaryMetrics.class, GetPullRequestChangeSummaryMetricsResponse.Builder::pullRequestChangeSummaryMetrics).handleResponseHeaderString("opc-request-id", GetPullRequestChangeSummaryMetricsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestCommentResponse getPullRequestComment(GetPullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommentId(), (String)"commentId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestCommentResponse)this.clientCall(request, GetPullRequestCommentResponse::builder).logger(LOG, "getPullRequestComment").serviceDetails("Devops", "GetPullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/GetPullRequestComment").method(Method.GET).requestBuilder(GetPullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendPathParam(request.getCommentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestComment.class, GetPullRequestCommentResponse.Builder::pullRequestComment).handleResponseHeaderString("etag", GetPullRequestCommentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPullRequestCommentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetPullRequestNotificationPreferenceResponse getPullRequestNotificationPreference(GetPullRequestNotificationPreferenceRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (GetPullRequestNotificationPreferenceResponse)this.clientCall(request, GetPullRequestNotificationPreferenceResponse::builder).logger(LOG, "getPullRequestNotificationPreference").serviceDetails("Devops", "GetPullRequestNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequestNotificationPreference/GetPullRequestNotificationPreference").method(Method.GET).requestBuilder(GetPullRequestNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestNotificationPreference.class, GetPullRequestNotificationPreferenceResponse.Builder::pullRequestNotificationPreference).handleResponseHeaderString("etag", GetPullRequestNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetPullRequestNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRefResponse getRef(GetRefRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        return (GetRefResponse)this.clientCall(request, GetRefResponse::builder).logger(LOG, "getRef").serviceDetails("Devops", "GetRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRef").method(Method.GET).requestBuilder(GetRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryRef.class, GetRefResponse.Builder::repositoryRef).handleResponseHeaderString("etag", GetRefResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRefResponse.Builder::opcRequestId).handleResponseHeaderString("Sunset", GetRefResponse.Builder::sunset).callSync();
    }

    @Override
    public GetRepoFileDiffResponse getRepoFileDiff(GetRepoFileDiffRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return (GetRepoFileDiffResponse)this.clientCall(request, GetRepoFileDiffResponse::builder).logger(LOG, "getRepoFileDiff").serviceDetails("Devops", "GetRepoFileDiff", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileDiff").method(Method.GET).requestBuilder(GetRepoFileDiffRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("file").appendPathParam("diffs").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(FileDiffResponse.class, GetRepoFileDiffResponse.Builder::fileDiffResponse).handleResponseHeaderString("etag", GetRepoFileDiffResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepoFileDiffResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRepoFileLinesResponse getRepoFileLines(GetRepoFileLinesRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevision(), "revision is required");
        return (GetRepoFileLinesResponse)this.clientCall(request, GetRepoFileLinesResponse::builder).logger(LOG, "getRepoFileLines").serviceDetails("Devops", "GetRepoFileLines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepoFileLines").method(Method.GET).requestBuilder(GetRepoFileLinesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("file").appendPathParam("lines").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("revision", (Object)request.getRevision()).appendQueryParam("startLineNumber", (Object)request.getStartLineNumber()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryFileLines.class, GetRepoFileLinesResponse.Builder::repositoryFileLines).handleResponseHeaderString("opc-request-id", GetRepoFileLinesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRepoFileLinesResponse.Builder::etag).callSync();
    }

    @Override
    public GetRepositoryResponse getRepository(GetRepositoryRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (GetRepositoryResponse)this.clientCall(request, GetRepositoryResponse::builder).logger(LOG, "getRepository").serviceDetails("Devops", "GetRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepository").method(Method.GET).requestBuilder(GetRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendListQueryParam("fields", request.getFields(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Repository.class, GetRepositoryResponse.Builder::repository).handleResponseHeaderString("etag", GetRepositoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepositoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRepositoryArchiveContentResponse getRepositoryArchiveContent(GetRepositoryArchiveContentRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (GetRepositoryArchiveContentResponse)this.clientCall(request, GetRepositoryArchiveContentResponse::builder).logger(LOG, "getRepositoryArchiveContent").serviceDetails("Devops", "GetRepositoryArchiveContent", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryArchiveContent").method(Method.GET).requestBuilder(GetRepositoryArchiveContentRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("archive").appendPathParam("content").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("format", (Object)request.getFormat()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, GetRepositoryArchiveContentResponse.Builder::inputStream).handleResponseHeaderString("opc-request-id", GetRepositoryArchiveContentResponse.Builder::opcRequestId).handleResponseHeaderString("Content-Type", GetRepositoryArchiveContentResponse.Builder::contentType).handleResponseHeaderString("Content-Disposition", GetRepositoryArchiveContentResponse.Builder::contentDisposition).callSync();
    }

    @Override
    public GetRepositoryFileLinesResponse getRepositoryFileLines(GetRepositoryFileLinesRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getFilePath(), (String)"filePath must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getRevision(), "revision is required");
        return (GetRepositoryFileLinesResponse)this.clientCall(request, GetRepositoryFileLinesResponse::builder).logger(LOG, "getRepositoryFileLines").serviceDetails("Devops", "GetRepositoryFileLines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/GetRepositoryFileLines").method(Method.GET).requestBuilder(GetRepositoryFileLinesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("files").appendPathParam(request.getFilePath()).appendPathParam("lines").appendQueryParam("revision", (Object)request.getRevision()).appendQueryParam("startLineNumber", (Object)request.getStartLineNumber()).appendQueryParam("limit", (Object)request.getLimit()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryFileLines.class, GetRepositoryFileLinesResponse.Builder::repositoryFileLines).handleResponseHeaderString("opc-request-id", GetRepositoryFileLinesResponse.Builder::opcRequestId).handleResponseHeaderString("etag", GetRepositoryFileLinesResponse.Builder::etag).handleResponseHeaderString("Sunset", GetRepositoryFileLinesResponse.Builder::sunset).callSync();
    }

    @Override
    public GetRepositoryNotificationPreferenceResponse getRepositoryNotificationPreference(GetRepositoryNotificationPreferenceRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (GetRepositoryNotificationPreferenceResponse)this.clientCall(request, GetRepositoryNotificationPreferenceResponse::builder).logger(LOG, "getRepositoryNotificationPreference").serviceDetails("Devops", "GetRepositoryNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryNotificationPreference/GetRepositoryNotificationPreference").method(Method.GET).requestBuilder(GetRepositoryNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryNotificationPreference.class, GetRepositoryNotificationPreferenceResponse.Builder::repositoryNotificationPreference).handleResponseHeaderString("etag", GetRepositoryNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepositoryNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetRepositorySettingsResponse getRepositorySettings(GetRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (GetRepositorySettingsResponse)this.clientCall(request, GetRepositorySettingsResponse::builder).logger(LOG, "getRepositorySettings").serviceDetails("Devops", "GetRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositorySettings/GetRepositorySettings").method(Method.GET).requestBuilder(GetRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositorySettings.class, GetRepositorySettingsResponse.Builder::repositorySettings).handleResponseHeaderString("etag", GetRepositorySettingsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetTriggerResponse getTrigger(GetTriggerRequest request) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        return (GetTriggerResponse)this.clientCall(request, GetTriggerResponse::builder).logger(LOG, "getTrigger").serviceDetails("Devops", "GetTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/GetTrigger").method(Method.GET).requestBuilder(GetTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(Trigger.class, GetTriggerResponse.Builder::trigger).handleResponseHeaderString("etag", GetTriggerResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetTriggerResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (GetWorkRequestResponse)this.clientCall(request, GetWorkRequestResponse::builder).logger(LOG, "getWorkRequest").serviceDetails("Devops", "GetWorkRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/GetWorkRequest").method(Method.GET).requestBuilder(GetWorkRequestRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequest.class, GetWorkRequestResponse.Builder::workRequest).handleResponseHeaderString("opc-request-id", GetWorkRequestResponse.Builder::opcRequestId).handleResponseHeaderFloat("retry-after", GetWorkRequestResponse.Builder::retryAfter).callSync();
    }

    @Override
    public LikePullRequestCommentResponse likePullRequestComment(LikePullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommentId(), (String)"commentId must not be blank", (Object[])new Object[0]);
        return (LikePullRequestCommentResponse)this.clientCall(request, LikePullRequestCommentResponse::builder).logger(LOG, "likePullRequestComment").serviceDetails("Devops", "LikePullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/LikePullRequestComment").method(Method.POST).requestBuilder(LikePullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendPathParam(request.getCommentId()).appendPathParam("actions").appendPathParam("like").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestComment.class, LikePullRequestCommentResponse.Builder::pullRequestComment).handleResponseHeaderString("opc-request-id", LikePullRequestCommentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", LikePullRequestCommentResponse.Builder::etag).callSync();
    }

    @Override
    public ListAuthorsResponse listAuthors(ListAuthorsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListAuthorsResponse)this.clientCall(request, ListAuthorsResponse::builder).logger(LOG, "listAuthors").serviceDetails("Devops", "ListAuthors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListAuthors").method(Method.GET).requestBuilder(ListAuthorsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("authors").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryAuthorCollection.class, ListAuthorsResponse.Builder::repositoryAuthorCollection).handleResponseHeaderString("opc-request-id", ListAuthorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAuthorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBuildPipelineStagesResponse listBuildPipelineStages(ListBuildPipelineStagesRequest request) {
        return (ListBuildPipelineStagesResponse)this.clientCall(request, ListBuildPipelineStagesResponse::builder).logger(LOG, "listBuildPipelineStages").serviceDetails("Devops", "ListBuildPipelineStages", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStageSummary/ListBuildPipelineStages").method(Method.GET).requestBuilder(ListBuildPipelineStagesRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendQueryParam("id", (Object)request.getId()).appendQueryParam("buildPipelineId", (Object)request.getBuildPipelineId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildPipelineStageCollection.class, ListBuildPipelineStagesResponse.Builder::buildPipelineStageCollection).handleResponseHeaderString("opc-request-id", ListBuildPipelineStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildPipelineStagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBuildPipelinesResponse listBuildPipelines(ListBuildPipelinesRequest request) {
        return (ListBuildPipelinesResponse)this.clientCall(request, ListBuildPipelinesResponse::builder).logger(LOG, "listBuildPipelines").serviceDetails("Devops", "ListBuildPipelines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineCollection/ListBuildPipelines").method(Method.GET).requestBuilder(ListBuildPipelinesRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildPipelineCollection.class, ListBuildPipelinesResponse.Builder::buildPipelineCollection).handleResponseHeaderString("opc-request-id", ListBuildPipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildPipelinesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBuildRunSnapshotsResponse listBuildRunSnapshots(ListBuildRunSnapshotsRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListBuildRunSnapshotsResponse)this.clientCall(request, ListBuildRunSnapshotsResponse::builder).logger(LOG, "listBuildRunSnapshots").serviceDetails("Devops", "ListBuildRunSnapshots", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListBuildRunSnapshots").method(Method.GET).requestBuilder(ListBuildRunSnapshotsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("buildRunSnapshots").appendQueryParam("pipelineId", (Object)request.getPipelineId()).appendQueryParam("buildRunId", (Object)request.getBuildRunId()).appendQueryParam("commitId", (Object)request.getCommitId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildRunSnapshotCollection.class, ListBuildRunSnapshotsResponse.Builder::buildRunSnapshotCollection).handleResponseHeaderString("opc-request-id", ListBuildRunSnapshotsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildRunSnapshotsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListBuildRunsResponse listBuildRuns(ListBuildRunsRequest request) {
        return (ListBuildRunsResponse)this.clientCall(request, ListBuildRunsResponse::builder).logger(LOG, "listBuildRuns").serviceDetails("Devops", "ListBuildRuns", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRunSummary/ListBuildRuns").method(Method.GET).requestBuilder(ListBuildRunsRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendQueryParam("id", (Object)request.getId()).appendQueryParam("buildPipelineId", (Object)request.getBuildPipelineId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(BuildRunSummaryCollection.class, ListBuildRunsResponse.Builder::buildRunSummaryCollection).handleResponseHeaderString("opc-request-id", ListBuildRunsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListBuildRunsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListCommitDiffsResponse listCommitDiffs(ListCommitDiffsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBaseVersion(), "baseVersion is required");
        Objects.requireNonNull(request.getTargetVersion(), "targetVersion is required");
        return (ListCommitDiffsResponse)this.clientCall(request, ListCommitDiffsResponse::builder).logger(LOG, "listCommitDiffs").serviceDetails("Devops", "ListCommitDiffs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListCommitDiffs").method(Method.GET).requestBuilder(ListCommitDiffsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("diffs").appendQueryParam("baseVersion", (Object)request.getBaseVersion()).appendQueryParam("targetVersion", (Object)request.getTargetVersion()).appendQueryParam("targetRepositoryId", (Object)request.getTargetRepositoryId()).appendQueryParam("isComparisonFromMergeBase", (Object)request.getIsComparisonFromMergeBase()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DiffCollection.class, ListCommitDiffsResponse.Builder::diffCollection).handleResponseHeaderString("opc-request-id", ListCommitDiffsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCommitDiffsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListCommitsResponse listCommits(ListCommitsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListCommitsResponse)this.clientCall(request, ListCommitsResponse::builder).logger(LOG, "listCommits").serviceDetails("Devops", "ListCommits", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryCommit/ListCommits").method(Method.GET).requestBuilder(ListCommitsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("commits").appendQueryParam("refName", (Object)request.getRefName()).appendQueryParam("excludeRefName", (Object)request.getExcludeRefName()).appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("timestampGreaterThanOrEqualTo", (Object)request.getTimestampGreaterThanOrEqualTo()).appendQueryParam("timestampLessThanOrEqualTo", (Object)request.getTimestampLessThanOrEqualTo()).appendQueryParam("commitMessage", (Object)request.getCommitMessage()).appendQueryParam("authorName", (Object)request.getAuthorName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryCommitCollection.class, ListCommitsResponse.Builder::repositoryCommitCollection).handleResponseHeaderString("opc-request-id", ListCommitsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListCommitsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListConnectionsResponse listConnections(ListConnectionsRequest request) {
        return (ListConnectionsResponse)this.clientCall(request, ListConnectionsResponse::builder).logger(LOG, "listConnections").serviceDetails("Devops", "ListConnections", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ConnectionCollection/ListConnections").method(Method.GET).requestBuilder(ListConnectionsRequest::builder).basePath("/20210630").appendPathParam("connections").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("connectionType", (BmcEnum)request.getConnectionType()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ConnectionCollection.class, ListConnectionsResponse.Builder::connectionCollection).handleResponseHeaderString("opc-request-id", ListConnectionsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListConnectionsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeployArtifactsResponse listDeployArtifacts(ListDeployArtifactsRequest request) {
        return (ListDeployArtifactsResponse)this.clientCall(request, ListDeployArtifactsResponse::builder).logger(LOG, "listDeployArtifacts").serviceDetails("Devops", "ListDeployArtifacts", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifactSummary/ListDeployArtifacts").method(Method.GET).requestBuilder(ListDeployArtifactsRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployArtifactCollection.class, ListDeployArtifactsResponse.Builder::deployArtifactCollection).handleResponseHeaderString("opc-request-id", ListDeployArtifactsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployArtifactsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeployEnvironmentsResponse listDeployEnvironments(ListDeployEnvironmentsRequest request) {
        return (ListDeployEnvironmentsResponse)this.clientCall(request, ListDeployEnvironmentsResponse::builder).logger(LOG, "listDeployEnvironments").serviceDetails("Devops", "ListDeployEnvironments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironmentSummary/ListDeployEnvironments").method(Method.GET).requestBuilder(ListDeployEnvironmentsRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("id", (Object)request.getId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployEnvironmentCollection.class, ListDeployEnvironmentsResponse.Builder::deployEnvironmentCollection).handleResponseHeaderString("opc-request-id", ListDeployEnvironmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployEnvironmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeployPipelinesResponse listDeployPipelines(ListDeployPipelinesRequest request) {
        return (ListDeployPipelinesResponse)this.clientCall(request, ListDeployPipelinesResponse::builder).logger(LOG, "listDeployPipelines").serviceDetails("Devops", "ListDeployPipelines", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipelineSummary/ListDeployPipelines").method(Method.GET).requestBuilder(ListDeployPipelinesRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendQueryParam("id", (Object)request.getId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployPipelineCollection.class, ListDeployPipelinesResponse.Builder::deployPipelineCollection).handleResponseHeaderString("opc-request-id", ListDeployPipelinesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployPipelinesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeployStagesResponse listDeployStages(ListDeployStagesRequest request) {
        return (ListDeployStagesResponse)this.clientCall(request, ListDeployStagesResponse::builder).logger(LOG, "listDeployStages").serviceDetails("Devops", "ListDeployStages", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStageSummary/ListDeployStages").method(Method.GET).requestBuilder(ListDeployStagesRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendQueryParam("id", (Object)request.getId()).appendQueryParam("deployPipelineId", (Object)request.getDeployPipelineId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeployStageCollection.class, ListDeployStagesResponse.Builder::deployStageCollection).handleResponseHeaderString("opc-request-id", ListDeployStagesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeployStagesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListDeploymentsResponse listDeployments(ListDeploymentsRequest request) {
        return (ListDeploymentsResponse)this.clientCall(request, ListDeploymentsResponse::builder).logger(LOG, "listDeployments").serviceDetails("Devops", "ListDeployments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeploymentSummary/ListDeployments").method(Method.GET).requestBuilder(ListDeploymentsRequest::builder).basePath("/20210630").appendPathParam("deployments").appendQueryParam("deployPipelineId", (Object)request.getDeployPipelineId()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("timeCreatedLessThan", (Object)request.getTimeCreatedLessThan()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(DeploymentCollection.class, ListDeploymentsResponse.Builder::deploymentCollection).handleResponseHeaderString("opc-request-id", ListDeploymentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListDeploymentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListForkSyncStatusesResponse listForkSyncStatuses(ListForkSyncStatusesRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getBranchNameQueryParam(), "branchNameQueryParam is required");
        return (ListForkSyncStatusesResponse)this.clientCall(request, ListForkSyncStatusesResponse::builder).logger(LOG, "listForkSyncStatuses").serviceDetails("Devops", "ListForkSyncStatuses", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListForkSyncStatuses").method(Method.GET).requestBuilder(ListForkSyncStatusesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("forkSyncStatuses").appendQueryParam("branchNameQueryParam", (Object)request.getBranchNameQueryParam()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ForkSyncStatusCollection.class, ListForkSyncStatusesResponse.Builder::forkSyncStatusCollection).handleResponseHeaderString("etag", ListForkSyncStatusesResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ListForkSyncStatusesResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListMirrorRecordsResponse listMirrorRecords(ListMirrorRecordsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListMirrorRecordsResponse)this.clientCall(request, ListMirrorRecordsResponse::builder).logger(LOG, "listMirrorRecords").serviceDetails("Devops", "ListMirrorRecords", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListMirrorRecords").method(Method.GET).requestBuilder(ListMirrorRecordsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("mirrorRecords").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryMirrorRecordCollection.class, ListMirrorRecordsResponse.Builder::repositoryMirrorRecordCollection).handleResponseHeaderString("opc-request-id", ListMirrorRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListMirrorRecordsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPathsResponse listPaths(ListPathsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListPathsResponse)this.clientCall(request, ListPathsResponse::builder).logger(LOG, "listPaths").serviceDetails("Devops", "ListPaths", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryPathSummary/ListPaths").method(Method.GET).requestBuilder(ListPathsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("paths").appendQueryParam("ref", (Object)request.getRef()).appendQueryParam("pathsInSubtree", (Object)request.getPathsInSubtree()).appendQueryParam("folderPath", (Object)request.getFolderPath()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryPathCollection.class, ListPathsResponse.Builder::repositoryPathCollection).handleResponseHeaderString("opc-request-id", ListPathsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPathsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProjectCommitAnalyticsAuthorsResponse listProjectCommitAnalyticsAuthors(ListProjectCommitAnalyticsAuthorsRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (ListProjectCommitAnalyticsAuthorsResponse)this.clientCall(request, ListProjectCommitAnalyticsAuthorsResponse::builder).logger(LOG, "listProjectCommitAnalyticsAuthors").serviceDetails("Devops", "ListProjectCommitAnalyticsAuthors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListProjectCommitAnalyticsAuthors").method(Method.GET).requestBuilder(ListProjectCommitAnalyticsAuthorsRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("commitAnalyticsAuthors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CommitAnalyticsAuthorCollection.class, ListProjectCommitAnalyticsAuthorsResponse.Builder::commitAnalyticsAuthorCollection).handleResponseHeaderString("opc-request-id", ListProjectCommitAnalyticsAuthorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectCommitAnalyticsAuthorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProjectsResponse listProjects(ListProjectsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListProjectsResponse)this.clientCall(request, ListProjectsResponse::builder).logger(LOG, "listProjects").serviceDetails("Devops", "ListProjects", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectSummary/ListProjects").method(Method.GET).requestBuilder(ListProjectsRequest::builder).basePath("/20210630").appendPathParam("projects").appendQueryParam("id", (Object)request.getId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProjectCollection.class, ListProjectsResponse.Builder::projectCollection).handleResponseHeaderString("opc-request-id", ListProjectsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProjectsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListProtectedBranchesResponse listProtectedBranches(ListProtectedBranchesRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListProtectedBranchesResponse)this.clientCall(request, ListProtectedBranchesResponse::builder).logger(LOG, "listProtectedBranches").serviceDetails("Devops", "ListProtectedBranches", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProtectedBranchCollection/ListProtectedBranches").method(Method.GET).requestBuilder(ListProtectedBranchesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("protectedBranches").appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(ProtectedBranchCollection.class, ListProtectedBranchesResponse.Builder::protectedBranchCollection).handleResponseHeaderString("opc-request-id", ListProtectedBranchesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListProtectedBranchesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestActivitiesResponse listPullRequestActivities(ListPullRequestActivitiesRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestActivitiesResponse)this.clientCall(request, ListPullRequestActivitiesResponse::builder).logger(LOG, "listPullRequestActivities").serviceDetails("Devops", "ListPullRequestActivities", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ListPullRequestActivities").method(Method.GET).requestBuilder(ListPullRequestActivitiesRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("activities").appendEnumQueryParam("activityType", (BmcEnum)request.getActivityType()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestActivityCollection.class, ListPullRequestActivitiesResponse.Builder::pullRequestActivityCollection).handleResponseHeaderString("opc-request-id", ListPullRequestActivitiesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestActivitiesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestAttachmentsResponse listPullRequestAttachments(ListPullRequestAttachmentsRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestAttachmentsResponse)this.clientCall(request, ListPullRequestAttachmentsResponse::builder).logger(LOG, "listPullRequestAttachments").serviceDetails("Devops", "ListPullRequestAttachments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ListPullRequestAttachments").method(Method.GET).requestBuilder(ListPullRequestAttachmentsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("attachments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("fileName", (Object)request.getFileName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestAttachmentCollection.class, ListPullRequestAttachmentsResponse.Builder::pullRequestAttachmentCollection).handleResponseHeaderString("opc-request-id", ListPullRequestAttachmentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestAttachmentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestAuthorsResponse listPullRequestAuthors(ListPullRequestAuthorsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestAuthorsResponse)this.clientCall(request, ListPullRequestAuthorsResponse::builder).logger(LOG, "listPullRequestAuthors").serviceDetails("Devops", "ListPullRequestAuthors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListPullRequestAuthors").method(Method.GET).requestBuilder(ListPullRequestAuthorsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("pullRequestAuthors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestAuthorCollection.class, ListPullRequestAuthorsResponse.Builder::pullRequestAuthorCollection).handleResponseHeaderString("opc-request-id", ListPullRequestAuthorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestAuthorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestCommentsResponse listPullRequestComments(ListPullRequestCommentsRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestCommentsResponse)this.clientCall(request, ListPullRequestCommentsResponse::builder).logger(LOG, "listPullRequestComments").serviceDetails("Devops", "ListPullRequestComments", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ListPullRequestComments").method(Method.GET).requestBuilder(ListPullRequestCommentsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendQueryParam("commentId", (Object)request.getCommentId()).appendQueryParam("commitId", (Object)request.getCommitId()).appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestCommentCollection.class, ListPullRequestCommentsResponse.Builder::pullRequestCommentCollection).handleResponseHeaderString("opc-request-id", ListPullRequestCommentsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestCommentsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestCommitsResponse listPullRequestCommits(ListPullRequestCommitsRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestCommitsResponse)this.clientCall(request, ListPullRequestCommitsResponse::builder).logger(LOG, "listPullRequestCommits").serviceDetails("Devops", "ListPullRequestCommits", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ListPullRequestCommits").method(Method.GET).requestBuilder(ListPullRequestCommitsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("commits").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryCommitCollection.class, ListPullRequestCommitsResponse.Builder::repositoryCommitCollection).handleResponseHeaderString("opc-request-id", ListPullRequestCommitsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestCommitsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestFileChangesResponse listPullRequestFileChanges(ListPullRequestFileChangesRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ListPullRequestFileChangesResponse)this.clientCall(request, ListPullRequestFileChangesResponse::builder).logger(LOG, "listPullRequestFileChanges").serviceDetails("Devops", "ListPullRequestFileChanges", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ListPullRequestFileChanges").method(Method.GET).requestBuilder(ListPullRequestFileChangesRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("fileChanges").appendQueryParam("filePath", (Object)request.getFilePath()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestFileChangeCollection.class, ListPullRequestFileChangesResponse.Builder::pullRequestFileChangeCollection).handleResponseHeaderString("opc-request-id", ListPullRequestFileChangesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestFileChangesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListPullRequestsResponse listPullRequests(ListPullRequestsRequest request) {
        return (ListPullRequestsResponse)this.clientCall(request, ListPullRequestsResponse::builder).logger(LOG, "listPullRequests").serviceDetails("Devops", "ListPullRequests", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequestCollection/ListPullRequests").method(Method.GET).requestBuilder(ListPullRequestsRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendEnumQueryParam("lifecycleDetails", (BmcEnum)request.getLifecycleDetails()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("createdBy", (Object)request.getCreatedBy()).appendQueryParam("destinationBranch", (Object)request.getDestinationBranch()).appendQueryParam("sourceBranch", (Object)request.getSourceBranch()).appendQueryParam("reviewerPrincipalId", (Object)request.getReviewerPrincipalId()).appendQueryParam("sourceRepositoryId", (Object)request.getSourceRepositoryId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestCollection.class, ListPullRequestsResponse.Builder::pullRequestCollection).handleResponseHeaderString("opc-request-id", ListPullRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListPullRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRefsResponse listRefs(ListRefsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListRefsResponse)this.clientCall(request, ListRefsResponse::builder).logger(LOG, "listRefs").serviceDetails("Devops", "ListRefs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryRef/ListRefs").method(Method.GET).requestBuilder(ListRefsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendEnumQueryParam("refType", (BmcEnum)request.getRefType()).appendQueryParam("commitId", (Object)request.getCommitId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("refName", (Object)request.getRefName()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryRefCollection.class, ListRefsResponse.Builder::repositoryRefCollection).handleResponseHeaderString("opc-request-id", ListRefsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRefsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRepositoriesResponse listRepositories(ListRepositoriesRequest request) {
        return (ListRepositoriesResponse)this.clientCall(request, ListRepositoriesResponse::builder).logger(LOG, "listRepositories").serviceDetails("Devops", "ListRepositories", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListRepositories").method(Method.GET).requestBuilder(ListRepositoriesRequest::builder).basePath("/20210630").appendPathParam("repositories").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendQueryParam("repositoryId", (Object)request.getRepositoryId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(RepositoryCollection.class, ListRepositoriesResponse.Builder::repositoryCollection).handleResponseHeaderString("opc-request-id", ListRepositoriesResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRepositoriesResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListRepositoryCommitAnalyticsAuthorsResponse listRepositoryCommitAnalyticsAuthors(ListRepositoryCommitAnalyticsAuthorsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (ListRepositoryCommitAnalyticsAuthorsResponse)this.clientCall(request, ListRepositoryCommitAnalyticsAuthorsResponse::builder).logger(LOG, "listRepositoryCommitAnalyticsAuthors").serviceDetails("Devops", "ListRepositoryCommitAnalyticsAuthors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/ListRepositoryCommitAnalyticsAuthors").method(Method.GET).requestBuilder(ListRepositoryCommitAnalyticsAuthorsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("commitAnalyticsAuthors").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(CommitAnalyticsAuthorCollection.class, ListRepositoryCommitAnalyticsAuthorsResponse.Builder::commitAnalyticsAuthorCollection).handleResponseHeaderString("opc-request-id", ListRepositoryCommitAnalyticsAuthorsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRepositoryCommitAnalyticsAuthorsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListTriggersResponse listTriggers(ListTriggersRequest request) {
        return (ListTriggersResponse)this.clientCall(request, ListTriggersResponse::builder).logger(LOG, "listTriggers").serviceDetails("Devops", "ListTriggers", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/TriggerCollection/ListTriggers").method(Method.GET).requestBuilder(ListTriggersRequest::builder).basePath("/20210630").appendPathParam("triggers").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("projectId", (Object)request.getProjectId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(TriggerCollection.class, ListTriggersResponse.Builder::triggerCollection).handleResponseHeaderString("opc-request-id", ListTriggersResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListTriggersResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestErrorsResponse)this.clientCall(request, ListWorkRequestErrorsResponse::builder).logger(LOG, "listWorkRequestErrors").serviceDetails("Devops", "ListWorkRequestErrors", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestError/ListWorkRequestErrors").method(Method.GET).requestBuilder(ListWorkRequestErrorsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("errors").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestErrorCollection.class, ListWorkRequestErrorsResponse.Builder::workRequestErrorCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestErrorsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestErrorsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        Validate.notBlank((String)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        return (ListWorkRequestLogsResponse)this.clientCall(request, ListWorkRequestLogsResponse::builder).logger(LOG, "listWorkRequestLogs").serviceDetails("Devops", "ListWorkRequestLogs", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequestLogEntry/ListWorkRequestLogs").method(Method.GET).requestBuilder(ListWorkRequestLogsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendPathParam(request.getWorkRequestId()).appendPathParam("logs").appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestLogEntryCollection.class, ListWorkRequestLogsResponse.Builder::workRequestLogEntryCollection).handleResponseHeaderString("opc-next-page", ListWorkRequestLogsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListWorkRequestLogsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return (ListWorkRequestsResponse)this.clientCall(request, ListWorkRequestsResponse::builder).logger(LOG, "listWorkRequests").serviceDetails("Devops", "ListWorkRequests", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/WorkRequest/ListWorkRequests").method(Method.GET).requestBuilder(ListWorkRequestsRequest::builder).basePath("/20210630").appendPathParam("workRequests").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("workRequestId", (Object)request.getWorkRequestId()).appendEnumQueryParam("status", (BmcEnum)request.getStatus()).appendQueryParam("resourceId", (Object)request.getResourceId()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("limit", (Object)request.getLimit()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendListQueryParam("operationTypeMultiValueQuery", request.getOperationTypeMultiValueQuery(), CollectionFormatType.Multi).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(WorkRequestCollection.class, ListWorkRequestsResponse.Builder::workRequestCollection).handleResponseHeaderString("opc-request-id", ListWorkRequestsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListWorkRequestsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public MergePullRequestResponse mergePullRequest(MergePullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getMergePullRequestDetails(), "mergePullRequestDetails is required");
        return (MergePullRequestResponse)this.clientCall(request, MergePullRequestResponse::builder).logger(LOG, "mergePullRequest").serviceDetails("Devops", "MergePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/MergePullRequest").method(Method.POST).requestBuilder(MergePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("actions").appendPathParam("merge").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleBody(PullRequest.class, MergePullRequestResponse.Builder::pullRequest).handleResponseHeaderString("content-location", MergePullRequestResponse.Builder::contentLocation).handleResponseHeaderString("etag", MergePullRequestResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", MergePullRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", MergePullRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public MirrorRepositoryResponse mirrorRepository(MirrorRepositoryRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        return (MirrorRepositoryResponse)this.clientCall(request, MirrorRepositoryResponse::builder).logger(LOG, "mirrorRepository").serviceDetails("Devops", "MirrorRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/MirrorRepository").method(Method.POST).requestBuilder(MirrorRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("mirror").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", MirrorRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", MirrorRepositoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public PatchPullRequestResponse patchPullRequest(PatchPullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPatchPullRequestDetails(), "patchPullRequestDetails is required");
        return (PatchPullRequestResponse)this.clientCall(request, PatchPullRequestResponse::builder).logger(LOG, "patchPullRequest").serviceDetails("Devops", "PatchPullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/PatchPullRequest").method(Method.PATCH).requestBuilder(PatchPullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequest.class, PatchPullRequestResponse.Builder::pullRequest).handleResponseHeaderString("location", PatchPullRequestResponse.Builder::location).handleResponseHeaderString("opc-request-id", PatchPullRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", PatchPullRequestResponse.Builder::etag).callSync();
    }

    @Override
    public PutRepositoryRefResponse putRepositoryRef(PutRepositoryRefRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getRefName(), (String)"refName must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getPutRepositoryRefDetails(), "putRepositoryRefDetails is required");
        return (PutRepositoryRefResponse)this.clientCall(request, PutRepositoryRefResponse::builder).logger(LOG, "putRepositoryRef").serviceDetails("Devops", "PutRepositoryRef", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/PutRepositoryRef").method(Method.PUT).requestBuilder(PutRepositoryRefRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("refs").appendPathParam(request.getRefName()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositoryRef.class, PutRepositoryRefResponse.Builder::repositoryRef).handleResponseHeaderString("location", PutRepositoryRefResponse.Builder::location).handleResponseHeaderString("etag", PutRepositoryRefResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", PutRepositoryRefResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", PutRepositoryRefResponse.Builder::opcRequestId).handleResponseHeaderString("Sunset", PutRepositoryRefResponse.Builder::sunset).callSync();
    }

    @Override
    public ReopenPullRequestResponse reopenPullRequest(ReopenPullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        return (ReopenPullRequestResponse)this.clientCall(request, ReopenPullRequestResponse::builder).logger(LOG, "reopenPullRequest").serviceDetails("Devops", "ReopenPullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ReopenPullRequest").method(Method.POST).requestBuilder(ReopenPullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("actions").appendPathParam("reopen").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequest.class, ReopenPullRequestResponse.Builder::pullRequest).handleResponseHeaderString("location", ReopenPullRequestResponse.Builder::location).handleResponseHeaderString("opc-request-id", ReopenPullRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ReopenPullRequestResponse.Builder::etag).callSync();
    }

    @Override
    public ReviewPullRequestResponse reviewPullRequest(ReviewPullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getReviewPullRequestDetails(), "reviewPullRequestDetails is required");
        return (ReviewPullRequestResponse)this.clientCall(request, ReviewPullRequestResponse::builder).logger(LOG, "reviewPullRequest").serviceDetails("Devops", "ReviewPullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/ReviewPullRequest").method(Method.POST).requestBuilder(ReviewPullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("actions").appendPathParam("review").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequest.class, ReviewPullRequestResponse.Builder::pullRequest).handleResponseHeaderString("location", ReviewPullRequestResponse.Builder::location).handleResponseHeaderString("opc-request-id", ReviewPullRequestResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ReviewPullRequestResponse.Builder::etag).callSync();
    }

    @Override
    public ScheduleCascadingProjectDeletionResponse scheduleCascadingProjectDeletion(ScheduleCascadingProjectDeletionRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        return (ScheduleCascadingProjectDeletionResponse)this.clientCall(request, ScheduleCascadingProjectDeletionResponse::builder).logger(LOG, "scheduleCascadingProjectDeletion").serviceDetails("Devops", "ScheduleCascadingProjectDeletion", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/ScheduleCascadingProjectDeletion").method(Method.POST).requestBuilder(ScheduleCascadingProjectDeletionRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("actions").appendPathParam("scheduleCascadingProjectDeletion").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleResponseHeaderString("opc-work-request-id", ScheduleCascadingProjectDeletionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", ScheduleCascadingProjectDeletionResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public SummarizeProjectRepositoryAnalyticsResponse summarizeProjectRepositoryAnalytics(SummarizeProjectRepositoryAnalyticsRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSummarizeProjectRepositoryAnalyticsDetails(), "summarizeProjectRepositoryAnalyticsDetails is required");
        return (SummarizeProjectRepositoryAnalyticsResponse)this.clientCall(request, SummarizeProjectRepositoryAnalyticsResponse::builder).logger(LOG, "summarizeProjectRepositoryAnalytics").serviceDetails("Devops", "SummarizeProjectRepositoryAnalytics", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryMetricAggregation/SummarizeProjectRepositoryAnalytics").method(Method.POST).requestBuilder(SummarizeProjectRepositoryAnalyticsRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("repositoryAnalytics").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositoryMetricAggregation.class, SummarizeProjectRepositoryAnalyticsResponse.Builder::repositoryMetricAggregation).handleResponseHeaderString("opc-request-id", SummarizeProjectRepositoryAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeProjectRepositoryAnalyticsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SummarizeRepositoryAnalyticsResponse summarizeRepositoryAnalytics(SummarizeRepositoryAnalyticsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSummarizeRepositoryAnalyticsDetails(), "summarizeRepositoryAnalyticsDetails is required");
        return (SummarizeRepositoryAnalyticsResponse)this.clientCall(request, SummarizeRepositoryAnalyticsResponse::builder).logger(LOG, "summarizeRepositoryAnalytics").serviceDetails("Devops", "SummarizeRepositoryAnalytics", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryMetricAggregation/SummarizeRepositoryAnalytics").method(Method.POST).requestBuilder(SummarizeRepositoryAnalyticsRequest::builder).basePath("/20210630").appendPathParam("repository").appendPathParam(request.getRepositoryId()).appendPathParam("repositoryAnalytics").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositoryMetricAggregation.class, SummarizeRepositoryAnalyticsResponse.Builder::repositoryMetricAggregation).handleResponseHeaderString("opc-request-id", SummarizeRepositoryAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeRepositoryAnalyticsResponse.Builder::opcNextPage).callSync();
    }

    @Override
    public SyncRepositoryResponse syncRepository(SyncRepositoryRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getSyncMergeStrategy(), "syncMergeStrategy is required");
        Objects.requireNonNull(request.getSyncRepositoryDetails(), "syncRepositoryDetails is required");
        return (SyncRepositoryResponse)this.clientCall(request, SyncRepositoryResponse::builder).logger(LOG, "syncRepository").serviceDetails("Devops", "SyncRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/SyncRepository").method(Method.POST).requestBuilder(SyncRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("actions").appendPathParam("sync").appendEnumQueryParam("syncMergeStrategy", (BmcEnum)request.getSyncMergeStrategy()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().hasBody().handleResponseHeaderString("opc-work-request-id", SyncRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", SyncRepositoryResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UnlikePullRequestCommentResponse unlikePullRequestComment(UnlikePullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommentId(), (String)"commentId must not be blank", (Object[])new Object[0]);
        return (UnlikePullRequestCommentResponse)this.clientCall(request, UnlikePullRequestCommentResponse::builder).logger(LOG, "unlikePullRequestComment").serviceDetails("Devops", "UnlikePullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/UnlikePullRequestComment").method(Method.POST).requestBuilder(UnlikePullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendPathParam(request.getCommentId()).appendPathParam("actions").appendPathParam("unlike").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(PullRequestComment.class, UnlikePullRequestCommentResponse.Builder::pullRequestComment).handleResponseHeaderString("opc-request-id", UnlikePullRequestCommentResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UnlikePullRequestCommentResponse.Builder::etag).callSync();
    }

    @Override
    public UnsubscribePullRequestResponse unsubscribePullRequest(UnsubscribePullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getToken(), "token is required");
        return (UnsubscribePullRequestResponse)this.clientCall(request, UnsubscribePullRequestResponse::builder).logger(LOG, "unsubscribePullRequest").serviceDetails("Devops", "UnsubscribePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/UnsubscribePullRequest").method(Method.GET).requestBuilder(UnsubscribePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("actions").appendPathParam("unsubscribe").appendQueryParam("token", (Object)request.getToken()).accept(new String[]{"text/html"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().handleBody(InputStream.class, UnsubscribePullRequestResponse.Builder::inputStream).handleResponseHeaderString("content-location", UnsubscribePullRequestResponse.Builder::contentLocation).handleResponseHeaderString("etag", UnsubscribePullRequestResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UnsubscribePullRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateBuildPipelineResponse updateBuildPipeline(UpdateBuildPipelineRequest request) {
        Validate.notBlank((String)request.getBuildPipelineId(), (String)"buildPipelineId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildPipelineDetails(), "updateBuildPipelineDetails is required");
        return (UpdateBuildPipelineResponse)this.clientCall(request, UpdateBuildPipelineResponse::builder).logger(LOG, "updateBuildPipeline").serviceDetails("Devops", "UpdateBuildPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipeline/UpdateBuildPipeline").method(Method.PUT).requestBuilder(UpdateBuildPipelineRequest::builder).basePath("/20210630").appendPathParam("buildPipelines").appendPathParam(request.getBuildPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(BuildPipeline.class, UpdateBuildPipelineResponse.Builder::buildPipeline).handleResponseHeaderString("etag", UpdateBuildPipelineResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBuildPipelineResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateBuildPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", UpdateBuildPipelineResponse.Builder::location).callSync();
    }

    @Override
    public UpdateBuildPipelineStageResponse updateBuildPipelineStage(UpdateBuildPipelineStageRequest request) {
        Validate.notBlank((String)request.getBuildPipelineStageId(), (String)"buildPipelineStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildPipelineStageDetails(), "updateBuildPipelineStageDetails is required");
        return (UpdateBuildPipelineStageResponse)this.clientCall(request, UpdateBuildPipelineStageResponse::builder).logger(LOG, "updateBuildPipelineStage").serviceDetails("Devops", "UpdateBuildPipelineStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildPipelineStage/UpdateBuildPipelineStage").method(Method.PUT).requestBuilder(UpdateBuildPipelineStageRequest::builder).basePath("/20210630").appendPathParam("buildPipelineStages").appendPathParam(request.getBuildPipelineStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(BuildPipelineStage.class, UpdateBuildPipelineStageResponse.Builder::buildPipelineStage).handleResponseHeaderString("etag", UpdateBuildPipelineStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateBuildPipelineStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateBuildPipelineStageResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateBuildPipelineStageResponse.Builder::location).callSync();
    }

    @Override
    public UpdateBuildRunResponse updateBuildRun(UpdateBuildRunRequest request) {
        Validate.notBlank((String)request.getBuildRunId(), (String)"buildRunId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateBuildRunDetails(), "updateBuildRunDetails is required");
        return (UpdateBuildRunResponse)this.clientCall(request, UpdateBuildRunResponse::builder).logger(LOG, "updateBuildRun").serviceDetails("Devops", "UpdateBuildRun", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/BuildRun/UpdateBuildRun").method(Method.PUT).requestBuilder(UpdateBuildRunRequest::builder).basePath("/20210630").appendPathParam("buildRuns").appendPathParam(request.getBuildRunId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(BuildRun.class, UpdateBuildRunResponse.Builder::buildRun).handleResponseHeaderString("etag", UpdateBuildRunResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateBuildRunResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateBuildRunResponse.Builder::location).callSync();
    }

    @Override
    public UpdateConnectionResponse updateConnection(UpdateConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConnectionDetails(), "updateConnectionDetails is required");
        return (UpdateConnectionResponse)this.clientCall(request, UpdateConnectionResponse::builder).logger(LOG, "updateConnection").serviceDetails("Devops", "UpdateConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/UpdateConnection").method(Method.PUT).requestBuilder(UpdateConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Connection.class, UpdateConnectionResponse.Builder::connection).handleResponseHeaderString("etag", UpdateConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateConnectionResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", UpdateConnectionResponse.Builder::location).callSync();
    }

    @Override
    public UpdateDeployArtifactResponse updateDeployArtifact(UpdateDeployArtifactRequest request) {
        Validate.notBlank((String)request.getDeployArtifactId(), (String)"deployArtifactId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployArtifactDetails(), "updateDeployArtifactDetails is required");
        return (UpdateDeployArtifactResponse)this.clientCall(request, UpdateDeployArtifactResponse::builder).logger(LOG, "updateDeployArtifact").serviceDetails("Devops", "UpdateDeployArtifact", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployArtifact/UpdateDeployArtifact").method(Method.PUT).requestBuilder(UpdateDeployArtifactRequest::builder).basePath("/20210630").appendPathParam("deployArtifacts").appendPathParam(request.getDeployArtifactId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployArtifact.class, UpdateDeployArtifactResponse.Builder::deployArtifact).handleResponseHeaderString("location", UpdateDeployArtifactResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployArtifactResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployArtifactResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployArtifactResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDeployEnvironmentResponse updateDeployEnvironment(UpdateDeployEnvironmentRequest request) {
        Validate.notBlank((String)request.getDeployEnvironmentId(), (String)"deployEnvironmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployEnvironmentDetails(), "updateDeployEnvironmentDetails is required");
        return (UpdateDeployEnvironmentResponse)this.clientCall(request, UpdateDeployEnvironmentResponse::builder).logger(LOG, "updateDeployEnvironment").serviceDetails("Devops", "UpdateDeployEnvironment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployEnvironment/UpdateDeployEnvironment").method(Method.PUT).requestBuilder(UpdateDeployEnvironmentRequest::builder).basePath("/20210630").appendPathParam("deployEnvironments").appendPathParam(request.getDeployEnvironmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployEnvironment.class, UpdateDeployEnvironmentResponse.Builder::deployEnvironment).handleResponseHeaderString("location", UpdateDeployEnvironmentResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployEnvironmentResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployEnvironmentResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployEnvironmentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDeployPipelineResponse updateDeployPipeline(UpdateDeployPipelineRequest request) {
        Validate.notBlank((String)request.getDeployPipelineId(), (String)"deployPipelineId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployPipelineDetails(), "updateDeployPipelineDetails is required");
        return (UpdateDeployPipelineResponse)this.clientCall(request, UpdateDeployPipelineResponse::builder).logger(LOG, "updateDeployPipeline").serviceDetails("Devops", "UpdateDeployPipeline", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployPipeline/UpdateDeployPipeline").method(Method.PUT).requestBuilder(UpdateDeployPipelineRequest::builder).basePath("/20210630").appendPathParam("deployPipelines").appendPathParam(request.getDeployPipelineId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployPipeline.class, UpdateDeployPipelineResponse.Builder::deployPipeline).handleResponseHeaderString("location", UpdateDeployPipelineResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployPipelineResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployPipelineResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployPipelineResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDeployStageResponse updateDeployStage(UpdateDeployStageRequest request) {
        Validate.notBlank((String)request.getDeployStageId(), (String)"deployStageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeployStageDetails(), "updateDeployStageDetails is required");
        return (UpdateDeployStageResponse)this.clientCall(request, UpdateDeployStageResponse::builder).logger(LOG, "updateDeployStage").serviceDetails("Devops", "UpdateDeployStage", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/DeployStage/UpdateDeployStage").method(Method.PUT).requestBuilder(UpdateDeployStageRequest::builder).basePath("/20210630").appendPathParam("deployStages").appendPathParam(request.getDeployStageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(DeployStage.class, UpdateDeployStageResponse.Builder::deployStage).handleResponseHeaderString("location", UpdateDeployStageResponse.Builder::location).handleResponseHeaderString("etag", UpdateDeployStageResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateDeployStageResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateDeployStageResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateDeploymentResponse updateDeployment(UpdateDeploymentRequest request) {
        Validate.notBlank((String)request.getDeploymentId(), (String)"deploymentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDeploymentDetails(), "updateDeploymentDetails is required");
        return (UpdateDeploymentResponse)this.clientCall(request, UpdateDeploymentResponse::builder).logger(LOG, "updateDeployment").serviceDetails("Devops", "UpdateDeployment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Deployment/UpdateDeployment").method(Method.PUT).requestBuilder(UpdateDeploymentRequest::builder).basePath("/20210630").appendPathParam("deployments").appendPathParam(request.getDeploymentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Deployment.class, UpdateDeploymentResponse.Builder::deployment).handleResponseHeaderString("etag", UpdateDeploymentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDeploymentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProjectResponse updateProject(UpdateProjectRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectDetails(), "updateProjectDetails is required");
        return (UpdateProjectResponse)this.clientCall(request, UpdateProjectResponse::builder).logger(LOG, "updateProject").serviceDetails("Devops", "UpdateProject", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Project/UpdateProject").method(Method.PUT).requestBuilder(UpdateProjectRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Project.class, UpdateProjectResponse.Builder::project).handleResponseHeaderString("location", UpdateProjectResponse.Builder::location).handleResponseHeaderString("etag", UpdateProjectResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateProjectResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateProjectResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProjectNotificationPreferenceResponse updateProjectNotificationPreference(UpdateProjectNotificationPreferenceRequest request) {
        Objects.requireNonNull(request.getUpdateProjectNotificationPreferenceDetails(), "updateProjectNotificationPreferenceDetails is required");
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (UpdateProjectNotificationPreferenceResponse)this.clientCall(request, UpdateProjectNotificationPreferenceResponse::builder).logger(LOG, "updateProjectNotificationPreference").serviceDetails("Devops", "UpdateProjectNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectNotificationPreference/UpdateProjectNotificationPreference").method(Method.PUT).requestBuilder(UpdateProjectNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ProjectNotificationPreference.class, UpdateProjectNotificationPreferenceResponse.Builder::projectNotificationPreference).handleResponseHeaderString("location", UpdateProjectNotificationPreferenceResponse.Builder::location).handleResponseHeaderString("etag", UpdateProjectNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProjectNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateProjectRepositorySettingsResponse updateProjectRepositorySettings(UpdateProjectRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getProjectId(), (String)"projectId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateProjectRepositorySettingsDetails(), "updateProjectRepositorySettingsDetails is required");
        return (UpdateProjectRepositorySettingsResponse)this.clientCall(request, UpdateProjectRepositorySettingsResponse::builder).logger(LOG, "updateProjectRepositorySettings").serviceDetails("Devops", "UpdateProjectRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/ProjectRepositorySettings/UpdateProjectRepositorySettings").method(Method.PUT).requestBuilder(UpdateProjectRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("projects").appendPathParam(request.getProjectId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(ProjectRepositorySettings.class, UpdateProjectRepositorySettingsResponse.Builder::projectRepositorySettings).handleResponseHeaderString("location", UpdateProjectRepositorySettingsResponse.Builder::location).handleResponseHeaderString("etag", UpdateProjectRepositorySettingsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateProjectRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePullRequestResponse updatePullRequest(UpdatePullRequestRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePullRequestDetails(), "updatePullRequestDetails is required");
        return (UpdatePullRequestResponse)this.clientCall(request, UpdatePullRequestResponse::builder).logger(LOG, "updatePullRequest").serviceDetails("Devops", "UpdatePullRequest", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/UpdatePullRequest").method(Method.PUT).requestBuilder(UpdatePullRequestRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequest.class, UpdatePullRequestResponse.Builder::pullRequest).handleResponseHeaderString("content-location", UpdatePullRequestResponse.Builder::contentLocation).handleResponseHeaderString("etag", UpdatePullRequestResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdatePullRequestResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdatePullRequestResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePullRequestCommentResponse updatePullRequestComment(UpdatePullRequestCommentRequest request) {
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getCommentId(), (String)"commentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdatePullRequestCommentDetails(), "updatePullRequestCommentDetails is required");
        return (UpdatePullRequestCommentResponse)this.clientCall(request, UpdatePullRequestCommentResponse::builder).logger(LOG, "updatePullRequestComment").serviceDetails("Devops", "UpdatePullRequestComment", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequest/UpdatePullRequestComment").method(Method.PUT).requestBuilder(UpdatePullRequestCommentRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("comments").appendPathParam(request.getCommentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequestComment.class, UpdatePullRequestCommentResponse.Builder::pullRequestComment).handleResponseHeaderString("etag", UpdatePullRequestCommentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePullRequestCommentResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdatePullRequestNotificationPreferenceResponse updatePullRequestNotificationPreference(UpdatePullRequestNotificationPreferenceRequest request) {
        Objects.requireNonNull(request.getUpdatePullRequestNotificationPreferenceDetails(), "updatePullRequestNotificationPreferenceDetails is required");
        Validate.notBlank((String)request.getPullRequestId(), (String)"pullRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (UpdatePullRequestNotificationPreferenceResponse)this.clientCall(request, UpdatePullRequestNotificationPreferenceResponse::builder).logger(LOG, "updatePullRequestNotificationPreference").serviceDetails("Devops", "UpdatePullRequestNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/PullRequestNotificationPreference/UpdatePullRequestNotificationPreference").method(Method.PUT).requestBuilder(UpdatePullRequestNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("pullRequests").appendPathParam(request.getPullRequestId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(PullRequestNotificationPreference.class, UpdatePullRequestNotificationPreferenceResponse.Builder::pullRequestNotificationPreference).handleResponseHeaderString("location", UpdatePullRequestNotificationPreferenceResponse.Builder::location).handleResponseHeaderString("etag", UpdatePullRequestNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdatePullRequestNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRepositoryResponse updateRepository(UpdateRepositoryRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRepositoryDetails(), "updateRepositoryDetails is required");
        return (UpdateRepositoryResponse)this.clientCall(request, UpdateRepositoryResponse::builder).logger(LOG, "updateRepository").serviceDetails("Devops", "UpdateRepository", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Repository/UpdateRepository").method(Method.PUT).requestBuilder(UpdateRepositoryRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Repository.class, UpdateRepositoryResponse.Builder::repository).handleResponseHeaderString("opc-work-request-id", UpdateRepositoryResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateRepositoryResponse.Builder::opcRequestId).handleResponseHeaderString("etag", UpdateRepositoryResponse.Builder::etag).callSync();
    }

    @Override
    public UpdateRepositoryNotificationPreferenceResponse updateRepositoryNotificationPreference(UpdateRepositoryNotificationPreferenceRequest request) {
        Objects.requireNonNull(request.getUpdateRepositoryNotificationPreferenceDetails(), "updateRepositoryNotificationPreferenceDetails is required");
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getPrincipalId(), (String)"principalId must not be blank", (Object[])new Object[0]);
        return (UpdateRepositoryNotificationPreferenceResponse)this.clientCall(request, UpdateRepositoryNotificationPreferenceResponse::builder).logger(LOG, "updateRepositoryNotificationPreference").serviceDetails("Devops", "UpdateRepositoryNotificationPreference", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositoryNotificationPreference/UpdateRepositoryNotificationPreference").method(Method.PUT).requestBuilder(UpdateRepositoryNotificationPreferenceRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("principals").appendPathParam(request.getPrincipalId()).appendPathParam("pullRequestNotificationPreference").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositoryNotificationPreference.class, UpdateRepositoryNotificationPreferenceResponse.Builder::repositoryNotificationPreference).handleResponseHeaderString("location", UpdateRepositoryNotificationPreferenceResponse.Builder::location).handleResponseHeaderString("etag", UpdateRepositoryNotificationPreferenceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRepositoryNotificationPreferenceResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateRepositorySettingsResponse updateRepositorySettings(UpdateRepositorySettingsRequest request) {
        Validate.notBlank((String)request.getRepositoryId(), (String)"repositoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRepositorySettingsDetails(), "updateRepositorySettingsDetails is required");
        return (UpdateRepositorySettingsResponse)this.clientCall(request, UpdateRepositorySettingsResponse::builder).logger(LOG, "updateRepositorySettings").serviceDetails("Devops", "UpdateRepositorySettings", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/RepositorySettings/UpdateRepositorySettings").method(Method.PUT).requestBuilder(UpdateRepositorySettingsRequest::builder).basePath("/20210630").appendPathParam("repositories").appendPathParam(request.getRepositoryId()).appendPathParam("repositorySettings").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(RepositorySettings.class, UpdateRepositorySettingsResponse.Builder::repositorySettings).handleResponseHeaderString("location", UpdateRepositorySettingsResponse.Builder::location).handleResponseHeaderString("etag", UpdateRepositorySettingsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRepositorySettingsResponse.Builder::opcRequestId).callSync();
    }

    @Override
    public UpdateTriggerResponse updateTrigger(UpdateTriggerRequest request) {
        Validate.notBlank((String)request.getTriggerId(), (String)"triggerId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateTriggerDetails(), "updateTriggerDetails is required");
        return (UpdateTriggerResponse)this.clientCall(request, UpdateTriggerResponse::builder).logger(LOG, "updateTrigger").serviceDetails("Devops", "UpdateTrigger", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Trigger/UpdateTrigger").method(Method.PUT).requestBuilder(UpdateTriggerRequest::builder).basePath("/20210630").appendPathParam("triggers").appendPathParam(request.getTriggerId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).operationUsesDefaultRetries().hasBody().handleBody(Trigger.class, UpdateTriggerResponse.Builder::trigger).handleResponseHeaderString("etag", UpdateTriggerResponse.Builder::etag).handleResponseHeaderString("opc-work-request-id", UpdateTriggerResponse.Builder::opcWorkRequestId).handleResponseHeaderString("opc-request-id", UpdateTriggerResponse.Builder::opcRequestId).handleResponseHeaderString("location", UpdateTriggerResponse.Builder::location).callSync();
    }

    @Override
    public ValidateConnectionResponse validateConnection(ValidateConnectionRequest request) {
        Validate.notBlank((String)request.getConnectionId(), (String)"connectionId must not be blank", (Object[])new Object[0]);
        return (ValidateConnectionResponse)this.clientCall(request, ValidateConnectionResponse::builder).logger(LOG, "validateConnection").serviceDetails("Devops", "ValidateConnection", "https://docs.oracle.com/iaas/api/#/en/devops/20210630/Connection/ValidateConnection").method(Method.POST).requestBuilder(ValidateConnectionRequest::builder).basePath("/20210630").appendPathParam("connections").appendPathParam(request.getConnectionId()).appendPathParam("actions").appendPathParam("validate").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).operationUsesDefaultRetries().handleBody(Connection.class, ValidateConnectionResponse.Builder::connection).handleResponseHeaderString("opc-request-id", ValidateConnectionResponse.Builder::opcRequestId).handleResponseHeaderString("etag", ValidateConnectionResponse.Builder::etag).callSync();
    }

    @Override
    public DevopsWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DevopsPaginators getPaginators() {
        return this.paginators;
    }

    @Deprecated
    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DevopsClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DevopsClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, null);
    }

    @Deprecated
    public DevopsClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DevopsClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider, executorService);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DevopsClient> {
        private boolean isStreamWarningEnabled = true;
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            String packageName = "devops";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"devops");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DevopsClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DevopsClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.executorService, this.isStreamWarningEnabled);
        }
    }
}

