/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MergeCheck;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ApprovalRuleMergeCheck
extends MergeCheck {
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="totalApprovalCount")
    private final Integer totalApprovalCount;
    @JsonProperty(value="currentApprovalCount")
    private final Integer currentApprovalCount;
    @JsonProperty(value="reviewers")
    private final List<PrincipalDetails> reviewers;
    @JsonProperty(value="level")
    private final Level level;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ApprovalRuleMergeCheck(String ruleName, Status status, Integer totalApprovalCount, Integer currentApprovalCount, List<PrincipalDetails> reviewers, Level level) {
        this.ruleName = ruleName;
        this.status = status;
        this.totalApprovalCount = totalApprovalCount;
        this.currentApprovalCount = currentApprovalCount;
        this.reviewers = reviewers;
        this.level = level;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Status getStatus() {
        return this.status;
    }

    public Integer getTotalApprovalCount() {
        return this.totalApprovalCount;
    }

    public Integer getCurrentApprovalCount() {
        return this.currentApprovalCount;
    }

    public List<PrincipalDetails> getReviewers() {
        return this.reviewers;
    }

    public Level getLevel() {
        return this.level;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ApprovalRuleMergeCheck(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", ruleName=").append(String.valueOf(this.ruleName));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", totalApprovalCount=").append(String.valueOf(this.totalApprovalCount));
        sb.append(", currentApprovalCount=").append(String.valueOf(this.currentApprovalCount));
        sb.append(", reviewers=").append(String.valueOf(this.reviewers));
        sb.append(", level=").append(String.valueOf((Object)this.level));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApprovalRuleMergeCheck)) {
            return false;
        }
        ApprovalRuleMergeCheck other = (ApprovalRuleMergeCheck)((Object)o);
        return Objects.equals(this.ruleName, other.ruleName) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.totalApprovalCount, other.totalApprovalCount) && Objects.equals(this.currentApprovalCount, other.currentApprovalCount) && Objects.equals(this.reviewers, other.reviewers) && Objects.equals((Object)this.level, (Object)other.level) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.ruleName == null ? 43 : this.ruleName.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.totalApprovalCount == null ? 43 : this.totalApprovalCount.hashCode());
        result = result * 59 + (this.currentApprovalCount == null ? 43 : this.currentApprovalCount.hashCode());
        result = result * 59 + (this.reviewers == null ? 43 : this.reviewers.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        return result;
    }

    public static enum Level implements BmcEnum
    {
        Project("PROJECT"),
        Repository("REPOSITORY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Level> map;

        private Level(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Level create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Level', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Level.class);
            map = new HashMap<String, Level>();
            for (Level v : Level.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        NeedsApproval("NEEDS_APPROVAL"),
        Succeeded("SUCCEEDED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="ruleName")
        private String ruleName;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="totalApprovalCount")
        private Integer totalApprovalCount;
        @JsonProperty(value="currentApprovalCount")
        private Integer currentApprovalCount;
        @JsonProperty(value="reviewers")
        private List<PrincipalDetails> reviewers;
        @JsonProperty(value="level")
        private Level level;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.__explicitlySet__.add("ruleName");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder totalApprovalCount(Integer totalApprovalCount) {
            this.totalApprovalCount = totalApprovalCount;
            this.__explicitlySet__.add("totalApprovalCount");
            return this;
        }

        public Builder currentApprovalCount(Integer currentApprovalCount) {
            this.currentApprovalCount = currentApprovalCount;
            this.__explicitlySet__.add("currentApprovalCount");
            return this;
        }

        public Builder reviewers(List<PrincipalDetails> reviewers) {
            this.reviewers = reviewers;
            this.__explicitlySet__.add("reviewers");
            return this;
        }

        public Builder level(Level level) {
            this.level = level;
            this.__explicitlySet__.add("level");
            return this;
        }

        public ApprovalRuleMergeCheck build() {
            ApprovalRuleMergeCheck model = new ApprovalRuleMergeCheck(this.ruleName, this.status, this.totalApprovalCount, this.currentApprovalCount, this.reviewers, this.level);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ApprovalRuleMergeCheck model) {
            if (model.wasPropertyExplicitlySet("ruleName")) {
                this.ruleName(model.getRuleName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("totalApprovalCount")) {
                this.totalApprovalCount(model.getTotalApprovalCount());
            }
            if (model.wasPropertyExplicitlySet("currentApprovalCount")) {
                this.currentApprovalCount(model.getCurrentApprovalCount());
            }
            if (model.wasPropertyExplicitlySet("reviewers")) {
                this.reviewers(model.getReviewers());
            }
            if (model.wasPropertyExplicitlySet("level")) {
                this.level(model.getLevel());
            }
            return this;
        }
    }
}

