/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MergeCheck;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class BuildMergeCheck
extends MergeCheck {
    @JsonProperty(value="pipelineId")
    private final String pipelineId;
    @JsonProperty(value="buildRunId")
    private final String buildRunId;
    @JsonProperty(value="buildStatus")
    private final String buildStatus;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public BuildMergeCheck(String pipelineId, String buildRunId, String buildStatus) {
        this.pipelineId = pipelineId;
        this.buildRunId = buildRunId;
        this.buildStatus = buildStatus;
    }

    public String getPipelineId() {
        return this.pipelineId;
    }

    public String getBuildRunId() {
        return this.buildRunId;
    }

    public String getBuildStatus() {
        return this.buildStatus;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BuildMergeCheck(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", pipelineId=").append(String.valueOf(this.pipelineId));
        sb.append(", buildRunId=").append(String.valueOf(this.buildRunId));
        sb.append(", buildStatus=").append(String.valueOf(this.buildStatus));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildMergeCheck)) {
            return false;
        }
        BuildMergeCheck other = (BuildMergeCheck)((Object)o);
        return Objects.equals(this.pipelineId, other.pipelineId) && Objects.equals(this.buildRunId, other.buildRunId) && Objects.equals(this.buildStatus, other.buildStatus) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pipelineId == null ? 43 : this.pipelineId.hashCode());
        result = result * 59 + (this.buildRunId == null ? 43 : this.buildRunId.hashCode());
        result = result * 59 + (this.buildStatus == null ? 43 : this.buildStatus.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="pipelineId")
        private String pipelineId;
        @JsonProperty(value="buildRunId")
        private String buildRunId;
        @JsonProperty(value="buildStatus")
        private String buildStatus;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder pipelineId(String pipelineId) {
            this.pipelineId = pipelineId;
            this.__explicitlySet__.add("pipelineId");
            return this;
        }

        public Builder buildRunId(String buildRunId) {
            this.buildRunId = buildRunId;
            this.__explicitlySet__.add("buildRunId");
            return this;
        }

        public Builder buildStatus(String buildStatus) {
            this.buildStatus = buildStatus;
            this.__explicitlySet__.add("buildStatus");
            return this;
        }

        public BuildMergeCheck build() {
            BuildMergeCheck model = new BuildMergeCheck(this.pipelineId, this.buildRunId, this.buildStatus);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BuildMergeCheck model) {
            if (model.wasPropertyExplicitlySet("pipelineId")) {
                this.pipelineId(model.getPipelineId());
            }
            if (model.wasPropertyExplicitlySet("buildRunId")) {
                this.buildRunId(model.getBuildRunId());
            }
            if (model.wasPropertyExplicitlySet("buildStatus")) {
                this.buildStatus(model.getBuildStatus());
            }
            return this;
        }
    }
}

