/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.BuildRunSnapshot;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BuildRunSnapshotSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="buildPipelineId")
    private final String buildPipelineId;
    @JsonProperty(value="commitId")
    private final String commitId;
    @JsonProperty(value="buildRunId")
    private final String buildRunId;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="lifecycleState")
    private final BuildRunSnapshot.LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;

    @Deprecated
    @ConstructorProperties(value={"buildPipelineId", "commitId", "buildRunId", "displayName", "lifecycleState", "lifecycleDetails", "timeCreated", "timeUpdated"})
    public BuildRunSnapshotSummary(String buildPipelineId, String commitId, String buildRunId, String displayName, BuildRunSnapshot.LifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated) {
        this.buildPipelineId = buildPipelineId;
        this.commitId = commitId;
        this.buildRunId = buildRunId;
        this.displayName = displayName;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBuildPipelineId() {
        return this.buildPipelineId;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public String getBuildRunId() {
        return this.buildRunId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public BuildRunSnapshot.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BuildRunSnapshotSummary(");
        sb.append("super=").append(super.toString());
        sb.append("buildPipelineId=").append(String.valueOf(this.buildPipelineId));
        sb.append(", commitId=").append(String.valueOf(this.commitId));
        sb.append(", buildRunId=").append(String.valueOf(this.buildRunId));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BuildRunSnapshotSummary)) {
            return false;
        }
        BuildRunSnapshotSummary other = (BuildRunSnapshotSummary)((Object)o);
        return Objects.equals(this.buildPipelineId, other.buildPipelineId) && Objects.equals(this.commitId, other.commitId) && Objects.equals(this.buildRunId, other.buildRunId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.buildPipelineId == null ? 43 : this.buildPipelineId.hashCode());
        result = result * 59 + (this.commitId == null ? 43 : this.commitId.hashCode());
        result = result * 59 + (this.buildRunId == null ? 43 : this.buildRunId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="buildPipelineId")
        private String buildPipelineId;
        @JsonProperty(value="commitId")
        private String commitId;
        @JsonProperty(value="buildRunId")
        private String buildRunId;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="lifecycleState")
        private BuildRunSnapshot.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder buildPipelineId(String buildPipelineId) {
            this.buildPipelineId = buildPipelineId;
            this.__explicitlySet__.add("buildPipelineId");
            return this;
        }

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            this.__explicitlySet__.add("commitId");
            return this;
        }

        public Builder buildRunId(String buildRunId) {
            this.buildRunId = buildRunId;
            this.__explicitlySet__.add("buildRunId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder lifecycleState(BuildRunSnapshot.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public BuildRunSnapshotSummary build() {
            BuildRunSnapshotSummary model = new BuildRunSnapshotSummary(this.buildPipelineId, this.commitId, this.buildRunId, this.displayName, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BuildRunSnapshotSummary model) {
            if (model.wasPropertyExplicitlySet("buildPipelineId")) {
                this.buildPipelineId(model.getBuildPipelineId());
            }
            if (model.wasPropertyExplicitlySet("commitId")) {
                this.commitId(model.getCommitId());
            }
            if (model.wasPropertyExplicitlySet("buildRunId")) {
                this.buildRunId(model.getBuildRunId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            return this;
        }
    }
}

