/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.PullRequestActivitySummary;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="activityType")
@JsonFilter(value="explicitlySetFilter")
public final class CommentActivitySummary
extends PullRequestActivitySummary {
    @JsonProperty(value="commentId")
    private final String commentId;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CommentActivitySummary(String id, PrincipalDetails principal, String pullRequestId, Date timeOccurred, String commentId) {
        super(id, principal, pullRequestId, timeOccurred);
        this.commentId = commentId;
    }

    public String getCommentId() {
        return this.commentId;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CommentActivitySummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", commentId=").append(String.valueOf(this.commentId));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommentActivitySummary)) {
            return false;
        }
        CommentActivitySummary other = (CommentActivitySummary)((Object)o);
        return Objects.equals(this.commentId, other.commentId) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.commentId == null ? 43 : this.commentId.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="principal")
        private PrincipalDetails principal;
        @JsonProperty(value="pullRequestId")
        private String pullRequestId;
        @JsonProperty(value="timeOccurred")
        private Date timeOccurred;
        @JsonProperty(value="commentId")
        private String commentId;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder principal(PrincipalDetails principal) {
            this.principal = principal;
            this.__explicitlySet__.add("principal");
            return this;
        }

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            this.__explicitlySet__.add("pullRequestId");
            return this;
        }

        public Builder timeOccurred(Date timeOccurred) {
            this.timeOccurred = timeOccurred;
            this.__explicitlySet__.add("timeOccurred");
            return this;
        }

        public Builder commentId(String commentId) {
            this.commentId = commentId;
            this.__explicitlySet__.add("commentId");
            return this;
        }

        public CommentActivitySummary build() {
            CommentActivitySummary model = new CommentActivitySummary(this.id, this.principal, this.pullRequestId, this.timeOccurred, this.commentId);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CommentActivitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("principal")) {
                this.principal(model.getPrincipal());
            }
            if (model.wasPropertyExplicitlySet("pullRequestId")) {
                this.pullRequestId(model.getPullRequestId());
            }
            if (model.wasPropertyExplicitlySet("timeOccurred")) {
                this.timeOccurred(model.getTimeOccurred());
            }
            if (model.wasPropertyExplicitlySet("commentId")) {
                this.commentId(model.getCommentId());
            }
            return this;
        }
    }
}

