/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.PullRequestActivitySummary;
import com.oracle.bmc.devops.model.RepositoryCommit;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="activityType")
@JsonFilter(value="explicitlySetFilter")
public final class CommitActivitySummary
extends PullRequestActivitySummary {
    @JsonProperty(value="commitsAdded")
    private final List<RepositoryCommit> commitsAdded;
    @JsonProperty(value="commitsRemoved")
    private final List<RepositoryCommit> commitsRemoved;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public CommitActivitySummary(String id, PrincipalDetails principal, String pullRequestId, Date timeOccurred, List<RepositoryCommit> commitsAdded, List<RepositoryCommit> commitsRemoved) {
        super(id, principal, pullRequestId, timeOccurred);
        this.commitsAdded = commitsAdded;
        this.commitsRemoved = commitsRemoved;
    }

    public List<RepositoryCommit> getCommitsAdded() {
        return this.commitsAdded;
    }

    public List<RepositoryCommit> getCommitsRemoved() {
        return this.commitsRemoved;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CommitActivitySummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", commitsAdded=").append(String.valueOf(this.commitsAdded));
        sb.append(", commitsRemoved=").append(String.valueOf(this.commitsRemoved));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CommitActivitySummary)) {
            return false;
        }
        CommitActivitySummary other = (CommitActivitySummary)((Object)o);
        return Objects.equals(this.commitsAdded, other.commitsAdded) && Objects.equals(this.commitsRemoved, other.commitsRemoved) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.commitsAdded == null ? 43 : this.commitsAdded.hashCode());
        result = result * 59 + (this.commitsRemoved == null ? 43 : this.commitsRemoved.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="principal")
        private PrincipalDetails principal;
        @JsonProperty(value="pullRequestId")
        private String pullRequestId;
        @JsonProperty(value="timeOccurred")
        private Date timeOccurred;
        @JsonProperty(value="commitsAdded")
        private List<RepositoryCommit> commitsAdded;
        @JsonProperty(value="commitsRemoved")
        private List<RepositoryCommit> commitsRemoved;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder principal(PrincipalDetails principal) {
            this.principal = principal;
            this.__explicitlySet__.add("principal");
            return this;
        }

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            this.__explicitlySet__.add("pullRequestId");
            return this;
        }

        public Builder timeOccurred(Date timeOccurred) {
            this.timeOccurred = timeOccurred;
            this.__explicitlySet__.add("timeOccurred");
            return this;
        }

        public Builder commitsAdded(List<RepositoryCommit> commitsAdded) {
            this.commitsAdded = commitsAdded;
            this.__explicitlySet__.add("commitsAdded");
            return this;
        }

        public Builder commitsRemoved(List<RepositoryCommit> commitsRemoved) {
            this.commitsRemoved = commitsRemoved;
            this.__explicitlySet__.add("commitsRemoved");
            return this;
        }

        public CommitActivitySummary build() {
            CommitActivitySummary model = new CommitActivitySummary(this.id, this.principal, this.pullRequestId, this.timeOccurred, this.commitsAdded, this.commitsRemoved);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CommitActivitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("principal")) {
                this.principal(model.getPrincipal());
            }
            if (model.wasPropertyExplicitlySet("pullRequestId")) {
                this.pullRequestId(model.getPullRequestId());
            }
            if (model.wasPropertyExplicitlySet("timeOccurred")) {
                this.timeOccurred(model.getTimeOccurred());
            }
            if (model.wasPropertyExplicitlySet("commitsAdded")) {
                this.commitsAdded(model.getCommitsAdded());
            }
            if (model.wasPropertyExplicitlySet("commitsRemoved")) {
                this.commitsRemoved(model.getCommitsRemoved());
            }
            return this;
        }
    }
}

