/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MergePullRequestDetails;
import com.oracle.bmc.devops.model.MergeStrategy;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="actionType")
@JsonFilter(value="explicitlySetFilter")
public final class ExecuteMergePullRequestDetails
extends MergePullRequestDetails {
    @JsonProperty(value="commitMessage")
    private final String commitMessage;
    @JsonProperty(value="mergeStrategy")
    private final MergeStrategy mergeStrategy;
    @JsonProperty(value="postMergeAction")
    private final PostMergeAction postMergeAction;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ExecuteMergePullRequestDetails(String commitMessage, MergeStrategy mergeStrategy, PostMergeAction postMergeAction) {
        this.commitMessage = commitMessage;
        this.mergeStrategy = mergeStrategy;
        this.postMergeAction = postMergeAction;
    }

    public String getCommitMessage() {
        return this.commitMessage;
    }

    public MergeStrategy getMergeStrategy() {
        return this.mergeStrategy;
    }

    public PostMergeAction getPostMergeAction() {
        return this.postMergeAction;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ExecuteMergePullRequestDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", commitMessage=").append(String.valueOf(this.commitMessage));
        sb.append(", mergeStrategy=").append(String.valueOf((Object)this.mergeStrategy));
        sb.append(", postMergeAction=").append(String.valueOf((Object)this.postMergeAction));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ExecuteMergePullRequestDetails)) {
            return false;
        }
        ExecuteMergePullRequestDetails other = (ExecuteMergePullRequestDetails)((Object)o);
        return Objects.equals(this.commitMessage, other.commitMessage) && Objects.equals((Object)this.mergeStrategy, (Object)other.mergeStrategy) && Objects.equals((Object)this.postMergeAction, (Object)other.postMergeAction) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.commitMessage == null ? 43 : this.commitMessage.hashCode());
        result = result * 59 + (this.mergeStrategy == null ? 43 : this.mergeStrategy.hashCode());
        result = result * 59 + (this.postMergeAction == null ? 43 : this.postMergeAction.hashCode());
        return result;
    }

    public static enum PostMergeAction implements BmcEnum
    {
        DeleteSourceBranch("DELETE_SOURCE_BRANCH"),
        KeepSourceBranch("KEEP_SOURCE_BRANCH");

        private final String value;
        private static Map<String, PostMergeAction> map;

        private PostMergeAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PostMergeAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid PostMergeAction: " + key);
        }

        static {
            map = new HashMap<String, PostMergeAction>();
            for (PostMergeAction v : PostMergeAction.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="commitMessage")
        private String commitMessage;
        @JsonProperty(value="mergeStrategy")
        private MergeStrategy mergeStrategy;
        @JsonProperty(value="postMergeAction")
        private PostMergeAction postMergeAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            this.__explicitlySet__.add("commitMessage");
            return this;
        }

        public Builder mergeStrategy(MergeStrategy mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
            this.__explicitlySet__.add("mergeStrategy");
            return this;
        }

        public Builder postMergeAction(PostMergeAction postMergeAction) {
            this.postMergeAction = postMergeAction;
            this.__explicitlySet__.add("postMergeAction");
            return this;
        }

        public ExecuteMergePullRequestDetails build() {
            ExecuteMergePullRequestDetails model = new ExecuteMergePullRequestDetails(this.commitMessage, this.mergeStrategy, this.postMergeAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ExecuteMergePullRequestDetails model) {
            if (model.wasPropertyExplicitlySet("commitMessage")) {
                this.commitMessage(model.getCommitMessage());
            }
            if (model.wasPropertyExplicitlySet("mergeStrategy")) {
                this.mergeStrategy(model.getMergeStrategy());
            }
            if (model.wasPropertyExplicitlySet("postMergeAction")) {
                this.postMergeAction(model.getPostMergeAction());
            }
            return this;
        }
    }
}

