/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ForkSyncStatusSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="syncStatus")
    private final SyncStatus syncStatus;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="branchName")
    private final String branchName;

    @Deprecated
    @ConstructorProperties(value={"syncStatus", "repositoryId", "branchName"})
    public ForkSyncStatusSummary(SyncStatus syncStatus, String repositoryId, String branchName) {
        this.syncStatus = syncStatus;
        this.repositoryId = repositoryId;
        this.branchName = branchName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public SyncStatus getSyncStatus() {
        return this.syncStatus;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ForkSyncStatusSummary(");
        sb.append("super=").append(super.toString());
        sb.append("syncStatus=").append(String.valueOf((Object)this.syncStatus));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", branchName=").append(String.valueOf(this.branchName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ForkSyncStatusSummary)) {
            return false;
        }
        ForkSyncStatusSummary other = (ForkSyncStatusSummary)((Object)o);
        return Objects.equals((Object)this.syncStatus, (Object)other.syncStatus) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.branchName, other.branchName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.syncStatus == null ? 43 : this.syncStatus.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.branchName == null ? 43 : this.branchName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SyncStatus implements BmcEnum
    {
        InSync("IN_SYNC"),
        SyncInProgress("SYNC_IN_PROGRESS"),
        OutOfSync("OUT_OF_SYNC"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SyncStatus> map;

        private SyncStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SyncStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SyncStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SyncStatus.class);
            map = new HashMap<String, SyncStatus>();
            for (SyncStatus v : SyncStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="syncStatus")
        private SyncStatus syncStatus;
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="branchName")
        private String branchName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder syncStatus(SyncStatus syncStatus) {
            this.syncStatus = syncStatus;
            this.__explicitlySet__.add("syncStatus");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder branchName(String branchName) {
            this.branchName = branchName;
            this.__explicitlySet__.add("branchName");
            return this;
        }

        public ForkSyncStatusSummary build() {
            ForkSyncStatusSummary model = new ForkSyncStatusSummary(this.syncStatus, this.repositoryId, this.branchName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ForkSyncStatusSummary model) {
            if (model.wasPropertyExplicitlySet("syncStatus")) {
                this.syncStatus(model.getSyncStatus());
            }
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("branchName")) {
                this.branchName(model.getBranchName());
            }
            return this;
        }
    }
}

