/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployArtifactSource;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployArtifactSourceType")
@JsonFilter(value="explicitlySetFilter")
public final class HelmCommandSpecArtifactSource
extends DeployArtifactSource {
    @JsonProperty(value="base64EncodedContent")
    private final String base64EncodedContent;
    @JsonProperty(value="helmArtifactSourceType")
    private final HelmArtifactSourceType helmArtifactSourceType;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public HelmCommandSpecArtifactSource(String base64EncodedContent, HelmArtifactSourceType helmArtifactSourceType) {
        this.base64EncodedContent = base64EncodedContent;
        this.helmArtifactSourceType = helmArtifactSourceType;
    }

    public String getBase64EncodedContent() {
        return this.base64EncodedContent;
    }

    public HelmArtifactSourceType getHelmArtifactSourceType() {
        return this.helmArtifactSourceType;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("HelmCommandSpecArtifactSource(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", base64EncodedContent=").append(String.valueOf(this.base64EncodedContent));
        sb.append(", helmArtifactSourceType=").append(String.valueOf((Object)this.helmArtifactSourceType));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HelmCommandSpecArtifactSource)) {
            return false;
        }
        HelmCommandSpecArtifactSource other = (HelmCommandSpecArtifactSource)((Object)o);
        return Objects.equals(this.base64EncodedContent, other.base64EncodedContent) && Objects.equals((Object)this.helmArtifactSourceType, (Object)other.helmArtifactSourceType) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.base64EncodedContent == null ? 43 : this.base64EncodedContent.hashCode());
        result = result * 59 + (this.helmArtifactSourceType == null ? 43 : this.helmArtifactSourceType.hashCode());
        return result;
    }

    public static enum HelmArtifactSourceType implements BmcEnum
    {
        Inline("INLINE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, HelmArtifactSourceType> map;

        private HelmArtifactSourceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static HelmArtifactSourceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'HelmArtifactSourceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(HelmArtifactSourceType.class);
            map = new HashMap<String, HelmArtifactSourceType>();
            for (HelmArtifactSourceType v : HelmArtifactSourceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="base64EncodedContent")
        private String base64EncodedContent;
        @JsonProperty(value="helmArtifactSourceType")
        private HelmArtifactSourceType helmArtifactSourceType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder base64EncodedContent(String base64EncodedContent) {
            this.base64EncodedContent = base64EncodedContent;
            this.__explicitlySet__.add("base64EncodedContent");
            return this;
        }

        public Builder helmArtifactSourceType(HelmArtifactSourceType helmArtifactSourceType) {
            this.helmArtifactSourceType = helmArtifactSourceType;
            this.__explicitlySet__.add("helmArtifactSourceType");
            return this;
        }

        public HelmCommandSpecArtifactSource build() {
            HelmCommandSpecArtifactSource model = new HelmCommandSpecArtifactSource(this.base64EncodedContent, this.helmArtifactSourceType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(HelmCommandSpecArtifactSource model) {
            if (model.wasPropertyExplicitlySet("base64EncodedContent")) {
                this.base64EncodedContent(model.getBase64EncodedContent());
            }
            if (model.wasPropertyExplicitlySet("helmArtifactSourceType")) {
                this.helmArtifactSourceType(model.getHelmArtifactSourceType());
            }
            return this;
        }
    }
}

