/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MergeStrategy;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MergeSettings
extends ExplicitlySetBmcModel {
    @JsonProperty(value="defaultMergeStrategy")
    private final MergeStrategy defaultMergeStrategy;
    @JsonProperty(value="allowedMergeStrategies")
    private final List<MergeStrategy> allowedMergeStrategies;

    @Deprecated
    @ConstructorProperties(value={"defaultMergeStrategy", "allowedMergeStrategies"})
    public MergeSettings(MergeStrategy defaultMergeStrategy, List<MergeStrategy> allowedMergeStrategies) {
        this.defaultMergeStrategy = defaultMergeStrategy;
        this.allowedMergeStrategies = allowedMergeStrategies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MergeStrategy getDefaultMergeStrategy() {
        return this.defaultMergeStrategy;
    }

    public List<MergeStrategy> getAllowedMergeStrategies() {
        return this.allowedMergeStrategies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MergeSettings(");
        sb.append("super=").append(super.toString());
        sb.append("defaultMergeStrategy=").append(String.valueOf((Object)this.defaultMergeStrategy));
        sb.append(", allowedMergeStrategies=").append(String.valueOf(this.allowedMergeStrategies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MergeSettings)) {
            return false;
        }
        MergeSettings other = (MergeSettings)((Object)o);
        return Objects.equals((Object)this.defaultMergeStrategy, (Object)other.defaultMergeStrategy) && Objects.equals(this.allowedMergeStrategies, other.allowedMergeStrategies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.defaultMergeStrategy == null ? 43 : this.defaultMergeStrategy.hashCode());
        result = result * 59 + (this.allowedMergeStrategies == null ? 43 : this.allowedMergeStrategies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="defaultMergeStrategy")
        private MergeStrategy defaultMergeStrategy;
        @JsonProperty(value="allowedMergeStrategies")
        private List<MergeStrategy> allowedMergeStrategies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder defaultMergeStrategy(MergeStrategy defaultMergeStrategy) {
            this.defaultMergeStrategy = defaultMergeStrategy;
            this.__explicitlySet__.add("defaultMergeStrategy");
            return this;
        }

        public Builder allowedMergeStrategies(List<MergeStrategy> allowedMergeStrategies) {
            this.allowedMergeStrategies = allowedMergeStrategies;
            this.__explicitlySet__.add("allowedMergeStrategies");
            return this;
        }

        public MergeSettings build() {
            MergeSettings model = new MergeSettings(this.defaultMergeStrategy, this.allowedMergeStrategies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MergeSettings model) {
            if (model.wasPropertyExplicitlySet("defaultMergeStrategy")) {
                this.defaultMergeStrategy(model.getDefaultMergeStrategy());
            }
            if (model.wasPropertyExplicitlySet("allowedMergeStrategies")) {
                this.allowedMergeStrategies(model.getAllowedMergeStrategies());
            }
            return this;
        }
    }
}

