/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.PatchInstruction;
import com.oracle.bmc.http.internal.BmcEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="operation")
@JsonFilter(value="explicitlySetFilter")
public final class PatchMoveInstruction
extends PatchInstruction {
    @JsonProperty(value="from")
    private final String from;
    @JsonProperty(value="position")
    private final Position position;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public PatchMoveInstruction(String selection, String from, Position position) {
        super(selection);
        this.from = from;
        this.position = position;
    }

    public String getFrom() {
        return this.from;
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PatchMoveInstruction(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", from=").append(String.valueOf(this.from));
        sb.append(", position=").append(String.valueOf((Object)this.position));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PatchMoveInstruction)) {
            return false;
        }
        PatchMoveInstruction other = (PatchMoveInstruction)((Object)o);
        return Objects.equals(this.from, other.from) && Objects.equals((Object)this.position, (Object)other.position) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.from == null ? 43 : this.from.hashCode());
        result = result * 59 + (this.position == null ? 43 : this.position.hashCode());
        return result;
    }

    public static enum Position implements BmcEnum
    {
        At("AT"),
        Before("BEFORE"),
        After("AFTER");

        private final String value;
        private static Map<String, Position> map;

        private Position(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Position create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Position: " + key);
        }

        static {
            map = new HashMap<String, Position>();
            for (Position v : Position.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="selection")
        private String selection;
        @JsonProperty(value="from")
        private String from;
        @JsonProperty(value="position")
        private Position position;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder selection(String selection) {
            this.selection = selection;
            this.__explicitlySet__.add("selection");
            return this;
        }

        public Builder from(String from) {
            this.from = from;
            this.__explicitlySet__.add("from");
            return this;
        }

        public Builder position(Position position) {
            this.position = position;
            this.__explicitlySet__.add("position");
            return this;
        }

        public PatchMoveInstruction build() {
            PatchMoveInstruction model = new PatchMoveInstruction(this.selection, this.from, this.position);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PatchMoveInstruction model) {
            if (model.wasPropertyExplicitlySet("selection")) {
                this.selection(model.getSelection());
            }
            if (model.wasPropertyExplicitlySet("from")) {
                this.from(model.getFrom());
            }
            if (model.wasPropertyExplicitlySet("position")) {
                this.position(model.getPosition());
            }
            return this;
        }
    }
}

