/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PrincipalDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="principalId")
    private final String principalId;
    @JsonProperty(value="principalName")
    private final String principalName;
    @JsonProperty(value="principalType")
    private final PrincipalType principalType;
    @JsonProperty(value="principalState")
    private final PrincipalState principalState;

    @Deprecated
    @ConstructorProperties(value={"principalId", "principalName", "principalType", "principalState"})
    public PrincipalDetails(String principalId, String principalName, PrincipalType principalType, PrincipalState principalState) {
        this.principalId = principalId;
        this.principalName = principalName;
        this.principalType = principalType;
        this.principalState = principalState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getPrincipalName() {
        return this.principalName;
    }

    public PrincipalType getPrincipalType() {
        return this.principalType;
    }

    public PrincipalState getPrincipalState() {
        return this.principalState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PrincipalDetails(");
        sb.append("super=").append(super.toString());
        sb.append("principalId=").append(String.valueOf(this.principalId));
        sb.append(", principalName=").append(String.valueOf(this.principalName));
        sb.append(", principalType=").append(String.valueOf((Object)this.principalType));
        sb.append(", principalState=").append(String.valueOf((Object)this.principalState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PrincipalDetails)) {
            return false;
        }
        PrincipalDetails other = (PrincipalDetails)((Object)o);
        return Objects.equals(this.principalId, other.principalId) && Objects.equals(this.principalName, other.principalName) && Objects.equals((Object)this.principalType, (Object)other.principalType) && Objects.equals((Object)this.principalState, (Object)other.principalState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.principalId == null ? 43 : this.principalId.hashCode());
        result = result * 59 + (this.principalName == null ? 43 : this.principalName.hashCode());
        result = result * 59 + (this.principalType == null ? 43 : this.principalType.hashCode());
        result = result * 59 + (this.principalState == null ? 43 : this.principalState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum PrincipalState implements BmcEnum
    {
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Suppressed("SUPPRESSED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrincipalState> map;

        private PrincipalState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrincipalState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrincipalState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrincipalState.class);
            map = new HashMap<String, PrincipalState>();
            for (PrincipalState v : PrincipalState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum PrincipalType implements BmcEnum
    {
        Service("SERVICE"),
        User("USER"),
        Instance("INSTANCE"),
        Resource("RESOURCE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, PrincipalType> map;

        private PrincipalType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static PrincipalType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'PrincipalType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(PrincipalType.class);
            map = new HashMap<String, PrincipalType>();
            for (PrincipalType v : PrincipalType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="principalId")
        private String principalId;
        @JsonProperty(value="principalName")
        private String principalName;
        @JsonProperty(value="principalType")
        private PrincipalType principalType;
        @JsonProperty(value="principalState")
        private PrincipalState principalState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.__explicitlySet__.add("principalId");
            return this;
        }

        public Builder principalName(String principalName) {
            this.principalName = principalName;
            this.__explicitlySet__.add("principalName");
            return this;
        }

        public Builder principalType(PrincipalType principalType) {
            this.principalType = principalType;
            this.__explicitlySet__.add("principalType");
            return this;
        }

        public Builder principalState(PrincipalState principalState) {
            this.principalState = principalState;
            this.__explicitlySet__.add("principalState");
            return this;
        }

        public PrincipalDetails build() {
            PrincipalDetails model = new PrincipalDetails(this.principalId, this.principalName, this.principalType, this.principalState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PrincipalDetails model) {
            if (model.wasPropertyExplicitlySet("principalId")) {
                this.principalId(model.getPrincipalId());
            }
            if (model.wasPropertyExplicitlySet("principalName")) {
                this.principalName(model.getPrincipalName());
            }
            if (model.wasPropertyExplicitlySet("principalType")) {
                this.principalType(model.getPrincipalType());
            }
            if (model.wasPropertyExplicitlySet("principalState")) {
                this.principalState(model.getPrincipalState());
            }
            return this;
        }
    }
}

