/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProjectNotificationPreference
extends ExplicitlySetBmcModel {
    @JsonProperty(value="projectId")
    private final String projectId;
    @JsonProperty(value="userId")
    private final String userId;
    @JsonProperty(value="notificationPreference")
    private final NotificationPreference notificationPreference;

    @Deprecated
    @ConstructorProperties(value={"projectId", "userId", "notificationPreference"})
    public ProjectNotificationPreference(String projectId, String userId, NotificationPreference notificationPreference) {
        this.projectId = projectId;
        this.userId = userId;
        this.notificationPreference = notificationPreference;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getUserId() {
        return this.userId;
    }

    public NotificationPreference getNotificationPreference() {
        return this.notificationPreference;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProjectNotificationPreference(");
        sb.append("super=").append(super.toString());
        sb.append("projectId=").append(String.valueOf(this.projectId));
        sb.append(", userId=").append(String.valueOf(this.userId));
        sb.append(", notificationPreference=").append(String.valueOf((Object)this.notificationPreference));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProjectNotificationPreference)) {
            return false;
        }
        ProjectNotificationPreference other = (ProjectNotificationPreference)((Object)o);
        return Objects.equals(this.projectId, other.projectId) && Objects.equals(this.userId, other.userId) && Objects.equals((Object)this.notificationPreference, (Object)other.notificationPreference) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.projectId == null ? 43 : this.projectId.hashCode());
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.notificationPreference == null ? 43 : this.notificationPreference.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum NotificationPreference implements BmcEnum
    {
        Watch("WATCH"),
        Ignore("IGNORE"),
        Mention("MENTION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, NotificationPreference> map;

        private NotificationPreference(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static NotificationPreference create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'NotificationPreference', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(NotificationPreference.class);
            map = new HashMap<String, NotificationPreference>();
            for (NotificationPreference v : NotificationPreference.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="userId")
        private String userId;
        @JsonProperty(value="notificationPreference")
        private NotificationPreference notificationPreference;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.__explicitlySet__.add("userId");
            return this;
        }

        public Builder notificationPreference(NotificationPreference notificationPreference) {
            this.notificationPreference = notificationPreference;
            this.__explicitlySet__.add("notificationPreference");
            return this;
        }

        public ProjectNotificationPreference build() {
            ProjectNotificationPreference model = new ProjectNotificationPreference(this.projectId, this.userId, this.notificationPreference);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProjectNotificationPreference model) {
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("userId")) {
                this.userId(model.getUserId());
            }
            if (model.wasPropertyExplicitlySet("notificationPreference")) {
                this.notificationPreference(model.getNotificationPreference());
            }
            return this;
        }
    }
}

