/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MergeCheckCollection;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.Reviewer;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PullRequest
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="repositoryId")
    private final String repositoryId;
    @JsonProperty(value="sourceBranch")
    private final String sourceBranch;
    @JsonProperty(value="destinationBranch")
    private final String destinationBranch;
    @JsonProperty(value="sourceCommitIdAtTermination")
    private final String sourceCommitIdAtTermination;
    @JsonProperty(value="mergeBaseCommitIdAtTermination")
    private final String mergeBaseCommitIdAtTermination;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final LifecycleDetails lifecycleDetails;
    @JsonProperty(value="reviewers")
    private final List<Reviewer> reviewers;
    @JsonProperty(value="mergeChecks")
    private final MergeCheckCollection mergeChecks;
    @JsonProperty(value="createdBy")
    private final PrincipalDetails createdBy;
    @JsonProperty(value="mergedBy")
    private final PrincipalDetails mergedBy;
    @JsonProperty(value="sourceRepositoryId")
    private final String sourceRepositoryId;
    @JsonProperty(value="totalComments")
    private final Integer totalComments;
    @JsonProperty(value="totalReviewers")
    private final Integer totalReviewers;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "description", "compartmentId", "repositoryId", "sourceBranch", "destinationBranch", "sourceCommitIdAtTermination", "mergeBaseCommitIdAtTermination", "timeCreated", "timeUpdated", "lifecycleState", "lifecycleDetails", "reviewers", "mergeChecks", "createdBy", "mergedBy", "sourceRepositoryId", "totalComments", "totalReviewers", "freeformTags", "definedTags", "systemTags"})
    public PullRequest(String id, String displayName, String description, String compartmentId, String repositoryId, String sourceBranch, String destinationBranch, String sourceCommitIdAtTermination, String mergeBaseCommitIdAtTermination, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, LifecycleDetails lifecycleDetails, List<Reviewer> reviewers, MergeCheckCollection mergeChecks, PrincipalDetails createdBy, PrincipalDetails mergedBy, String sourceRepositoryId, Integer totalComments, Integer totalReviewers, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.compartmentId = compartmentId;
        this.repositoryId = repositoryId;
        this.sourceBranch = sourceBranch;
        this.destinationBranch = destinationBranch;
        this.sourceCommitIdAtTermination = sourceCommitIdAtTermination;
        this.mergeBaseCommitIdAtTermination = mergeBaseCommitIdAtTermination;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.reviewers = reviewers;
        this.mergeChecks = mergeChecks;
        this.createdBy = createdBy;
        this.mergedBy = mergedBy;
        this.sourceRepositoryId = sourceRepositoryId;
        this.totalComments = totalComments;
        this.totalReviewers = totalReviewers;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getSourceBranch() {
        return this.sourceBranch;
    }

    public String getDestinationBranch() {
        return this.destinationBranch;
    }

    public String getSourceCommitIdAtTermination() {
        return this.sourceCommitIdAtTermination;
    }

    public String getMergeBaseCommitIdAtTermination() {
        return this.mergeBaseCommitIdAtTermination;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public LifecycleDetails getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public List<Reviewer> getReviewers() {
        return this.reviewers;
    }

    public MergeCheckCollection getMergeChecks() {
        return this.mergeChecks;
    }

    public PrincipalDetails getCreatedBy() {
        return this.createdBy;
    }

    public PrincipalDetails getMergedBy() {
        return this.mergedBy;
    }

    public String getSourceRepositoryId() {
        return this.sourceRepositoryId;
    }

    public Integer getTotalComments() {
        return this.totalComments;
    }

    public Integer getTotalReviewers() {
        return this.totalReviewers;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PullRequest(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(", sourceBranch=").append(String.valueOf(this.sourceBranch));
        sb.append(", destinationBranch=").append(String.valueOf(this.destinationBranch));
        sb.append(", sourceCommitIdAtTermination=").append(String.valueOf(this.sourceCommitIdAtTermination));
        sb.append(", mergeBaseCommitIdAtTermination=").append(String.valueOf(this.mergeBaseCommitIdAtTermination));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf((Object)this.lifecycleDetails));
        sb.append(", reviewers=").append(String.valueOf(this.reviewers));
        sb.append(", mergeChecks=").append(String.valueOf((Object)this.mergeChecks));
        sb.append(", createdBy=").append(String.valueOf((Object)this.createdBy));
        sb.append(", mergedBy=").append(String.valueOf((Object)this.mergedBy));
        sb.append(", sourceRepositoryId=").append(String.valueOf(this.sourceRepositoryId));
        sb.append(", totalComments=").append(String.valueOf(this.totalComments));
        sb.append(", totalReviewers=").append(String.valueOf(this.totalReviewers));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PullRequest)) {
            return false;
        }
        PullRequest other = (PullRequest)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.sourceBranch, other.sourceBranch) && Objects.equals(this.destinationBranch, other.destinationBranch) && Objects.equals(this.sourceCommitIdAtTermination, other.sourceCommitIdAtTermination) && Objects.equals(this.mergeBaseCommitIdAtTermination, other.mergeBaseCommitIdAtTermination) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.lifecycleDetails, (Object)other.lifecycleDetails) && Objects.equals(this.reviewers, other.reviewers) && Objects.equals((Object)this.mergeChecks, (Object)other.mergeChecks) && Objects.equals((Object)this.createdBy, (Object)other.createdBy) && Objects.equals((Object)this.mergedBy, (Object)other.mergedBy) && Objects.equals(this.sourceRepositoryId, other.sourceRepositoryId) && Objects.equals(this.totalComments, other.totalComments) && Objects.equals(this.totalReviewers, other.totalReviewers) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.sourceBranch == null ? 43 : this.sourceBranch.hashCode());
        result = result * 59 + (this.destinationBranch == null ? 43 : this.destinationBranch.hashCode());
        result = result * 59 + (this.sourceCommitIdAtTermination == null ? 43 : this.sourceCommitIdAtTermination.hashCode());
        result = result * 59 + (this.mergeBaseCommitIdAtTermination == null ? 43 : this.mergeBaseCommitIdAtTermination.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.reviewers == null ? 43 : this.reviewers.hashCode());
        result = result * 59 + (this.mergeChecks == null ? 43 : this.mergeChecks.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.mergedBy == null ? 43 : this.mergedBy.hashCode());
        result = result * 59 + (this.sourceRepositoryId == null ? 43 : this.sourceRepositoryId.hashCode());
        result = result * 59 + (this.totalComments == null ? 43 : this.totalComments.hashCode());
        result = result * 59 + (this.totalReviewers == null ? 43 : this.totalReviewers.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleDetails implements BmcEnum
    {
        Open("OPEN"),
        Conflict("CONFLICT"),
        Closed("CLOSED"),
        Merging("MERGING"),
        Merged("MERGED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleDetails> map;

        private LifecycleDetails(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleDetails create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleDetails', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleDetails.class);
            map = new HashMap<String, LifecycleDetails>();
            for (LifecycleDetails v : LifecycleDetails.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState implements BmcEnum
    {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="repositoryId")
        private String repositoryId;
        @JsonProperty(value="sourceBranch")
        private String sourceBranch;
        @JsonProperty(value="destinationBranch")
        private String destinationBranch;
        @JsonProperty(value="sourceCommitIdAtTermination")
        private String sourceCommitIdAtTermination;
        @JsonProperty(value="mergeBaseCommitIdAtTermination")
        private String mergeBaseCommitIdAtTermination;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private LifecycleDetails lifecycleDetails;
        @JsonProperty(value="reviewers")
        private List<Reviewer> reviewers;
        @JsonProperty(value="mergeChecks")
        private MergeCheckCollection mergeChecks;
        @JsonProperty(value="createdBy")
        private PrincipalDetails createdBy;
        @JsonProperty(value="mergedBy")
        private PrincipalDetails mergedBy;
        @JsonProperty(value="sourceRepositoryId")
        private String sourceRepositoryId;
        @JsonProperty(value="totalComments")
        private Integer totalComments;
        @JsonProperty(value="totalReviewers")
        private Integer totalReviewers;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.__explicitlySet__.add("repositoryId");
            return this;
        }

        public Builder sourceBranch(String sourceBranch) {
            this.sourceBranch = sourceBranch;
            this.__explicitlySet__.add("sourceBranch");
            return this;
        }

        public Builder destinationBranch(String destinationBranch) {
            this.destinationBranch = destinationBranch;
            this.__explicitlySet__.add("destinationBranch");
            return this;
        }

        public Builder sourceCommitIdAtTermination(String sourceCommitIdAtTermination) {
            this.sourceCommitIdAtTermination = sourceCommitIdAtTermination;
            this.__explicitlySet__.add("sourceCommitIdAtTermination");
            return this;
        }

        public Builder mergeBaseCommitIdAtTermination(String mergeBaseCommitIdAtTermination) {
            this.mergeBaseCommitIdAtTermination = mergeBaseCommitIdAtTermination;
            this.__explicitlySet__.add("mergeBaseCommitIdAtTermination");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(LifecycleDetails lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder reviewers(List<Reviewer> reviewers) {
            this.reviewers = reviewers;
            this.__explicitlySet__.add("reviewers");
            return this;
        }

        public Builder mergeChecks(MergeCheckCollection mergeChecks) {
            this.mergeChecks = mergeChecks;
            this.__explicitlySet__.add("mergeChecks");
            return this;
        }

        public Builder createdBy(PrincipalDetails createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder mergedBy(PrincipalDetails mergedBy) {
            this.mergedBy = mergedBy;
            this.__explicitlySet__.add("mergedBy");
            return this;
        }

        public Builder sourceRepositoryId(String sourceRepositoryId) {
            this.sourceRepositoryId = sourceRepositoryId;
            this.__explicitlySet__.add("sourceRepositoryId");
            return this;
        }

        public Builder totalComments(Integer totalComments) {
            this.totalComments = totalComments;
            this.__explicitlySet__.add("totalComments");
            return this;
        }

        public Builder totalReviewers(Integer totalReviewers) {
            this.totalReviewers = totalReviewers;
            this.__explicitlySet__.add("totalReviewers");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public PullRequest build() {
            PullRequest model = new PullRequest(this.id, this.displayName, this.description, this.compartmentId, this.repositoryId, this.sourceBranch, this.destinationBranch, this.sourceCommitIdAtTermination, this.mergeBaseCommitIdAtTermination, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.reviewers, this.mergeChecks, this.createdBy, this.mergedBy, this.sourceRepositoryId, this.totalComments, this.totalReviewers, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PullRequest model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("repositoryId")) {
                this.repositoryId(model.getRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("sourceBranch")) {
                this.sourceBranch(model.getSourceBranch());
            }
            if (model.wasPropertyExplicitlySet("destinationBranch")) {
                this.destinationBranch(model.getDestinationBranch());
            }
            if (model.wasPropertyExplicitlySet("sourceCommitIdAtTermination")) {
                this.sourceCommitIdAtTermination(model.getSourceCommitIdAtTermination());
            }
            if (model.wasPropertyExplicitlySet("mergeBaseCommitIdAtTermination")) {
                this.mergeBaseCommitIdAtTermination(model.getMergeBaseCommitIdAtTermination());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("reviewers")) {
                this.reviewers(model.getReviewers());
            }
            if (model.wasPropertyExplicitlySet("mergeChecks")) {
                this.mergeChecks(model.getMergeChecks());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("mergedBy")) {
                this.mergedBy(model.getMergedBy());
            }
            if (model.wasPropertyExplicitlySet("sourceRepositoryId")) {
                this.sourceRepositoryId(model.getSourceRepositoryId());
            }
            if (model.wasPropertyExplicitlySet("totalComments")) {
                this.totalComments(model.getTotalComments());
            }
            if (model.wasPropertyExplicitlySet("totalReviewers")) {
                this.totalReviewers(model.getTotalReviewers());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

