/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.devops.model.ApprovalActivitySummary;
import com.oracle.bmc.devops.model.CommentActivitySummary;
import com.oracle.bmc.devops.model.CommitActivitySummary;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.PullRequestLifecycleActivitySummary;
import com.oracle.bmc.devops.model.ReviewerActivitySummary;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="activityType", defaultImpl=PullRequestActivitySummary.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=CommitActivitySummary.class, name="COMMIT"), @JsonSubTypes.Type(value=CommentActivitySummary.class, name="COMMENT"), @JsonSubTypes.Type(value=ApprovalActivitySummary.class, name="APPROVAL"), @JsonSubTypes.Type(value=ReviewerActivitySummary.class, name="REVIEWER"), @JsonSubTypes.Type(value=PullRequestLifecycleActivitySummary.class, name="LIFECYCLE")})
@JsonFilter(value="explicitlySetFilter")
public class PullRequestActivitySummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="principal")
    private final PrincipalDetails principal;
    @JsonProperty(value="pullRequestId")
    private final String pullRequestId;
    @JsonProperty(value="timeOccurred")
    private final Date timeOccurred;

    @Deprecated
    @ConstructorProperties(value={"id", "principal", "pullRequestId", "timeOccurred"})
    protected PullRequestActivitySummary(String id, PrincipalDetails principal, String pullRequestId, Date timeOccurred) {
        this.id = id;
        this.principal = principal;
        this.pullRequestId = pullRequestId;
        this.timeOccurred = timeOccurred;
    }

    public String getId() {
        return this.id;
    }

    public PrincipalDetails getPrincipal() {
        return this.principal;
    }

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public Date getTimeOccurred() {
        return this.timeOccurred;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PullRequestActivitySummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", principal=").append(String.valueOf((Object)this.principal));
        sb.append(", pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(", timeOccurred=").append(String.valueOf(this.timeOccurred));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PullRequestActivitySummary)) {
            return false;
        }
        PullRequestActivitySummary other = (PullRequestActivitySummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals((Object)this.principal, (Object)other.principal) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals(this.timeOccurred, other.timeOccurred) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.principal == null ? 43 : this.principal.hashCode());
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.timeOccurred == null ? 43 : this.timeOccurred.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ActivityType implements BmcEnum
    {
        Lifecycle("LIFECYCLE"),
        Approval("APPROVAL"),
        Commit("COMMIT"),
        Reviewer("REVIEWER"),
        Comment("COMMENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ActivityType> map;

        private ActivityType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ActivityType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ActivityType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ActivityType.class);
            map = new HashMap<String, ActivityType>();
            for (ActivityType v : ActivityType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }
}

