/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PullRequestChangeSummaryMetrics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="changedFilesCount")
    private final Integer changedFilesCount;
    @JsonProperty(value="addedLinesCount")
    private final Integer addedLinesCount;
    @JsonProperty(value="deletedLinesCount")
    private final Integer deletedLinesCount;

    @Deprecated
    @ConstructorProperties(value={"changedFilesCount", "addedLinesCount", "deletedLinesCount"})
    public PullRequestChangeSummaryMetrics(Integer changedFilesCount, Integer addedLinesCount, Integer deletedLinesCount) {
        this.changedFilesCount = changedFilesCount;
        this.addedLinesCount = addedLinesCount;
        this.deletedLinesCount = deletedLinesCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getChangedFilesCount() {
        return this.changedFilesCount;
    }

    public Integer getAddedLinesCount() {
        return this.addedLinesCount;
    }

    public Integer getDeletedLinesCount() {
        return this.deletedLinesCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PullRequestChangeSummaryMetrics(");
        sb.append("super=").append(super.toString());
        sb.append("changedFilesCount=").append(String.valueOf(this.changedFilesCount));
        sb.append(", addedLinesCount=").append(String.valueOf(this.addedLinesCount));
        sb.append(", deletedLinesCount=").append(String.valueOf(this.deletedLinesCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PullRequestChangeSummaryMetrics)) {
            return false;
        }
        PullRequestChangeSummaryMetrics other = (PullRequestChangeSummaryMetrics)((Object)o);
        return Objects.equals(this.changedFilesCount, other.changedFilesCount) && Objects.equals(this.addedLinesCount, other.addedLinesCount) && Objects.equals(this.deletedLinesCount, other.deletedLinesCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.changedFilesCount == null ? 43 : this.changedFilesCount.hashCode());
        result = result * 59 + (this.addedLinesCount == null ? 43 : this.addedLinesCount.hashCode());
        result = result * 59 + (this.deletedLinesCount == null ? 43 : this.deletedLinesCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="changedFilesCount")
        private Integer changedFilesCount;
        @JsonProperty(value="addedLinesCount")
        private Integer addedLinesCount;
        @JsonProperty(value="deletedLinesCount")
        private Integer deletedLinesCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder changedFilesCount(Integer changedFilesCount) {
            this.changedFilesCount = changedFilesCount;
            this.__explicitlySet__.add("changedFilesCount");
            return this;
        }

        public Builder addedLinesCount(Integer addedLinesCount) {
            this.addedLinesCount = addedLinesCount;
            this.__explicitlySet__.add("addedLinesCount");
            return this;
        }

        public Builder deletedLinesCount(Integer deletedLinesCount) {
            this.deletedLinesCount = deletedLinesCount;
            this.__explicitlySet__.add("deletedLinesCount");
            return this;
        }

        public PullRequestChangeSummaryMetrics build() {
            PullRequestChangeSummaryMetrics model = new PullRequestChangeSummaryMetrics(this.changedFilesCount, this.addedLinesCount, this.deletedLinesCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PullRequestChangeSummaryMetrics model) {
            if (model.wasPropertyExplicitlySet("changedFilesCount")) {
                this.changedFilesCount(model.getChangedFilesCount());
            }
            if (model.wasPropertyExplicitlySet("addedLinesCount")) {
                this.addedLinesCount(model.getAddedLinesCount());
            }
            if (model.wasPropertyExplicitlySet("deletedLinesCount")) {
                this.deletedLinesCount(model.getDeletedLinesCount());
            }
            return this;
        }
    }
}

