/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DiffLineDetails;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.PullRequestCommentLikeCollection;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class PullRequestComment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="pullRequestId")
    private final String pullRequestId;
    @JsonProperty(value="data")
    private final String data;
    @JsonProperty(value="parentId")
    private final String parentId;
    @JsonProperty(value="filePath")
    private final String filePath;
    @JsonProperty(value="commitId")
    private final String commitId;
    @JsonProperty(value="fileType")
    private final FileType fileType;
    @JsonProperty(value="lineNumber")
    private final Integer lineNumber;
    @JsonProperty(value="likes")
    private final PullRequestCommentLikeCollection likes;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="createdBy")
    private final PrincipalDetails createdBy;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="updatedBy")
    private final PrincipalDetails updatedBy;
    @JsonProperty(value="contextStatus")
    private final ContextStatus contextStatus;
    @JsonProperty(value="commentContext")
    private final List<DiffLineDetails> commentContext;

    @Deprecated
    @ConstructorProperties(value={"id", "pullRequestId", "data", "parentId", "filePath", "commitId", "fileType", "lineNumber", "likes", "status", "timeCreated", "createdBy", "timeUpdated", "updatedBy", "contextStatus", "commentContext"})
    public PullRequestComment(String id, String pullRequestId, String data, String parentId, String filePath, String commitId, FileType fileType, Integer lineNumber, PullRequestCommentLikeCollection likes, Status status, Date timeCreated, PrincipalDetails createdBy, Date timeUpdated, PrincipalDetails updatedBy, ContextStatus contextStatus, List<DiffLineDetails> commentContext) {
        this.id = id;
        this.pullRequestId = pullRequestId;
        this.data = data;
        this.parentId = parentId;
        this.filePath = filePath;
        this.commitId = commitId;
        this.fileType = fileType;
        this.lineNumber = lineNumber;
        this.likes = likes;
        this.status = status;
        this.timeCreated = timeCreated;
        this.createdBy = createdBy;
        this.timeUpdated = timeUpdated;
        this.updatedBy = updatedBy;
        this.contextStatus = contextStatus;
        this.commentContext = commentContext;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public String getData() {
        return this.data;
    }

    public String getParentId() {
        return this.parentId;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getCommitId() {
        return this.commitId;
    }

    public FileType getFileType() {
        return this.fileType;
    }

    public Integer getLineNumber() {
        return this.lineNumber;
    }

    public PullRequestCommentLikeCollection getLikes() {
        return this.likes;
    }

    public Status getStatus() {
        return this.status;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public PrincipalDetails getCreatedBy() {
        return this.createdBy;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public PrincipalDetails getUpdatedBy() {
        return this.updatedBy;
    }

    public ContextStatus getContextStatus() {
        return this.contextStatus;
    }

    public List<DiffLineDetails> getCommentContext() {
        return this.commentContext;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("PullRequestComment(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(", data=").append(String.valueOf(this.data));
        sb.append(", parentId=").append(String.valueOf(this.parentId));
        sb.append(", filePath=").append(String.valueOf(this.filePath));
        sb.append(", commitId=").append(String.valueOf(this.commitId));
        sb.append(", fileType=").append(String.valueOf((Object)this.fileType));
        sb.append(", lineNumber=").append(String.valueOf(this.lineNumber));
        sb.append(", likes=").append(String.valueOf((Object)this.likes));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", createdBy=").append(String.valueOf((Object)this.createdBy));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", updatedBy=").append(String.valueOf((Object)this.updatedBy));
        sb.append(", contextStatus=").append(String.valueOf((Object)this.contextStatus));
        sb.append(", commentContext=").append(String.valueOf(this.commentContext));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PullRequestComment)) {
            return false;
        }
        PullRequestComment other = (PullRequestComment)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals(this.data, other.data) && Objects.equals(this.parentId, other.parentId) && Objects.equals(this.filePath, other.filePath) && Objects.equals(this.commitId, other.commitId) && Objects.equals((Object)this.fileType, (Object)other.fileType) && Objects.equals(this.lineNumber, other.lineNumber) && Objects.equals((Object)this.likes, (Object)other.likes) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals((Object)this.createdBy, (Object)other.createdBy) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals((Object)this.updatedBy, (Object)other.updatedBy) && Objects.equals((Object)this.contextStatus, (Object)other.contextStatus) && Objects.equals(this.commentContext, other.commentContext) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.data == null ? 43 : this.data.hashCode());
        result = result * 59 + (this.parentId == null ? 43 : this.parentId.hashCode());
        result = result * 59 + (this.filePath == null ? 43 : this.filePath.hashCode());
        result = result * 59 + (this.commitId == null ? 43 : this.commitId.hashCode());
        result = result * 59 + (this.fileType == null ? 43 : this.fileType.hashCode());
        result = result * 59 + (this.lineNumber == null ? 43 : this.lineNumber.hashCode());
        result = result * 59 + (this.likes == null ? 43 : this.likes.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.createdBy == null ? 43 : this.createdBy.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.updatedBy == null ? 43 : this.updatedBy.hashCode());
        result = result * 59 + (this.contextStatus == null ? 43 : this.contextStatus.hashCode());
        result = result * 59 + (this.commentContext == null ? 43 : this.commentContext.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ContextStatus implements BmcEnum
    {
        Processed("PROCESSED"),
        NeedsProcessing("NEEDS_PROCESSING"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ContextStatus> map;

        private ContextStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ContextStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ContextStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ContextStatus.class);
            map = new HashMap<String, ContextStatus>();
            for (ContextStatus v : ContextStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Active("ACTIVE"),
        Outdated("OUTDATED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum FileType implements BmcEnum
    {
        Source("SOURCE"),
        Destination("DESTINATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, FileType> map;

        private FileType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static FileType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'FileType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(FileType.class);
            map = new HashMap<String, FileType>();
            for (FileType v : FileType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="pullRequestId")
        private String pullRequestId;
        @JsonProperty(value="data")
        private String data;
        @JsonProperty(value="parentId")
        private String parentId;
        @JsonProperty(value="filePath")
        private String filePath;
        @JsonProperty(value="commitId")
        private String commitId;
        @JsonProperty(value="fileType")
        private FileType fileType;
        @JsonProperty(value="lineNumber")
        private Integer lineNumber;
        @JsonProperty(value="likes")
        private PullRequestCommentLikeCollection likes;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="createdBy")
        private PrincipalDetails createdBy;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="updatedBy")
        private PrincipalDetails updatedBy;
        @JsonProperty(value="contextStatus")
        private ContextStatus contextStatus;
        @JsonProperty(value="commentContext")
        private List<DiffLineDetails> commentContext;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            this.__explicitlySet__.add("pullRequestId");
            return this;
        }

        public Builder data(String data) {
            this.data = data;
            this.__explicitlySet__.add("data");
            return this;
        }

        public Builder parentId(String parentId) {
            this.parentId = parentId;
            this.__explicitlySet__.add("parentId");
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            this.__explicitlySet__.add("filePath");
            return this;
        }

        public Builder commitId(String commitId) {
            this.commitId = commitId;
            this.__explicitlySet__.add("commitId");
            return this;
        }

        public Builder fileType(FileType fileType) {
            this.fileType = fileType;
            this.__explicitlySet__.add("fileType");
            return this;
        }

        public Builder lineNumber(Integer lineNumber) {
            this.lineNumber = lineNumber;
            this.__explicitlySet__.add("lineNumber");
            return this;
        }

        public Builder likes(PullRequestCommentLikeCollection likes) {
            this.likes = likes;
            this.__explicitlySet__.add("likes");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder createdBy(PrincipalDetails createdBy) {
            this.createdBy = createdBy;
            this.__explicitlySet__.add("createdBy");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder updatedBy(PrincipalDetails updatedBy) {
            this.updatedBy = updatedBy;
            this.__explicitlySet__.add("updatedBy");
            return this;
        }

        public Builder contextStatus(ContextStatus contextStatus) {
            this.contextStatus = contextStatus;
            this.__explicitlySet__.add("contextStatus");
            return this;
        }

        public Builder commentContext(List<DiffLineDetails> commentContext) {
            this.commentContext = commentContext;
            this.__explicitlySet__.add("commentContext");
            return this;
        }

        public PullRequestComment build() {
            PullRequestComment model = new PullRequestComment(this.id, this.pullRequestId, this.data, this.parentId, this.filePath, this.commitId, this.fileType, this.lineNumber, this.likes, this.status, this.timeCreated, this.createdBy, this.timeUpdated, this.updatedBy, this.contextStatus, this.commentContext);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(PullRequestComment model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("pullRequestId")) {
                this.pullRequestId(model.getPullRequestId());
            }
            if (model.wasPropertyExplicitlySet("data")) {
                this.data(model.getData());
            }
            if (model.wasPropertyExplicitlySet("parentId")) {
                this.parentId(model.getParentId());
            }
            if (model.wasPropertyExplicitlySet("filePath")) {
                this.filePath(model.getFilePath());
            }
            if (model.wasPropertyExplicitlySet("commitId")) {
                this.commitId(model.getCommitId());
            }
            if (model.wasPropertyExplicitlySet("fileType")) {
                this.fileType(model.getFileType());
            }
            if (model.wasPropertyExplicitlySet("lineNumber")) {
                this.lineNumber(model.getLineNumber());
            }
            if (model.wasPropertyExplicitlySet("likes")) {
                this.likes(model.getLikes());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("createdBy")) {
                this.createdBy(model.getCreatedBy());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("updatedBy")) {
                this.updatedBy(model.getUpdatedBy());
            }
            if (model.wasPropertyExplicitlySet("contextStatus")) {
                this.contextStatus(model.getContextStatus());
            }
            if (model.wasPropertyExplicitlySet("commentContext")) {
                this.commentContext(model.getCommentContext());
            }
            return this;
        }
    }
}

