/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MetricName;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryAnalyticsDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="authorEmail")
    private final String authorEmail;
    @JsonProperty(value="repositoryMetrics")
    private final List<MetricName> repositoryMetrics;
    @JsonProperty(value="aggregationDuration")
    private final AggregationDuration aggregationDuration;
    @JsonProperty(value="startTime")
    private final Date startTime;
    @JsonProperty(value="endTime")
    private final Date endTime;
    @JsonProperty(value="groupBy")
    private final GroupBy groupBy;

    @Deprecated
    @ConstructorProperties(value={"authorEmail", "repositoryMetrics", "aggregationDuration", "startTime", "endTime", "groupBy"})
    public RepositoryAnalyticsDetails(String authorEmail, List<MetricName> repositoryMetrics, AggregationDuration aggregationDuration, Date startTime, Date endTime, GroupBy groupBy) {
        this.authorEmail = authorEmail;
        this.repositoryMetrics = repositoryMetrics;
        this.aggregationDuration = aggregationDuration;
        this.startTime = startTime;
        this.endTime = endTime;
        this.groupBy = groupBy;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAuthorEmail() {
        return this.authorEmail;
    }

    public List<MetricName> getRepositoryMetrics() {
        return this.repositoryMetrics;
    }

    public AggregationDuration getAggregationDuration() {
        return this.aggregationDuration;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public GroupBy getGroupBy() {
        return this.groupBy;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryAnalyticsDetails(");
        sb.append("super=").append(super.toString());
        sb.append("authorEmail=").append(String.valueOf(this.authorEmail));
        sb.append(", repositoryMetrics=").append(String.valueOf(this.repositoryMetrics));
        sb.append(", aggregationDuration=").append(String.valueOf((Object)this.aggregationDuration));
        sb.append(", startTime=").append(String.valueOf(this.startTime));
        sb.append(", endTime=").append(String.valueOf(this.endTime));
        sb.append(", groupBy=").append(String.valueOf((Object)this.groupBy));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryAnalyticsDetails)) {
            return false;
        }
        RepositoryAnalyticsDetails other = (RepositoryAnalyticsDetails)((Object)o);
        return Objects.equals(this.authorEmail, other.authorEmail) && Objects.equals(this.repositoryMetrics, other.repositoryMetrics) && Objects.equals((Object)this.aggregationDuration, (Object)other.aggregationDuration) && Objects.equals(this.startTime, other.startTime) && Objects.equals(this.endTime, other.endTime) && Objects.equals((Object)this.groupBy, (Object)other.groupBy) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.authorEmail == null ? 43 : this.authorEmail.hashCode());
        result = result * 59 + (this.repositoryMetrics == null ? 43 : this.repositoryMetrics.hashCode());
        result = result * 59 + (this.aggregationDuration == null ? 43 : this.aggregationDuration.hashCode());
        result = result * 59 + (this.startTime == null ? 43 : this.startTime.hashCode());
        result = result * 59 + (this.endTime == null ? 43 : this.endTime.hashCode());
        result = result * 59 + (this.groupBy == null ? 43 : this.groupBy.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum GroupBy implements BmcEnum
    {
        Author("AUTHOR");

        private final String value;
        private static Map<String, GroupBy> map;

        private GroupBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static GroupBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid GroupBy: " + key);
        }

        static {
            map = new HashMap<String, GroupBy>();
            for (GroupBy v : GroupBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AggregationDuration implements BmcEnum
    {
        Daily("DAILY"),
        Weekly("WEEKLY"),
        Monthly("MONTHLY"),
        Yearly("YEARLY");

        private final String value;
        private static Map<String, AggregationDuration> map;

        private AggregationDuration(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AggregationDuration create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AggregationDuration: " + key);
        }

        static {
            map = new HashMap<String, AggregationDuration>();
            for (AggregationDuration v : AggregationDuration.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="authorEmail")
        private String authorEmail;
        @JsonProperty(value="repositoryMetrics")
        private List<MetricName> repositoryMetrics;
        @JsonProperty(value="aggregationDuration")
        private AggregationDuration aggregationDuration;
        @JsonProperty(value="startTime")
        private Date startTime;
        @JsonProperty(value="endTime")
        private Date endTime;
        @JsonProperty(value="groupBy")
        private GroupBy groupBy;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder authorEmail(String authorEmail) {
            this.authorEmail = authorEmail;
            this.__explicitlySet__.add("authorEmail");
            return this;
        }

        public Builder repositoryMetrics(List<MetricName> repositoryMetrics) {
            this.repositoryMetrics = repositoryMetrics;
            this.__explicitlySet__.add("repositoryMetrics");
            return this;
        }

        public Builder aggregationDuration(AggregationDuration aggregationDuration) {
            this.aggregationDuration = aggregationDuration;
            this.__explicitlySet__.add("aggregationDuration");
            return this;
        }

        public Builder startTime(Date startTime) {
            this.startTime = startTime;
            this.__explicitlySet__.add("startTime");
            return this;
        }

        public Builder endTime(Date endTime) {
            this.endTime = endTime;
            this.__explicitlySet__.add("endTime");
            return this;
        }

        public Builder groupBy(GroupBy groupBy) {
            this.groupBy = groupBy;
            this.__explicitlySet__.add("groupBy");
            return this;
        }

        public RepositoryAnalyticsDetails build() {
            RepositoryAnalyticsDetails model = new RepositoryAnalyticsDetails(this.authorEmail, this.repositoryMetrics, this.aggregationDuration, this.startTime, this.endTime, this.groupBy);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RepositoryAnalyticsDetails model) {
            if (model.wasPropertyExplicitlySet("authorEmail")) {
                this.authorEmail(model.getAuthorEmail());
            }
            if (model.wasPropertyExplicitlySet("repositoryMetrics")) {
                this.repositoryMetrics(model.getRepositoryMetrics());
            }
            if (model.wasPropertyExplicitlySet("aggregationDuration")) {
                this.aggregationDuration(model.getAggregationDuration());
            }
            if (model.wasPropertyExplicitlySet("startTime")) {
                this.startTime(model.getStartTime());
            }
            if (model.wasPropertyExplicitlySet("endTime")) {
                this.endTime(model.getEndTime());
            }
            if (model.wasPropertyExplicitlySet("groupBy")) {
                this.groupBy(model.getGroupBy());
            }
            return this;
        }
    }
}

