/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.MetricName;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RepositoryMetricSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricName")
    private final MetricName metricName;
    @JsonProperty(value="durationInSeconds")
    private final Long durationInSeconds;
    @JsonProperty(value="dimensions")
    private final Map<String, String> dimensions;
    @JsonProperty(value="startTimestampInEpochSeconds")
    private final Long startTimestampInEpochSeconds;
    @JsonProperty(value="count")
    private final Double count;
    @JsonProperty(value="sum")
    private final Double sum;

    @Deprecated
    @ConstructorProperties(value={"metricName", "durationInSeconds", "dimensions", "startTimestampInEpochSeconds", "count", "sum"})
    public RepositoryMetricSummary(MetricName metricName, Long durationInSeconds, Map<String, String> dimensions, Long startTimestampInEpochSeconds, Double count, Double sum) {
        this.metricName = metricName;
        this.durationInSeconds = durationInSeconds;
        this.dimensions = dimensions;
        this.startTimestampInEpochSeconds = startTimestampInEpochSeconds;
        this.count = count;
        this.sum = sum;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricName getMetricName() {
        return this.metricName;
    }

    public Long getDurationInSeconds() {
        return this.durationInSeconds;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Long getStartTimestampInEpochSeconds() {
        return this.startTimestampInEpochSeconds;
    }

    public Double getCount() {
        return this.count;
    }

    public Double getSum() {
        return this.sum;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RepositoryMetricSummary(");
        sb.append("super=").append(super.toString());
        sb.append("metricName=").append(String.valueOf((Object)this.metricName));
        sb.append(", durationInSeconds=").append(String.valueOf(this.durationInSeconds));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", startTimestampInEpochSeconds=").append(String.valueOf(this.startTimestampInEpochSeconds));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(", sum=").append(String.valueOf(this.sum));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RepositoryMetricSummary)) {
            return false;
        }
        RepositoryMetricSummary other = (RepositoryMetricSummary)((Object)o);
        return Objects.equals((Object)this.metricName, (Object)other.metricName) && Objects.equals(this.durationInSeconds, other.durationInSeconds) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.startTimestampInEpochSeconds, other.startTimestampInEpochSeconds) && Objects.equals(this.count, other.count) && Objects.equals(this.sum, other.sum) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.durationInSeconds == null ? 43 : this.durationInSeconds.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.startTimestampInEpochSeconds == null ? 43 : this.startTimestampInEpochSeconds.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + (this.sum == null ? 43 : this.sum.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricName")
        private MetricName metricName;
        @JsonProperty(value="durationInSeconds")
        private Long durationInSeconds;
        @JsonProperty(value="dimensions")
        private Map<String, String> dimensions;
        @JsonProperty(value="startTimestampInEpochSeconds")
        private Long startTimestampInEpochSeconds;
        @JsonProperty(value="count")
        private Double count;
        @JsonProperty(value="sum")
        private Double sum;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricName(MetricName metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder durationInSeconds(Long durationInSeconds) {
            this.durationInSeconds = durationInSeconds;
            this.__explicitlySet__.add("durationInSeconds");
            return this;
        }

        public Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder startTimestampInEpochSeconds(Long startTimestampInEpochSeconds) {
            this.startTimestampInEpochSeconds = startTimestampInEpochSeconds;
            this.__explicitlySet__.add("startTimestampInEpochSeconds");
            return this;
        }

        public Builder count(Double count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public Builder sum(Double sum) {
            this.sum = sum;
            this.__explicitlySet__.add("sum");
            return this;
        }

        public RepositoryMetricSummary build() {
            RepositoryMetricSummary model = new RepositoryMetricSummary(this.metricName, this.durationInSeconds, this.dimensions, this.startTimestampInEpochSeconds, this.count, this.sum);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RepositoryMetricSummary model) {
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("durationInSeconds")) {
                this.durationInSeconds(model.getDurationInSeconds());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("startTimestampInEpochSeconds")) {
                this.startTimestampInEpochSeconds(model.getStartTimestampInEpochSeconds());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            if (model.wasPropertyExplicitlySet("sum")) {
                this.sum(model.getSum());
            }
            return this;
        }
    }
}

