/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.PrincipalDetails;
import com.oracle.bmc.devops.model.PullRequestActivitySummary;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="activityType")
@JsonFilter(value="explicitlySetFilter")
public final class ReviewerActivitySummary
extends PullRequestActivitySummary {
    @JsonProperty(value="reviewersAdded")
    private final List<PrincipalDetails> reviewersAdded;
    @JsonProperty(value="reviewersRemoved")
    private final List<PrincipalDetails> reviewersRemoved;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ReviewerActivitySummary(String id, PrincipalDetails principal, String pullRequestId, Date timeOccurred, List<PrincipalDetails> reviewersAdded, List<PrincipalDetails> reviewersRemoved) {
        super(id, principal, pullRequestId, timeOccurred);
        this.reviewersAdded = reviewersAdded;
        this.reviewersRemoved = reviewersRemoved;
    }

    public List<PrincipalDetails> getReviewersAdded() {
        return this.reviewersAdded;
    }

    public List<PrincipalDetails> getReviewersRemoved() {
        return this.reviewersRemoved;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReviewerActivitySummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", reviewersAdded=").append(String.valueOf(this.reviewersAdded));
        sb.append(", reviewersRemoved=").append(String.valueOf(this.reviewersRemoved));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReviewerActivitySummary)) {
            return false;
        }
        ReviewerActivitySummary other = (ReviewerActivitySummary)((Object)o);
        return Objects.equals(this.reviewersAdded, other.reviewersAdded) && Objects.equals(this.reviewersRemoved, other.reviewersRemoved) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reviewersAdded == null ? 43 : this.reviewersAdded.hashCode());
        result = result * 59 + (this.reviewersRemoved == null ? 43 : this.reviewersRemoved.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="principal")
        private PrincipalDetails principal;
        @JsonProperty(value="pullRequestId")
        private String pullRequestId;
        @JsonProperty(value="timeOccurred")
        private Date timeOccurred;
        @JsonProperty(value="reviewersAdded")
        private List<PrincipalDetails> reviewersAdded;
        @JsonProperty(value="reviewersRemoved")
        private List<PrincipalDetails> reviewersRemoved;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder principal(PrincipalDetails principal) {
            this.principal = principal;
            this.__explicitlySet__.add("principal");
            return this;
        }

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            this.__explicitlySet__.add("pullRequestId");
            return this;
        }

        public Builder timeOccurred(Date timeOccurred) {
            this.timeOccurred = timeOccurred;
            this.__explicitlySet__.add("timeOccurred");
            return this;
        }

        public Builder reviewersAdded(List<PrincipalDetails> reviewersAdded) {
            this.reviewersAdded = reviewersAdded;
            this.__explicitlySet__.add("reviewersAdded");
            return this;
        }

        public Builder reviewersRemoved(List<PrincipalDetails> reviewersRemoved) {
            this.reviewersRemoved = reviewersRemoved;
            this.__explicitlySet__.add("reviewersRemoved");
            return this;
        }

        public ReviewerActivitySummary build() {
            ReviewerActivitySummary model = new ReviewerActivitySummary(this.id, this.principal, this.pullRequestId, this.timeOccurred, this.reviewersAdded, this.reviewersRemoved);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReviewerActivitySummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("principal")) {
                this.principal(model.getPrincipal());
            }
            if (model.wasPropertyExplicitlySet("pullRequestId")) {
                this.pullRequestId(model.getPullRequestId());
            }
            if (model.wasPropertyExplicitlySet("timeOccurred")) {
                this.timeOccurred(model.getTimeOccurred());
            }
            if (model.wasPropertyExplicitlySet("reviewersAdded")) {
                this.reviewersAdded(model.getReviewersAdded());
            }
            if (model.wasPropertyExplicitlySet("reviewersRemoved")) {
                this.reviewersRemoved(model.getReviewersRemoved());
            }
            return this;
        }
    }
}

