/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.InputStream;
import java.util.Objects;

public class CreatePullRequestAttachmentRequest
extends BmcRequest<InputStream> {
    private String pullRequestId;
    private String contentDisposition;
    private InputStream createPullRequestAttachmentBody;
    private String opcRetryToken;
    private String opcRequestId;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public InputStream getCreatePullRequestAttachmentBody() {
        return this.createPullRequestAttachmentBody;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public InputStream getBody$() {
        return this.createPullRequestAttachmentBody;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).contentDisposition(this.contentDisposition).createPullRequestAttachmentBody(this.createPullRequestAttachmentBody).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",contentDisposition=").append(String.valueOf(this.contentDisposition));
        sb.append(",createPullRequestAttachmentBody=").append(String.valueOf(this.createPullRequestAttachmentBody));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePullRequestAttachmentRequest)) {
            return false;
        }
        CreatePullRequestAttachmentRequest other = (CreatePullRequestAttachmentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals(this.contentDisposition, other.contentDisposition) && Objects.equals(this.createPullRequestAttachmentBody, other.createPullRequestAttachmentBody) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.contentDisposition == null ? 43 : this.contentDisposition.hashCode());
        result = result * 59 + (this.createPullRequestAttachmentBody == null ? 43 : this.createPullRequestAttachmentBody.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePullRequestAttachmentRequest, InputStream> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private String contentDisposition = null;
        private InputStream createPullRequestAttachmentBody = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder contentDisposition(String contentDisposition) {
            this.contentDisposition = contentDisposition;
            return this;
        }

        public Builder createPullRequestAttachmentBody(InputStream createPullRequestAttachmentBody) {
            this.createPullRequestAttachmentBody = createPullRequestAttachmentBody;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePullRequestAttachmentRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.contentDisposition(o.getContentDisposition());
            this.createPullRequestAttachmentBody(o.getCreatePullRequestAttachmentBody());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePullRequestAttachmentRequest build() {
            CreatePullRequestAttachmentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.createPullRequestAttachmentBody(body);
            return this;
        }

        public CreatePullRequestAttachmentRequest buildWithoutInvocationCallback() {
            CreatePullRequestAttachmentRequest request = new CreatePullRequestAttachmentRequest();
            request.pullRequestId = this.pullRequestId;
            request.contentDisposition = this.contentDisposition;
            request.createPullRequestAttachmentBody = this.createPullRequestAttachmentBody;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

