/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.CreatePullRequestCommentDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePullRequestCommentRequest
extends BmcRequest<CreatePullRequestCommentDetails> {
    private String pullRequestId;
    private CreatePullRequestCommentDetails createPullRequestCommentDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public CreatePullRequestCommentDetails getCreatePullRequestCommentDetails() {
        return this.createPullRequestCommentDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreatePullRequestCommentDetails getBody$() {
        return this.createPullRequestCommentDetails;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).createPullRequestCommentDetails(this.createPullRequestCommentDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",createPullRequestCommentDetails=").append(String.valueOf((Object)this.createPullRequestCommentDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePullRequestCommentRequest)) {
            return false;
        }
        CreatePullRequestCommentRequest other = (CreatePullRequestCommentRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals((Object)this.createPullRequestCommentDetails, (Object)other.createPullRequestCommentDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.createPullRequestCommentDetails == null ? 43 : this.createPullRequestCommentDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePullRequestCommentRequest, CreatePullRequestCommentDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private CreatePullRequestCommentDetails createPullRequestCommentDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder createPullRequestCommentDetails(CreatePullRequestCommentDetails createPullRequestCommentDetails) {
            this.createPullRequestCommentDetails = createPullRequestCommentDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePullRequestCommentRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.createPullRequestCommentDetails(o.getCreatePullRequestCommentDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePullRequestCommentRequest build() {
            CreatePullRequestCommentRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePullRequestCommentDetails body) {
            this.createPullRequestCommentDetails(body);
            return this;
        }

        public CreatePullRequestCommentRequest buildWithoutInvocationCallback() {
            CreatePullRequestCommentRequest request = new CreatePullRequestCommentRequest();
            request.pullRequestId = this.pullRequestId;
            request.createPullRequestCommentDetails = this.createPullRequestCommentDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

