/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.devops.model.CreatePullRequestDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePullRequestRequest
extends BmcRequest<CreatePullRequestDetails> {
    private CreatePullRequestDetails createPullRequestDetails;
    private String opcRetryToken;
    private String opcRequestId;

    public CreatePullRequestDetails getCreatePullRequestDetails() {
        return this.createPullRequestDetails;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public CreatePullRequestDetails getBody$() {
        return this.createPullRequestDetails;
    }

    public Builder toBuilder() {
        return new Builder().createPullRequestDetails(this.createPullRequestDetails).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",createPullRequestDetails=").append(String.valueOf((Object)this.createPullRequestDetails));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePullRequestRequest)) {
            return false;
        }
        CreatePullRequestRequest other = (CreatePullRequestRequest)((Object)o);
        return super.equals(o) && Objects.equals((Object)this.createPullRequestDetails, (Object)other.createPullRequestDetails) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.createPullRequestDetails == null ? 43 : this.createPullRequestDetails.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePullRequestRequest, CreatePullRequestDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private CreatePullRequestDetails createPullRequestDetails = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;

        public Builder createPullRequestDetails(CreatePullRequestDetails createPullRequestDetails) {
            this.createPullRequestDetails = createPullRequestDetails;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePullRequestRequest o) {
            this.createPullRequestDetails(o.getCreatePullRequestDetails());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePullRequestRequest build() {
            CreatePullRequestRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePullRequestDetails body) {
            this.createPullRequestDetails(body);
            return this;
        }

        public CreatePullRequestRequest buildWithoutInvocationCallback() {
            CreatePullRequestRequest request = new CreatePullRequestRequest();
            request.createPullRequestDetails = this.createPullRequestDetails;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

