/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetPullRequestNotificationPreferenceRequest
extends BmcRequest<Void> {
    private String pullRequestId;
    private String principalId;
    private String opcRequestId;

    public String getPullRequestId() {
        return this.pullRequestId;
    }

    public String getPrincipalId() {
        return this.principalId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().pullRequestId(this.pullRequestId).principalId(this.principalId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",pullRequestId=").append(String.valueOf(this.pullRequestId));
        sb.append(",principalId=").append(String.valueOf(this.principalId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetPullRequestNotificationPreferenceRequest)) {
            return false;
        }
        GetPullRequestNotificationPreferenceRequest other = (GetPullRequestNotificationPreferenceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.pullRequestId, other.pullRequestId) && Objects.equals(this.principalId, other.principalId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.pullRequestId == null ? 43 : this.pullRequestId.hashCode());
        result = result * 59 + (this.principalId == null ? 43 : this.principalId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetPullRequestNotificationPreferenceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String pullRequestId = null;
        private String principalId = null;
        private String opcRequestId = null;

        public Builder pullRequestId(String pullRequestId) {
            this.pullRequestId = pullRequestId;
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetPullRequestNotificationPreferenceRequest o) {
            this.pullRequestId(o.getPullRequestId());
            this.principalId(o.getPrincipalId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetPullRequestNotificationPreferenceRequest build() {
            GetPullRequestNotificationPreferenceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetPullRequestNotificationPreferenceRequest buildWithoutInvocationCallback() {
            GetPullRequestNotificationPreferenceRequest request = new GetPullRequestNotificationPreferenceRequest();
            request.pullRequestId = this.pullRequestId;
            request.principalId = this.principalId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

